/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.mcforge;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;
import tonius.neiintegration.config.Config;

public class RecipeHandlerFluidRegistry
extends RecipeHandlerBase {
    public String getRecipeName() {
        return Utils.translate("handler.fluidRegistry");
    }

    @Override
    public String getRecipeID() {
        return "forge.fluidRegistry";
    }

    public String getGuiTexture() {
        return "neiintegration:textures/fluidRegistry.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(91, 42, 17, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)65);
    }

    @Override
    public List<String> provideTooltip(GuiRecipe guiRecipe, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        super.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        Rectangle tank = ((CachedFluidRegistryRecipe)crecipe).fluid.position;
        Fluid fluid = ((CachedFluidRegistryRecipe)crecipe).fluid.tank.getFluid().getFluid();
        if (tank.contains(relMouse)) {
            currenttip.add(EnumChatFormatting.GOLD + Utils.translate("handler.fluidRegistry.id") + " " + EnumChatFormatting.GRAY + fluid.getName() + " (" + fluid.getID() + ")");
            currenttip.add(EnumChatFormatting.GOLD + Utils.translate("handler.fluidRegistry.state") + " " + EnumChatFormatting.GRAY + (fluid.isGaseous() ? Utils.translate("handler.fluidRegistry.state.gaseous") : Utils.translate("handler.fluidRegistry.state.liquid")));
            currenttip.add(EnumChatFormatting.GOLD + Utils.translate("handler.fluidRegistry.placeable") + " " + EnumChatFormatting.GRAY + (fluid.canBePlacedInWorld() ? Utils.translate("yes") : Utils.translate("no")));
            currenttip.add("");
            currenttip.add(EnumChatFormatting.GOLD + Utils.translate("handler.fluidRegistry.temperature") + " " + EnumChatFormatting.GRAY + fluid.getTemperature());
            currenttip.add(EnumChatFormatting.GOLD + Utils.translate("handler.fluidRegistry.luminosity") + " " + EnumChatFormatting.GRAY + fluid.getLuminosity());
            currenttip.add(EnumChatFormatting.GOLD + Utils.translate("handler.fluidRegistry.density") + " " + EnumChatFormatting.GRAY + fluid.getDensity());
            currenttip.add(EnumChatFormatting.GOLD + Utils.translate("handler.fluidRegistry.viscosity") + " " + EnumChatFormatting.GRAY + fluid.getViscosity());
        }
        return currenttip;
    }

    public List<Fluid> getFluids() {
        LinkedList<Fluid> fluids = new LinkedList<Fluid>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid == null) continue;
            fluids.add(fluid);
        }
        Collections.sort(fluids, new Comparator<Fluid>(){

            @Override
            public int compare(Fluid f1, Fluid f2) {
                if (f1 == null || f2 == null) {
                    return 0;
                }
                return Integer.compare(f1.getID(), f2.getID());
            }
        });
        return fluids;
    }

    @Override
    public void loadAllRecipes() {
        if (Config.handlerFluidRegistry) {
            for (Fluid fluid : this.getFluids()) {
                this.arecipes.add(new CachedFluidRegistryRecipe(fluid));
            }
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (Utils.isFluidBlock(result)) {
            super.loadCraftingRecipes(result);
        }
        if (Config.handlerFluidRegistry) {
            for (Fluid fluid : this.getFluids()) {
                CachedFluidRegistryRecipe crecipe = new CachedFluidRegistryRecipe(fluid);
                if (crecipe.filledContainer == null || !crecipe.filledContainer.contains(result)) continue;
                crecipe.setPermutation(crecipe.filledContainer, result);
                for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (!Utils.areStacksSameTypeCraftingSafe(data.filledContainer, result)) continue;
                    crecipe.setPermutation(crecipe.emptyContainer, data.emptyContainer);
                }
                this.arecipes.add(crecipe);
            }
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        if (Config.handlerFluidRegistry) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid != result.getFluid()) continue;
                this.arecipes.add(new CachedFluidRegistryRecipe(fluid));
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        super.loadUsageRecipes(ingredient);
        if (Config.handlerFluidRegistry) {
            for (Fluid fluid : this.getFluids()) {
                CachedFluidRegistryRecipe crecipe = new CachedFluidRegistryRecipe(fluid);
                if (crecipe.emptyContainer == null || !crecipe.emptyContainer.contains(ingredient)) continue;
                crecipe.setPermutation(crecipe.emptyContainer, ingredient);
                for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (!Utils.areStacksSameTypeCraftingSafe(data.emptyContainer, ingredient)) continue;
                    crecipe.setPermutation(crecipe.filledContainer, data.filledContainer);
                }
                this.arecipes.add(crecipe);
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (Config.handlerFluidRegistry) {
            for (Fluid fluid : this.getFluids()) {
                if (fluid != ingredient.getFluid()) continue;
                this.arecipes.add(new CachedFluidRegistryRecipe(fluid));
            }
        }
    }

    public class CachedFluidRegistryRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank fluid;
        public PositionedStack block = null;
        public PositionedStack emptyContainer = null;
        public PositionedStack filledContainer = null;

        public CachedFluidRegistryRecipe(Fluid fluid) {
            this.fluid = new PositionedFluidTank(new FluidStack(fluid, 1000), 1000, new Rectangle(32, 5, 96, 32));
            this.fluid.showAmount = false;
            if (fluid.getBlock() != null) {
                this.block = new PositionedStack((Object)new ItemStack(fluid.getBlock()), 32, 43);
            }
            this.setContainerItems(fluid);
        }

        private void setContainerItems(Fluid fluid) {
            ArrayList<ItemStack> emptyContainers = new ArrayList<ItemStack>();
            ArrayList<ItemStack> filledContainers = new ArrayList<ItemStack>();
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data.fluid.getFluid() != fluid) continue;
                emptyContainers.add(data.emptyContainer);
                filledContainers.add(data.filledContainer);
            }
            if (!emptyContainers.isEmpty() && !filledContainers.isEmpty()) {
                this.emptyContainer = new PositionedStack(emptyContainers, 71, 43);
                this.filledContainer = new PositionedStack(filledContainers, 112, 43);
            }
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.fluid;
        }

        public PositionedStack getOtherStack() {
            return this.block;
        }

        public PositionedStack getIngredient() {
            if (this.emptyContainer != null) {
                this.randomRenderPermutation(this.emptyContainer, RecipeHandlerFluidRegistry.this.cycleticks / 20);
            }
            return this.emptyContainer;
        }

        public PositionedStack getResult() {
            if (this.filledContainer != null) {
                this.randomRenderPermutation(this.filledContainer, RecipeHandlerFluidRegistry.this.cycleticks / 20);
            }
            return this.filledContainer;
        }

        public void setPermutation(PositionedStack pStack, ItemStack stack) {
            if (pStack != null) {
                for (int i = 0; i < pStack.items.length; ++i) {
                    if (!Utils.areStacksSameTypeCraftingSafe(stack, pStack.items[i])) continue;
                    pStack.item = pStack.items[i];
                    pStack.item.func_77964_b(stack.func_77960_j());
                    pStack.items = new ItemStack[]{pStack.item};
                    pStack.setPermutationToRender(0);
                    break;
                }
            }
        }
    }
}

