/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.minefactoryreloaded;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySlaughterhouse;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerSlaughterhouse
extends RecipeHandlerBase {
    private static int energyPerOperation;

    @Override
    public void prepare() {
        TileEntitySlaughterhouse dummy = new TileEntitySlaughterhouse();
        energyPerOperation = dummy.getActivationEnergy() * dummy.getWorkMax();
        dummy = null;
    }

    public String getRecipeName() {
        return Utils.translate("tile.mfr.machine.slaughterhouse.name", false);
    }

    @Override
    public String getRecipeID() {
        return "minefactoryreloaded.slaughterhouse";
    }

    public String getGuiTexture() {
        return "minefactoryreloaded:textures/gui/slaughterhouse.png";
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)11, (int)13, (int)160, (int)65);
        this.changeToOverlayTexture();
        GuiDraw.drawTexturedModalRect((int)56, (int)25, (int)0, (int)0, (int)22, (int)15);
        GuiDraw.drawTexturedModalRect((int)28, (int)24, (int)0, (int)64, (int)16, (int)16);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(129, 0, 176, 58, 8, 62, 1.0f, 3);
        this.drawProgressBar(139, 0, 185, 58, 8, 62, 20, 3);
    }

    @Override
    public List<String> provideTooltip(GuiRecipe guiRecipe, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        super.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        if (new Rectangle(28, 24, 16, 16).contains(relMouse)) {
            currenttip.add(Utils.translate("handler.slaughterhouse.animals"));
            currenttip.add(EnumChatFormatting.GRAY + Utils.translate("handler.slaughterhouse.animals.1"));
        } else if (new Rectangle(129, 2, 8, 60).contains(relMouse)) {
            currenttip.add(energyPerOperation + " RF");
        }
        return currenttip;
    }

    @Override
    public void loadAllRecipes() {
        this.arecipes.add(new CachedSlaughterhouseRecipe());
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        if (result.getFluid().getName() == null) {
            return;
        }
        if (result.getFluid().getName().equals("meat") || result.getFluid().getName().equals("pinkslime")) {
            this.loadAllRecipes();
        }
    }

    public class CachedSlaughterhouseRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();

        public CachedSlaughterhouseRecipe() {
            PositionedFluidTank tank = new PositionedFluidTank(FluidRegistry.getFluidStack((String)"meat", (int)4000), 4000, new Rectangle(111, 2, 16, 60), RecipeHandlerSlaughterhouse.this.getGuiTexture(), new Point(176, 0));
            tank.showAmount = false;
            this.tanks.add(tank);
            tank = new PositionedFluidTank(FluidRegistry.getFluidStack((String)"pinkslime", (int)4000), 4000, new Rectangle(91, 2, 16, 60), RecipeHandlerSlaughterhouse.this.getGuiTexture(), new Point(176, 0));
            tank.showAmount = false;
            this.tanks.add(tank);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public List<PositionedFluidTank> getFluidTanks() {
            return this.tanks;
        }
    }
}

