/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages;

import neresources.api.messages.RegistryMessage;
import neresources.api.messages.utils.MessageHelper;
import neresources.api.utils.DropItem;
import neresources.api.utils.LightLevel;
import neresources.api.utils.Priority;
import neresources.utils.ReflectionHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class RegisterMobMessage
extends RegistryMessage {
    private Class mobClass;
    private LightLevel lightLevel;
    private DropItem[] drops;

    public RegisterMobMessage(Class clazz) {
        this(clazz, LightLevel.any);
    }

    public RegisterMobMessage(Class clazz, LightLevel level) {
        this(clazz, level, new DropItem[0]);
    }

    public RegisterMobMessage(Class clazz, LightLevel level, DropItem[] drops) {
        this(Priority.FIRST, clazz, level, drops);
    }

    public RegisterMobMessage(Priority priority, Class clazz, LightLevel level, DropItem[] drops) {
        super(priority, true);
        this.mobClass = clazz;
        this.lightLevel = level;
        this.drops = drops;
    }

    public RegisterMobMessage(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.mobClass = ReflectionHelper.findClass(tagCompound.func_74779_i("name"));
        this.lightLevel = LightLevel.decodeLightLevel(tagCompound.func_74779_i("lightLevel"));
        this.drops = MessageHelper.getDropItems(tagCompound, "addDrops");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74778_a("name", this.mobClass.getName());
        tagCompound.func_74778_a("lightLevel", this.lightLevel.encode());
        tagCompound.func_74782_a("addDrops", (NBTBase)MessageHelper.getDropItemList(this.drops));
        return tagCompound;
    }

    @Override
    public boolean isValid() {
        return this.mobClass != null;
    }

    public Class getMobClass() {
        return this.mobClass;
    }

    public LightLevel getLightLevel() {
        return this.lightLevel;
    }

    public DropItem[] getDrops() {
        return this.drops;
    }
}

