/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.util;

import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.reference.Reference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockList {
    public List<WrappedItemStack> getList(EntityPlayer player, SchematicWorld world, WorldClient mcWorld) {
        ArrayList<WrappedItemStack> blockList = new ArrayList<WrappedItemStack>();
        if (world == null) {
            return blockList;
        }
        MovingObjectPosition movingObjectPosition = new MovingObjectPosition((Entity)player);
        for (int y = 0; y < world.func_72800_K(); ++y) {
            for (int x = 0; x < world.getWidth(); ++x) {
                for (int z = 0; z < world.getLength(); ++z) {
                    Block block;
                    if (world.isRenderingLayer && y != world.renderingLayer || (block = world.func_147439_a(x, y, z)) == Blocks.field_150350_a || world.func_147437_c(x, y, z)) continue;
                    int wx = world.position.x + x;
                    int wy = world.position.y + y;
                    int wz = world.position.z + z;
                    Block mcBlock = mcWorld.func_147439_a(wx, wy, wz);
                    boolean isPlaced = block == mcBlock && world.func_72805_g(x, y, z) == mcWorld.func_72805_g(wx, wy, wz);
                    ItemStack stack = null;
                    try {
                        stack = block.getPickBlock(movingObjectPosition, (World)world, x, y, z, player);
                    }
                    catch (Exception e) {
                        Reference.logger.debug("Could not get the pick block for: {}", new Object[]{block, e});
                    }
                    if (stack == null || stack.func_77973_b() == null) {
                        Reference.logger.debug("Could not find the item for: {}", new Object[]{block});
                        continue;
                    }
                    WrappedItemStack wrappedItemStack = this.findOrCreateWrappedItemStackFor(blockList, stack);
                    if (isPlaced) {
                        ++wrappedItemStack.placed;
                    }
                    ++wrappedItemStack.total;
                }
            }
        }
        return blockList;
    }

    private WrappedItemStack findOrCreateWrappedItemStackFor(List<WrappedItemStack> blockList, ItemStack itemStack) {
        for (WrappedItemStack wrappedItemStack : blockList) {
            if (!wrappedItemStack.itemStack.func_77969_a(itemStack)) continue;
            return wrappedItemStack;
        }
        WrappedItemStack wrappedItemStack = new WrappedItemStack(itemStack.func_77946_l());
        blockList.add(wrappedItemStack);
        return wrappedItemStack;
    }

    public static class WrappedItemStack {
        public ItemStack itemStack;
        public int placed;
        public int total;

        public WrappedItemStack(ItemStack itemStack) {
            this(itemStack, 0, 0);
        }

        public WrappedItemStack(ItemStack itemStack, int placed, int total) {
            this.itemStack = itemStack;
            this.placed = placed;
            this.total = total;
        }

        public String getItemStackDisplayName() {
            return this.itemStack.func_77973_b().func_77653_i(this.itemStack);
        }

        public String getFormattedAmount() {
            char color = this.placed < this.total ? (char)'c' : 'a';
            return String.format("\u00a7%c%d\u00a7r/%d", Character.valueOf(color), this.placed, this.total);
        }
    }
}

