/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.schematic;

import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.api.event.PostSchematicCaptureEvent;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicAlpha;
import com.github.lunatrius.schematica.world.schematic.SchematicClassic;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import com.github.lunatrius.schematica.world.schematic.UnsupportedFormatException;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public abstract class SchematicFormat {
    public static final Map<String, SchematicFormat> FORMATS = new HashMap<String, SchematicFormat>();
    public static String FORMAT_DEFAULT;

    public abstract ISchematic readFromNBT(NBTTagCompound var1);

    public abstract boolean writeToNBT(NBTTagCompound var1, ISchematic var2);

    public static ISchematic readFromFile(File file) {
        try {
            NBTTagCompound tagCompound = SchematicUtil.readTagCompoundFromFile(file);
            String format = tagCompound.func_74779_i("Materials");
            SchematicFormat schematicFormat = FORMATS.get(format);
            if (schematicFormat == null) {
                throw new UnsupportedFormatException(format);
            }
            return schematicFormat.readFromNBT(tagCompound);
        }
        catch (Exception ex) {
            Reference.logger.error("Failed to read schematic!", (Throwable)ex);
            return null;
        }
    }

    public static ISchematic readFromFile(File directory, String filename) {
        return SchematicFormat.readFromFile(new File(directory, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(File file, ISchematic schematic) {
        try {
            PostSchematicCaptureEvent event = new PostSchematicCaptureEvent(schematic);
            MinecraftForge.EVENT_BUS.post((Event)event);
            NBTTagCompound tagCompound = new NBTTagCompound();
            FORMATS.get(FORMAT_DEFAULT).writeToNBT(tagCompound, schematic);
            DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
            try {
                NBTTagCompound.func_150298_a((String)"Schematic", (NBTBase)tagCompound, (DataOutput)dataOutputStream);
            }
            finally {
                dataOutputStream.close();
            }
            return true;
        }
        catch (Exception ex) {
            Reference.logger.error("Failed to write schematic!", (Throwable)ex);
            return false;
        }
    }

    public static boolean writeToFile(File directory, String filename, ISchematic schematic) {
        return SchematicFormat.writeToFile(new File(directory, filename), schematic);
    }

    static {
        FORMATS.put("Classic", new SchematicClassic());
        FORMATS.put("Alpha", new SchematicAlpha());
        FORMAT_DEFAULT = "Alpha";
    }
}

