/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.logic;

import mantle.blocks.abstracts.MultiServantLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class LavaTankLogic
extends MultiServantLogic
implements IFluidHandler {
    public FluidTank tank = new FluidTank(4000);
    public int renderOffset;

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.renderOffset += resource.amount;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.renderOffset = -maxDrain;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank.getFluidAmount() == 0) {
            return null;
        }
        if (this.tank.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluidAmount() == 0 || this.tank.getFluid().getFluid() == fluid && this.tank.getFluidAmount() < this.tank.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidStack fluid = null;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().copy();
        }
        return new FluidTankInfo[]{new FluidTankInfo(fluid, this.tank.getCapacity())};
    }

    public float getFluidAmountScaled() {
        return (float)(this.tank.getFluid().amount - this.renderOffset) / ((float)this.tank.getCapacity() * 1.01f);
    }

    public boolean containsFluid() {
        return this.tank.getFluid() != null;
    }

    public int getBrightness() {
        if (this.containsFluid()) {
            return this.tank.getFluid().getFluid().getLuminosity() * this.tank.getFluidAmount() / this.tank.getCapacity();
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        if (tags.func_74767_n("hasFluid")) {
            if (tags.func_74762_e("itemID") != 0) {
                this.tank.setFluid(new FluidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount")));
            } else {
                this.tank.setFluid(FluidRegistry.getFluidStack((String)tags.func_74779_i("fluidName"), (int)tags.func_74762_e("amount")));
            }
        } else {
            this.tank.setFluid(null);
        }
        if (tags.func_74764_b("renderOffset")) {
            this.renderOffset = tags.func_74762_e("renderOffset");
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        FluidStack liquid = this.tank.getFluid();
        tags.func_74757_a("hasFluid", liquid != null);
        if (liquid != null) {
            tags.func_74778_a("fluidName", liquid.getFluid().getName());
            tags.func_74768_a("amount", liquid.amount);
        }
        tags.func_74768_a("renderOffset", this.renderOffset);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.renderOffset != 0) {
            this.renderOffset -= this.renderOffset / 12 + 1;
            if (this.renderOffset < 0) {
                this.renderOffset = 0;
            }
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int comparatorStrength() {
        return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }
}

