/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityHomingShard
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private Class targetClass;
    private boolean persistent;
    private EntityLivingBase target;
    private static final Material[] MATS = new Material[]{Material.field_151585_k, Material.field_151579_a, Material.field_151584_j, Material.field_151567_E, Material.field_151582_l, Material.field_151569_G};

    public EntityHomingShard(World world) {
        super(world);
    }

    public EntityHomingShard(World world, EntityLivingBase thrower, EntityLivingBase target, int strength, boolean persistent) {
        super(world, thrower);
        this.target = target;
        this.targetClass = target.getClass();
        this.persistent = persistent;
        this.setStrength(strength);
        Vec3 vec = thrower.func_70040_Z();
        this.func_70012_b(thrower.field_70165_t + vec.field_72450_a / 2.0, thrower.field_70163_u + (double)thrower.func_70047_e() + vec.field_72448_b / 2.0, thrower.field_70161_v + vec.field_72449_c / 2.0, thrower.field_70177_z, thrower.field_70125_A);
        float f = 0.5f;
        float ry = thrower.field_70177_z + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 60.0f;
        float rp = thrower.field_70125_A + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 60.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(ry / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rp / 180.0f * (float)Math.PI)) * 0.5f;
        this.field_70179_y = MathHelper.func_76134_b((float)(ry / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rp / 180.0f * (float)Math.PI)) * 0.5f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(rp / 180.0f * (float)Math.PI)) * 0.5f;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public void setStrength(int strength) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)strength));
    }

    public int getStrength() {
        return this.field_70180_af.func_75683_a(17);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void writeSpawnData(ByteBuf buf) {
        int id = -1;
        if (this.target != null) {
            id = this.target.func_145782_y();
        }
        buf.writeInt(id);
    }

    public void readSpawnData(ByteBuf buf) {
        int id = buf.readInt();
        if (id >= 0) {
            this.target = (EntityLivingBase)this.field_70170_p.func_73045_a(id);
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K && mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && (this.func_85052_h() == null || this.func_85052_h() != null && mop.field_72308_g != this.func_85052_h())) {
            mop.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.func_85052_h()), 2.0f + (float)this.getStrength() * 0.5f);
            this.field_70170_p.func_72956_a((Entity)this, "thaumcraft:zap", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)16);
            this.func_70106_y();
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            ArrayList whitelisted = new ArrayList(MATS.length);
            Collections.addAll(whitelisted, MATS);
            if (!whitelisted.contains(block.func_149688_o())) {
                this.field_70179_y *= -0.8;
                this.field_70159_w *= -0.8;
                this.field_70181_x *= -0.8;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 16) {
            Thaumcraft.proxy.burst(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.3f);
        } else {
            super.func_70103_a(b);
        }
    }

    public void func_70071_h_() {
        double motion = Math.abs(this.field_70159_w) + Math.abs(this.field_70181_x) + Math.abs(this.field_70179_y);
        if (motion > 0.0 && this.field_70170_p.field_72995_K) {
            Thaumcraft.proxy.sparkle((float)this.field_70165_t + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.25f, (float)this.field_70163_u + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.25f, (float)this.field_70161_v + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.25f, 0.5f, 0, 0.0f);
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.persistent && (this.target == null || this.target.field_70128_L || this.target.func_70068_e((Entity)this) > 1250.0)) {
                ArrayList ents = EntityUtils.getEntitiesInRange((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (Entity)this, (Class)this.targetClass, (double)16.0);
                for (Entity entity : ents) {
                    if (!(entity instanceof EntityLivingBase) || entity.field_70128_L || this.func_85052_h() != null && entity.func_145782_y() == this.func_85052_h().func_145782_y()) continue;
                    this.target = (EntityLivingBase)entity;
                    break;
                }
            }
            if (this.target == null || this.target.field_70128_L) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)16);
                this.func_70106_y();
            }
        }
        if (this.field_70173_aa > 300) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)16);
            this.func_70106_y();
        }
        if (this.field_70173_aa % 10 == 0 && this.target != null && !this.target.field_70128_L) {
            double d = this.func_70032_d((Entity)this.target);
            double dx = this.target.field_70165_t - this.field_70165_t;
            double dy = this.target.field_70121_D.field_72338_b + (double)this.target.field_70131_O * 0.6 - this.field_70163_u;
            double dz = this.target.field_70161_v - this.field_70161_v;
            this.field_70159_w = dx /= d;
            this.field_70181_x = dy /= d;
            this.field_70179_y = dz /= d;
            this.field_70170_p.func_72956_a((Entity)this, "taintedmagic:shard", 0.1f, 2.0f * this.field_70170_p.field_73012_v.nextFloat());
        }
        this.field_70159_w *= 0.85;
        this.field_70181_x *= 0.85;
        this.field_70179_y *= 0.85;
    }
}

