/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.lwjgl.opengl.GL11;
import taintedmagic.api.IRenderInventoryItem;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.IWarpingGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.lib.UtilsFX;

public class ItemFlyteCharm
extends Item
implements IWarpingGear,
IRenderInventoryItem {
    private static final AspectList COST_FLIGHT = new AspectList().add(Aspect.AIR, 15);
    private static final AspectList COST_GLIDE = new AspectList().add(Aspect.AIR, 5);
    private static final ResourceLocation MAGIC_CIRCLE = new ResourceLocation("taintedmagic:textures/misc/circle.png");
    public static final Set<String> FLIGHT_MANAGER = new HashSet<String>();

    public ItemFlyteCharm() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77655_b("ItemFlyteCharm");
        this.func_77625_d(1);
        this.func_111206_d("taintedmagic:ItemFlyteCharm");
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return TaintedMagic.rarityCreation;
    }

    @SubscribeEvent
    public void updateFlight(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            String entry = ItemFlyteCharm.getPlayerEntry(player, player.field_70170_p.field_72995_K);
            if (FLIGHT_MANAGER.contains(entry)) {
                if (this.canFly(player)) {
                    player.field_71075_bZ.field_75101_c = true;
                    boolean isFlying = player.field_71075_bZ.field_75100_b;
                    TaintedMagicHelper.consumeVisFromInventory(player, COST_FLIGHT, isFlying);
                    if (!isFlying && player.func_70093_af() && !player.field_70122_E && player.field_70143_R > 0.5f && TaintedMagicHelper.consumeVisFromInventory(player, COST_GLIDE, true)) {
                        double speed = 0.1;
                        player.field_70181_x = -0.1;
                        player.field_70159_w += Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * 0.1;
                        player.field_70179_y += Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * 0.1;
                    }
                } else {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                    }
                    FLIGHT_MANAGER.remove(entry);
                }
            } else if (this.canFly(player)) {
                FLIGHT_MANAGER.add(entry);
                player.field_71075_bZ.field_75101_c = true;
            }
        }
    }

    private boolean canFly(EntityPlayer player) {
        boolean hasVis = TaintedMagicHelper.consumeVisFromInventory(player, COST_FLIGHT, false);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemFlyteCharm)) continue;
            return hasVis;
        }
        return false;
    }

    private static String getPlayerEntry(EntityPlayer player, boolean remote) {
        return player.func_110124_au().toString() + ":" + remote;
    }

    @SubscribeEvent
    private void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        FLIGHT_MANAGER.remove(ItemFlyteCharm.getPlayerEntry(event.player, true));
        FLIGHT_MANAGER.remove(ItemFlyteCharm.getPlayerEntry(event.player, false));
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return 5;
    }

    @Override
    public void render(EntityPlayer player, ItemStack stack, float partialTicks) {
        Tessellator t = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslated((double)0.0, (double)((double)((player != Minecraft.func_71410_x().field_71439_g ? 1.62f : 0.0f) - player.getDefaultEyeHeight()) + (player.func_70093_af() ? 0.0625 : 0.0)), (double)0.0);
        GL11.glRotatef((float)45.0f, (float)-1.0f, (float)0.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.2f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glShadeModel((int)7425);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        GL11.glRotatef((float)((float)player.field_70173_aa + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        UtilsFX.bindTexture((ResourceLocation)MAGIC_CIRCLE);
        t.func_78382_b();
        t.func_78374_a(-1.0, 0.0, -1.0, 0.0, 0.0);
        t.func_78374_a(-1.0, 0.0, 1.0, 0.0, 1.0);
        t.func_78374_a(1.0, 0.0, 1.0, 1.0, 1.0);
        t.func_78374_a(1.0, 0.0, -1.0, 1.0, 0.0);
        t.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

