/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.tools;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import taintedmagic.client.handler.HUDHandler;
import taintedmagic.common.TaintedMagic;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.wands.WandManager;

public class ItemThaumicDisassembler
extends Item {
    public static final String TAG_MODE = "mode";
    public static final String TAG_CHARGE = "charge";
    public static final int MAX_CHARGE = 50000;
    public static final int ENTROPY_USAGE_BASE = 5;
    public static final int ENTROPY_USAGE_HOE = 25;
    public static final int ENTROPY_USAGE_HIT = 50;

    public ItemThaumicDisassembler() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77625_d(1);
        this.func_77655_b("ItemThaumicDisassembler");
        this.func_111206_d("taintedmagic:ItemThaumicDisassembler");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemThaumicDisassembler.getEntropyCharge(stack) / 50000.0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add(StatCollector.func_74838_a((String)"text.disassembler.charge") + ": " + EnumChatFormatting.DARK_GRAY + ItemThaumicDisassembler.getEntropyCharge(stack) / 100 + "/" + 500);
        list.add(StatCollector.func_74838_a((String)"text.disassembler.mode") + ": " + ItemThaumicDisassembler.getModeName(stack));
        list.add(StatCollector.func_74838_a((String)"text.disassembler.efficiency") + ": " + (ItemThaumicDisassembler.getMode(stack) == 3 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + ItemThaumicDisassembler.getEfficiency(stack));
        list.add(" ");
        list.add(EnumChatFormatting.BLUE + "+20 " + StatCollector.func_74838_a((String)"text.attackdamage"));
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return block != Blocks.field_150357_h;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        if (player != null) {
            if (ItemThaumicDisassembler.getEntropyCharge(stack) > 0) {
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), 20.0f);
                this.consumeEntropy(stack, 50);
            } else {
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), 4.0f);
            }
        }
        return false;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return ItemThaumicDisassembler.getEfficiency(stack);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            this.consumeEntropy(stack, (int)(5.0 * (double)ItemThaumicDisassembler.getEfficiency(stack) / 8.0));
        }
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (stack.field_77990_d == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.field_77990_d.func_74768_a(TAG_MODE, ItemThaumicDisassembler.getMode(stack) < 3 ? ItemThaumicDisassembler.getMode(stack) + 1 : 0);
            String str = EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"text.disassembler.mode") + ": " + ItemThaumicDisassembler.getModeName(ItemThaumicDisassembler.getMode(stack)) + (ItemThaumicDisassembler.getMode(stack) == 3 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + " (" + ItemThaumicDisassembler.getEfficiency(stack) + ")";
            HUDHandler.displayString(str, 300, false);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && ItemThaumicDisassembler.getMode(stack) != 3) {
            if (!this.useHoe(stack, player, world, x, y, z, side) && world.func_147439_a(x, y, z) != Blocks.field_150458_ak) {
                return false;
            }
            if (ItemThaumicDisassembler.getMode(stack) == 1) {
                return true;
            }
            int rad = ItemThaumicDisassembler.getMode(stack) == 0 ? 1 : 2;
            for (int x1 = x - rad; x1 <= x + rad; ++x1) {
                for (int z1 = z - rad; z1 <= z + rad; ++z1) {
                    this.useHoe(stack, player, world, x1, y, z1, side);
                }
            }
            return true;
        }
        return false;
    }

    private boolean useHoe(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!player.func_82247_a(x, y, z, side, stack) || !player.field_71075_bZ.field_75098_d && ItemThaumicDisassembler.getEntropyCharge(stack) < 25) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.consumeEntropy(stack, 25);
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        boolean air = world.func_147437_c(x, y + 1, z);
        if (side == 0 || !air || block != Blocks.field_150349_c && block != Blocks.field_150346_d) {
            return false;
        }
        Block farm = Blocks.field_150458_ak;
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), farm.field_149762_H.func_150498_e(), (farm.field_149762_H.func_150497_c() + 1.0f) / 2.0f, farm.field_149762_H.func_150494_d() * 0.8f);
        if (!world.field_72995_K) {
            world.func_147449_b(x, y, z, farm);
            if (!player.field_71075_bZ.field_75098_d) {
                this.consumeEntropy(stack, 25);
            }
        }
        return true;
    }

    public static int getEfficiency(ItemStack stack) {
        int ent = ItemThaumicDisassembler.getEntropyCharge(stack);
        if (ent <= 0) {
            return 0;
        }
        int mode = ItemThaumicDisassembler.getMode(stack);
        switch (mode) {
            case 0: {
                return 20;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    public static int getMode(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 0;
        }
        return stack.field_77990_d.func_74762_e(TAG_MODE);
    }

    public static String getModeName(int mode) {
        switch (mode) {
            case 0: {
                return "\u00a7a" + StatCollector.func_74838_a((String)"text.disassembler.normal");
            }
            case 1: {
                return "\u00a7a" + StatCollector.func_74838_a((String)"text.disassembler.slow");
            }
            case 2: {
                return "\u00a7a" + StatCollector.func_74838_a((String)"text.disassembler.fast");
            }
            case 3: {
                return "\u00a7c" + StatCollector.func_74838_a((String)"text.disassembler.off");
            }
        }
        return null;
    }

    public static String getModeName(ItemStack stack) {
        return ItemThaumicDisassembler.getModeName(ItemThaumicDisassembler.getMode(stack));
    }

    private void addEntropy(ItemStack stack, int amount) {
        if (stack.func_77978_p() == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.func_77978_p().func_74768_a(TAG_CHARGE, ItemThaumicDisassembler.getEntropyCharge(stack) + amount);
    }

    private void consumeEntropy(ItemStack stack, int amount) {
        if (stack.func_77978_p() == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.func_77978_p().func_74768_a(TAG_CHARGE, Math.max(ItemThaumicDisassembler.getEntropyCharge(stack) - amount, 0));
    }

    private static int getEntropyCharge(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(TAG_CHARGE);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean b) {
        super.func_77663_a(stack, world, entity, i, b);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!world.field_72995_K && ItemThaumicDisassembler.getEntropyCharge(stack) < 50000 && entity.field_70173_aa % 20 == 0) {
                int amount = 50000 - ItemThaumicDisassembler.getEntropyCharge(stack);
                if (amount > 100) {
                    amount = 100;
                }
                if (WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)new AspectList().add(Aspect.ENTROPY, amount))) {
                    this.addEntropy(stack, amount);
                }
            }
        }
    }
}

