/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.items.wand.foci.TMFocusUpgrades;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.EntityTaintSwarm;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemFocusTaintSwarm
extends ItemFocusBasic {
    private IIcon depthIcon;
    private IIcon ornIcon;
    private static final AspectList COST = new AspectList().add(Aspect.EARTH, 50).add(Aspect.WATER, 50);
    private static final AspectList COST_ANTIBODY = COST.copy().add(Aspect.ORDER, 10);

    public ItemFocusTaintSwarm() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77655_b("ItemFocusTaintSwarm");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusTaintSwarm");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusTaintSwarm_depth");
        this.ornIcon = ir.func_94245_a("thaumcraft:focus_whatever_orn");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack stack) {
        return this.depthIcon;
    }

    public IIcon getOrnament(ItemStack stack) {
        return this.ornIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        return pass == 0 ? this.ornIcon : this.icon;
    }

    public String getSortingHelper(ItemStack stack) {
        return "TAINT" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 10037693;
    }

    public AspectList getVisCost(ItemStack stack) {
        return this.isUpgradedWith(stack, TMFocusUpgrades.antibody) ? COST_ANTIBODY : COST;
    }

    public int getActivationCooldown(ItemStack stack) {
        return 3000;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        Entity target = EntityUtils.getPointedEntity((World)world, (Entity)player, (double)0.0, (double)32.0, (float)1.1f);
        if (target != null && target instanceof EntityLivingBase) {
            if (wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false)) {
                EntityTaintSwarm swarm = new EntityTaintSwarm(world);
                Vec3 look = player.func_70040_Z();
                swarm.func_70012_b(player.field_70165_t + look.field_72450_a / 2.0, player.field_70163_u + (double)player.func_70047_e() + look.field_72448_b / 2.0, player.field_70161_v + look.field_72449_c / 2.0, player.field_70177_z, player.field_70125_A);
                swarm.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0 + (double)wand.getFocusPotency(stack));
                swarm.func_70784_b(target);
                swarm.setIsSummoned(true);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)swarm);
                }
                if (!this.isUpgradedWith(wand.getFocusItem(stack), TMFocusUpgrades.antibody) && player.field_70170_p.field_73012_v.nextInt(3) == 0) {
                    player.func_70690_d(new PotionEffect(Config.potionTaintPoisonID, 40, 2));
                }
            }
            player.func_71038_i();
        }
        return stack;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, TMFocusUpgrades.antibody};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
        }
        return null;
    }
}

