/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.aspects;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;

public class AspectList
implements Serializable {
    public LinkedHashMap<Aspect, Integer> aspects = new LinkedHashMap();

    public AspectList(ItemStack stack) {
        try {
            AspectList temp = ThaumcraftApiHelper.getObjectAspects(stack);
            if (temp != null) {
                this.aspects.putAll(temp.aspects);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AspectList() {
    }

    public String toString() {
        return this.aspects == null ? "{}" : this.aspects.toString();
    }

    public AspectList copy() {
        AspectList out = new AspectList();
        out.aspects.putAll(this.aspects);
        return out;
    }

    public int size() {
        return this.aspects.size();
    }

    public int visSize() {
        int q = 0;
        for (Integer amount : this.aspects.values()) {
            if (amount == null) continue;
            q += amount.intValue();
        }
        return q;
    }

    public Aspect[] getAspects() {
        return this.aspects.keySet().toArray(new Aspect[0]);
    }

    public Aspect[] getPrimalAspects() {
        HashSet<Aspect> aspects = new HashSet<Aspect>();
        for (Aspect as : this.aspects.keySet()) {
            if (!as.isPrimal()) continue;
            aspects.add(as);
        }
        return aspects.toArray(new Aspect[0]);
    }

    public Aspect[] getAspectsSorted() {
        try {
            boolean change;
            Aspect[] out = this.aspects.keySet().toArray(new Aspect[0]);
            block2: do {
                change = false;
                for (int a = 0; a < out.length - 1; ++a) {
                    Aspect e1 = out[a];
                    Aspect e2 = out[a + 1];
                    if (e1 == null || e2 == null || e1.getTag().compareTo(e2.getTag()) <= 0) continue;
                    out[a] = e2;
                    out[a + 1] = e1;
                    change = true;
                    continue block2;
                }
            } while (change);
            return out;
        }
        catch (Exception var6) {
            return this.getAspects();
        }
    }

    public Aspect[] getAspectsSortedAmount() {
        try {
            boolean change;
            Aspect[] out = this.aspects.keySet().toArray(new Aspect[1]);
            block2: do {
                change = false;
                for (int a = 0; a < out.length - 1; ++a) {
                    Aspect eb;
                    int e1 = this.getAmount(out[a]);
                    int e2 = this.getAmount(out[a + 1]);
                    if (e1 <= 0 || e2 <= 0 || e2 <= e1) continue;
                    Aspect ea = out[a];
                    out[a] = eb = out[a + 1];
                    out[a + 1] = ea;
                    change = true;
                    continue block2;
                }
            } while (change);
            return out;
        }
        catch (Exception var8) {
            return this.getAspects();
        }
    }

    public int getAmount(Aspect key) {
        return this.aspects.getOrDefault(key, 0);
    }

    public boolean reduce(Aspect key, int amount) {
        int a = this.getAmount(key);
        if (a >= amount) {
            int am = a - amount;
            this.aspects.put(key, am);
            return true;
        }
        return false;
    }

    public AspectList remove(Aspect key, int amount) {
        int am = this.getAmount(key) - amount;
        if (am <= 0) {
            this.aspects.remove(key);
        } else {
            this.aspects.put(key, am);
        }
        return this;
    }

    public AspectList remove(Aspect key) {
        this.aspects.remove(key);
        return this;
    }

    public AspectList add(Aspect aspect, int amount) {
        Integer count = this.aspects.get(aspect);
        this.aspects.put(aspect, count == null ? amount : count + amount);
        return this;
    }

    public AspectList merge(Aspect aspect, int amount) {
        Integer count = this.aspects.get(aspect);
        if (count == null || count < amount) {
            this.aspects.put(aspect, amount);
        }
        return this;
    }

    public AspectList add(AspectList in) {
        in.aspects.forEach(this::add);
        return this;
    }

    public AspectList merge(AspectList in) {
        in.aspects.forEach(this::merge);
        return this;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.aspects.clear();
        NBTTagList tlist = nbttagcompound.func_150295_c("Aspects", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            Aspect aspect;
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key") || (aspect = Aspect.getAspect(rs.func_74779_i("key"))) == null) continue;
            this.add(aspect, rs.func_74762_e("amount"));
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String label) {
        this.aspects.clear();
        NBTTagList tlist = nbttagcompound.func_150295_c(label, 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            Aspect aspect;
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key") || (aspect = Aspect.getAspect(rs.func_74779_i("key"))) == null) continue;
            this.add(aspect, rs.func_74762_e("amount"));
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.func_74782_a("Aspects", (NBTBase)tlist);
        this.aspects.forEach((aspect, amount) -> {
            if (aspect != null) {
                NBTTagCompound f = new NBTTagCompound();
                f.func_74778_a("key", aspect.getTag());
                f.func_74768_a("amount", amount.intValue());
                tlist.func_74742_a((NBTBase)f);
            }
        });
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String label) {
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.func_74782_a(label, (NBTBase)tlist);
        this.aspects.forEach((aspect, amount) -> {
            if (aspect != null) {
                NBTTagCompound f = new NBTTagCompound();
                f.func_74778_a("key", aspect.getTag());
                f.func_74768_a("amount", amount.intValue());
                tlist.func_74742_a((NBTBase)f);
            }
        });
    }
}

