/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class PlayerKnowledge {
    public Map<String, ArrayList<String>> researchCompleted = new HashMap<String, ArrayList<String>>();
    public Map<String, AspectList> aspectsDiscovered = new HashMap<String, AspectList>();
    public Map<String, ArrayList<String>> objectsScanned = new HashMap<String, ArrayList<String>>();
    public Map<String, ArrayList<String>> entitiesScanned = new HashMap<String, ArrayList<String>>();
    public Map<String, ArrayList<String>> phenomenaScanned = new HashMap<String, ArrayList<String>>();
    public Map<String, Integer> warpCount = new HashMap<String, Integer>();
    public Map<String, Integer> warp = new HashMap<String, Integer>();
    public Map<String, Integer> warpSticky = new HashMap<String, Integer>();
    public Map<String, Integer> warpTemp = new HashMap<String, Integer>();

    public void wipePlayerKnowledge(String player) {
        this.researchCompleted.remove(player);
        this.aspectsDiscovered.remove(player);
        this.objectsScanned.remove(player);
        this.entitiesScanned.remove(player);
        this.phenomenaScanned.remove(player);
        this.warp.remove(player);
        this.warpTemp.remove(player);
        this.warpSticky.remove(player);
    }

    public AspectList getAspectsDiscovered(String player) {
        AspectList known = this.aspectsDiscovered.get(player);
        if (known == null || known.size() <= 6) {
            this.addDiscoveredPrimalAspects(player);
            known = this.aspectsDiscovered.get(player);
        }
        return known;
    }

    public boolean hasDiscoveredAspect(String player, Aspect aspect) {
        return this.getAspectsDiscovered((String)player).aspects.containsKey(aspect);
    }

    public boolean hasDiscoveredParentAspects(String player, Aspect aspect) {
        if (aspect == null) {
            return false;
        }
        Aspect[] components = aspect.getComponents();
        return components == null || Arrays.asList(this.getAspectsDiscovered(player).getAspects()).containsAll(Arrays.asList(components));
    }

    public void addDiscoveredPrimalAspects(String player) {
        AspectList known = this.aspectsDiscovered.get(player);
        if (known == null) {
            known = new AspectList();
        }
        if (!known.aspects.containsKey(Aspect.AIR)) {
            known.add(Aspect.AIR, 0);
        }
        if (!known.aspects.containsKey(Aspect.FIRE)) {
            known.add(Aspect.FIRE, 0);
        }
        if (!known.aspects.containsKey(Aspect.EARTH)) {
            known.add(Aspect.EARTH, 0);
        }
        if (!known.aspects.containsKey(Aspect.WATER)) {
            known.add(Aspect.WATER, 0);
        }
        if (!known.aspects.containsKey(Aspect.ORDER)) {
            known.add(Aspect.ORDER, 0);
        }
        if (!known.aspects.containsKey(Aspect.ENTROPY)) {
            known.add(Aspect.ENTROPY, 0);
        }
        this.aspectsDiscovered.put(player, known);
    }

    public boolean addDiscoveredAspect(String player, Aspect aspect) {
        AspectList known = this.getAspectsDiscovered(player);
        if (!known.aspects.containsKey(aspect)) {
            known.add(aspect, 0);
            this.aspectsDiscovered.put(player, known);
            return true;
        }
        return false;
    }

    public int getAspectINTPoolFor(String username, Aspect aspect) {
        AspectList known = this.getAspectsDiscovered(username);
        return known != null ? Math.max(known.getAmount(aspect), 0) : 0;
    }

    public short getAspectPoolFor(String username, Aspect aspect) {
        return (short)Math.min(this.getAspectINTPoolFor(username, aspect), Short.MAX_VALUE);
    }

    public boolean addAspectPool(String username, Aspect aspect, short amount) {
        return this.addAspectPool(username, aspect, (int)amount);
    }

    public boolean addAspectPool(String username, Aspect aspect, int amount) {
        AspectList al = this.getAspectsDiscovered(username);
        if (al == null) {
            al = new AspectList();
        }
        if (aspect != null && amount != 0) {
            if (al.getAmount(aspect) + amount < 0) {
                return false;
            }
            al.add(aspect, amount);
            this.aspectsDiscovered.put(username, al);
            return true;
        }
        return false;
    }

    public boolean setAspectPool(String username, Aspect aspect, int amount) {
        AspectList al = this.getAspectsDiscovered(username);
        if (al == null) {
            al = new AspectList();
        }
        if (aspect != null) {
            al.aspects.put(aspect, amount);
            this.aspectsDiscovered.put(username, al);
            return true;
        }
        return false;
    }

    public boolean setAspectPool(String username, Aspect aspect, short amount) {
        if (amount < 0) {
            return false;
        }
        return this.setAspectPool(username, aspect, (int)amount);
    }

    public int getWarpCounter(String player) {
        int known = 0;
        if (!this.warpCount.containsKey(player)) {
            this.warpCount.put(player, 0);
        } else {
            known = this.warpCount.get(player);
        }
        return known;
    }

    public void setWarpCounter(String player, int amount) {
        this.warpCount.put(player, amount);
    }

    public int getWarpTotal(String player) {
        return this.getWarpPerm(player) + this.getWarpTemp(player) + this.getWarpSticky(player);
    }

    public int getWarpPerm(String player) {
        int known = 0;
        if (!this.warp.containsKey(player)) {
            this.warp.put(player, 0);
        } else {
            known = this.warp.get(player);
        }
        return known;
    }

    public int getWarpTemp(String player) {
        int known = 0;
        if (!this.warpTemp.containsKey(player)) {
            this.warpTemp.put(player, 0);
        } else {
            known = this.warpTemp.get(player);
        }
        return known;
    }

    public int getWarpSticky(String player) {
        int known = 0;
        if (!this.warpSticky.containsKey(player)) {
            this.warpSticky.put(player, 0);
        } else {
            known = this.warpSticky.get(player);
        }
        return known;
    }

    public void addWarpTemp(String player, int amount) {
        int er = this.getWarpTemp(player) + amount;
        this.warpTemp.put(player, Math.max(0, er));
    }

    public void addWarpPerm(String player, int amount) {
        int er = this.getWarpPerm(player) + amount;
        this.warp.put(player, Math.max(0, er));
    }

    public void addWarpSticky(String player, int amount) {
        int er = this.getWarpSticky(player) + amount;
        this.warpSticky.put(player, Math.max(0, er));
    }

    public void setWarpSticky(String player, int amount) {
        this.warpSticky.put(player, Math.max(0, amount));
    }

    public void setWarpPerm(String player, int amount) {
        this.warp.put(player, Math.max(0, amount));
    }

    public void setWarpTemp(String player, int amount) {
        this.warpTemp.put(player, Math.max(0, amount));
    }
}

