/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.waila;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;

public class PlayerWatchHandler {
    public static final PlayerWatchHandler INSTANCE = new PlayerWatchHandler();
    private final HashMap<Position, DataAccessorCommon> tiles = new HashMap();
    private final TIntObjectHashMap<DataAccessorCommon> entities = new TIntObjectHashMap();

    public DataAccessorCommon getAccessor(MovingObjectPosition position) {
        if (position == null || Minecraft.func_71410_x().func_71356_B()) {
            return DataAccessorCommon.instance;
        }
        if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return this.createAccessor(position, this.tiles.get(new Position(position.field_72311_b, position.field_72312_c, position.field_72309_d)));
        }
        if (position.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && position.field_72308_g != null) {
            return this.createAccessor(position, (DataAccessorCommon)this.entities.get(position.field_72308_g.func_145782_y()));
        }
        return DataAccessorCommon.instance;
    }

    private DataAccessorCommon createAccessor(MovingObjectPosition pos, @Nullable DataAccessorCommon accessor) {
        DataAccessorCommon result = accessor == null ? DataAccessorCommon.instance : accessor;
        EntityClientPlayerMP user = Minecraft.func_71410_x().field_71439_g;
        result.set(user.field_70170_p, (EntityPlayer)user, pos);
        if (accessor == null) {
            result.remoteNbt = null;
        }
        return result;
    }

    public void readTileSyncPacket(NBTTagCompound tags) {
        if (tags == null) {
            return;
        }
        Position pos = new Position(tags.func_74762_e("WailaX"), tags.func_74762_e("WailaY"), tags.func_74762_e("WailaZ"));
        DataAccessorCommon accessor = new DataAccessorCommon();
        accessor.remoteNbt = tags;
        EntityClientPlayerMP user = Minecraft.func_71410_x().field_71439_g;
        if (user == null || user.field_70170_p == null || pos.y < 0) {
            return;
        }
        accessor.set(user.field_70170_p, (EntityPlayer)user, Minecraft.func_71410_x().field_71476_x);
        this.tiles.put(pos, accessor);
    }

    public void readEntitySyncPacket(NBTTagCompound tags) {
        if (tags == null) {
            return;
        }
        int id = tags.func_74762_e("WailaEntityID");
        DataAccessorCommon accessor = new DataAccessorCommon();
        accessor.remoteNbt = tags;
        EntityClientPlayerMP user = Minecraft.func_71410_x().field_71439_g;
        if (user == null || user.field_70170_p == null) {
            return;
        }
        Entity entity = user.field_70170_p.func_73045_a(id);
        if (entity == null) {
            return;
        }
        MovingObjectPosition mop = new MovingObjectPosition(entity);
        accessor.set(user.field_70170_p, (EntityPlayer)user, mop);
        this.entities.put(id, (Object)accessor);
    }

    public void clearCache(int entityID) {
        this.entities.remove(entityID);
    }

    public void clearCache(int x, int y, int z) {
        this.tiles.remove(new Position(x, y, z));
    }

    public void clearCache() {
        this.entities.clear();
        this.tiles.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLeave(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.clearCache();
    }

    private static class Position {
        private final int x;
        private final int y;
        private final int z;

        Position(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            Position position = (Position)o;
            return this.x == position.x && this.y == position.y && this.z == position.z;
        }

        public int hashCode() {
            return this.x * this.y * this.z;
        }
    }
}

