/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotMagnetFilter;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryMagnetFilter;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;

public class ContainerMagnet
extends Container {
    public final InventoryPlayer inventoryPlayer;
    private final Set distributeSlotSet = new HashSet();
    private final int PLAYER_INV_START = 0;
    private final int PLAYER_INV_END = 26;
    private final int HOTBAR_START = 27;
    private final int HOTBAR_END = 35;
    private final int FILTERS_START = 36;
    private final int FILTERS_END = 62;
    public ItemStack magnetItem;
    public WCTInventoryMagnetFilter magnetInventory;
    private int distributeState = 0;
    private int pressedKeyInRange = -1;

    public ContainerMagnet(EntityPlayer player, InventoryPlayer inventoryPlayer) {
        int j;
        int i;
        this.inventoryPlayer = inventoryPlayer;
        this.magnetItem = RandomUtils.getMagnet(inventoryPlayer);
        this.magnetInventory = new WCTInventoryMagnetFilter(this.magnetItem);
        this.magnetInventory.setContainer(this);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, j + i * 9 + 9, j * 18 + 8, 126 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i, i * 18 + 8, 184));
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                SlotMagnetFilter slot = new SlotMagnetFilter(this.magnetInventory, j + i * 9, j * 18 + 8, 58 + i * 18);
                slot.setPhantom();
                this.func_75146_a(slot);
            }
        }
    }

    public static void setSlotStack(Set slotSet, int stackSizeSelector, ItemStack stackToResize, int currentSlotStackSize) {
        switch (stackSizeSelector) {
            case 0: {
                stackToResize.field_77994_a = MathHelper.func_76141_d((float)((float)stackToResize.field_77994_a / (float)slotSet.size()));
                break;
            }
            case 1: {
                stackToResize.field_77994_a = 1;
            }
        }
        stackToResize.field_77994_a += currentSlotStackSize;
    }

    public static boolean stackFitsInSlot(Slot slot, ItemStack itemStack, boolean sizeMatters) {
        ItemStack stackInSlot;
        if (slot == null || !slot.func_75216_d()) {
            return true;
        }
        if (itemStack != null && itemStack.func_77969_a(stackInSlot = slot.func_75211_c()) && ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)itemStack)) {
            int added = sizeMatters ? 0 : itemStack.field_77994_a;
            int maxStackSize = Math.min(slot.func_75219_a(), itemStack.func_77976_d());
            return stackInSlot.field_77994_a + added <= maxStackSize;
        }
        return false;
    }

    public static int checkForPressedButton(int btn) {
        return btn & 3;
    }

    public static int checkForPressedButton2(int mouseButtonPressed) {
        return mouseButtonPressed >> 2 & 3;
    }

    public static boolean checkValue(int value) {
        return value == 0 || value == 1;
    }

    private boolean isInHotbar(int slotNum) {
        ((Object)((Object)this)).getClass();
        if (slotNum >= 27) {
            ((Object)((Object)this)).getClass();
            return slotNum <= 35;
        }
        return false;
    }

    private boolean isInPlayerInventory(int slotNum) {
        ((Object)((Object)this)).getClass();
        if (slotNum >= 0) {
            ((Object)((Object)this)).getClass();
            return slotNum <= 26;
        }
        return false;
    }

    private boolean isInFilters(int slotNum) {
        ((Object)((Object)this)).getClass();
        if (slotNum >= 36) {
            ((Object)((Object)this)).getClass();
            return slotNum <= 62;
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    private boolean alreadyFiltered(ItemStack item) {
        for (int i = 0; i < this.magnetInventory.func_70302_i_(); ++i) {
            if (!this.isIdenticalItem(item, this.magnetInventory.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        if (slotNum >= this.field_75151_b.size()) {
            return null;
        }
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        ItemStack stack = null;
        if (slotNum == -999) {
            ItemStack cursorStack = inventoryPlayer.func_70445_o();
            if (cursorStack != null && slotNum == -999) {
                if (mouseButton == 0) {
                    player.func_71019_a(cursorStack, true);
                    inventoryPlayer.func_70437_b(null);
                }
                if (mouseButton == 1) {
                    player.func_71019_a(cursorStack.func_77979_a(1), true);
                    if (cursorStack.field_77994_a == 0) {
                        inventoryPlayer.func_70437_b(null);
                    }
                }
            }
            return null;
        }
        if (modifier == 5) {
            int currentDistributeState = this.distributeState;
            this.distributeState = ContainerMagnet.checkForPressedButton(mouseButton);
            if ((currentDistributeState != 1 || this.distributeState != 2) && currentDistributeState != this.distributeState) {
                this.resetDistributionVariables();
            } else if (inventoryPlayer.func_70445_o() == null) {
                this.resetDistributionVariables();
            } else if (this.distributeState == 0) {
                this.pressedKeyInRange = ContainerMagnet.checkForPressedButton2(mouseButton);
                if (ContainerMagnet.checkValue(this.pressedKeyInRange)) {
                    this.distributeState = 1;
                    this.distributeSlotSet.clear();
                } else {
                    this.resetDistributionVariables();
                }
            } else if (this.distributeState == 1) {
                Slot slot = (Slot)this.field_75151_b.get(slotNum);
                if (slot != null && ContainerMagnet.stackFitsInSlot(slot, inventoryPlayer.func_70445_o(), true) && slot.func_75214_a(inventoryPlayer.func_70445_o()) && inventoryPlayer.func_70445_o().field_77994_a > this.distributeSlotSet.size() && this.func_94531_b(slot)) {
                    this.distributeSlotSet.add(slot);
                }
            } else if (this.distributeState == 2) {
                if (!this.distributeSlotSet.isEmpty()) {
                    ItemStack cursorStack2 = inventoryPlayer.func_70445_o().func_77946_l();
                    int cursorStackSize = cursorStack2.field_77994_a;
                    for (Slot slot2 : (List)((Object)this.distributeSlotSet)) {
                        if (slot2 == null || !ContainerMagnet.stackFitsInSlot(slot2, inventoryPlayer.func_70445_o(), true) || !slot2.func_75214_a(inventoryPlayer.func_70445_o()) || inventoryPlayer.func_70445_o().field_77994_a < this.distributeSlotSet.size() || !this.func_94531_b(slot2)) continue;
                        ItemStack newSlotStack = cursorStack2.func_77946_l();
                        int j1 = slot2.func_75216_d() ? slot2.func_75211_c().field_77994_a : 0;
                        ContainerMagnet.setSlotStack(this.distributeSlotSet, this.pressedKeyInRange, newSlotStack, j1);
                        if (newSlotStack.field_77994_a > newSlotStack.func_77976_d()) {
                            newSlotStack.field_77994_a = newSlotStack.func_77976_d();
                        }
                        if (newSlotStack.field_77994_a > slot2.func_75219_a()) {
                            newSlotStack.field_77994_a = slot2.func_75219_a();
                        }
                        cursorStackSize -= newSlotStack.field_77994_a - j1;
                        slot2.func_75215_d(newSlotStack);
                    }
                    cursorStack2.field_77994_a = cursorStackSize;
                    if (cursorStack2.field_77994_a <= 0) {
                        cursorStack2 = null;
                    }
                    inventoryPlayer.func_70437_b(cursorStack2);
                }
                this.resetDistributionVariables();
            } else {
                this.resetDistributionVariables();
            }
        } else if (this.distributeState != 0) {
            this.resetDistributionVariables();
        } else {
            if (this.func_75139_a(slotNum) == null || !(this.func_75139_a(slotNum) instanceof SlotMagnetFilter)) {
                return super.func_75144_a(slotNum, mouseButton, modifier, player);
            }
            SlotMagnetFilter slot3 = (SlotMagnetFilter)this.func_75139_a(slotNum);
            ItemStack stackSlot = slot3.func_75211_c();
            if (this.alreadyFiltered(player.field_71071_by.func_70445_o()) && player.field_71071_by.func_70445_o() != null) {
                return null;
            }
            if (stackSlot != null) {
                stack = stackSlot.func_77946_l();
            }
            if (mouseButton == 2) {
                this.fillPhantomSlot(slot3, null, mouseButton);
            } else if (mouseButton == 0 || mouseButton == 1) {
                InventoryPlayer playerInv = player.field_71071_by;
                ItemStack stackHeld = playerInv.func_70445_o();
                if (stackSlot == null) {
                    if (stackHeld != null && slot3.func_75214_a(stackHeld)) {
                        this.fillPhantomSlot(slot3, stackHeld, mouseButton);
                    }
                } else if (stackHeld == null) {
                    this.adjustPhantomSlot(slot3, mouseButton, modifier);
                } else if (slot3.func_75214_a(stackHeld)) {
                    if (this.isIdenticalItem(stackSlot, stackHeld)) {
                        this.adjustPhantomSlot(slot3, mouseButton, modifier);
                    } else {
                        this.fillPhantomSlot(slot3, stackHeld, mouseButton);
                    }
                }
            }
            return stack;
        }
        return stack;
    }

    public boolean alwaysTrue(Slot slot) {
        return true;
    }

    protected void resetDistributionVariables() {
        this.distributeState = 0;
        this.distributeSlotSet.clear();
    }

    private void arrangeSlots() {
        int invSize = this.magnetInventory.func_70302_i_();
        if (invSize <= 0) {
            return;
        }
        block0: for (int i = 0; i < invSize; ++i) {
            if (this.magnetInventory.func_70301_a(i) != null) continue;
            for (int j = 0; j < invSize; ++j) {
                if (j <= i || this.magnetInventory.func_70301_a(j) == null) continue;
                this.magnetInventory.func_70299_a(i, this.magnetInventory.func_70301_a(j));
                this.magnetInventory.func_70298_a(j, 1);
                continue block0;
            }
        }
    }

    private void fillPhantomSlot(SlotMagnetFilter slot, ItemStack stackHeld, int mouseButton) {
        if (!slot.canAdjustPhantom()) {
            return;
        }
        if (stackHeld == null) {
            slot.func_75215_d(null);
            return;
        }
        int stackSize = mouseButton == 0 ? stackHeld.field_77994_a : 1;
        int maxStackSize = Math.min(slot.func_75219_a(), stackHeld.func_77976_d());
        stackSize = Math.min(stackSize, maxStackSize);
        ItemStack phantomStack = stackHeld.func_77946_l();
        RandomUtils.removeTimerTags(phantomStack);
        phantomStack.field_77994_a = stackSize;
        slot.func_75215_d(phantomStack);
        this.arrangeSlots();
    }

    private void adjustPhantomSlot(SlotMagnetFilter slot, int mouseButton, int modifier) {
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        int stackSize = modifier == 1 ? (mouseButton == 0 ? (stackSlot.field_77994_a + 1) / 2 : stackSlot.field_77994_a * 2) : (mouseButton == 0 ? stackSlot.field_77994_a - 1 : stackSlot.field_77994_a + 1);
        int maxStackSize = Math.min(slot.func_75219_a(), stackSlot.func_77976_d());
        stackSlot.field_77994_a = stackSize = Math.min(stackSize, maxStackSize);
        if (stackSlot.field_77994_a <= 0) {
            stackSlot = null;
        }
        slot.func_75215_d(stackSlot);
        this.arrangeSlots();
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot == null) {
            return null;
        }
        ItemStack stack = slot.func_75211_c();
        if (stack == null) {
            return null;
        }
        if (this.isInHotbar(slotIndex)) {
            if (this.mergePhantomStack(stack)) {
                return null;
            }
            ItemStack stack2 = stack;
            int start = this.PLAYER_INV_START;
            ((Object)((Object)this)).getClass();
            if (!this.func_75135_a(stack2, 0, 27, false)) {
                return null;
            }
        } else {
            if (!this.isInPlayerInventory(slotIndex)) {
                return null;
            }
            if (this.mergePhantomStack(stack)) {
                return null;
            }
            ItemStack stack3 = stack;
            int start2 = this.HOTBAR_START;
            ((Object)((Object)this)).getClass();
            if (!this.func_75135_a(stack3, 27, 36, false)) {
                return null;
            }
        }
        if (stack.field_77994_a == 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        slot.func_82870_a(player, stack);
        return stack;
    }

    protected boolean mergePhantomStack(ItemStack stack) {
        if (!this.alreadyFiltered(stack)) {
            int slotNumber = this.FILTERS_START;
            while (true) {
                int n = ++slotNumber;
                ((Object)((Object)this)).getClass();
                if (n > 62) break;
                Slot slot = this.func_75139_a(slotNumber);
                if (slot.func_75211_c() != null) continue;
                this.fillPhantomSlot((SlotMagnetFilter)slot, stack, 0);
                return true;
            }
        }
        return false;
    }

    public boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        return lhs == rhs || lhs != null && rhs != null && lhs.func_77973_b() == rhs.func_77973_b() && (lhs.func_77960_j() == Short.MAX_VALUE || lhs.func_77960_j() == rhs.func_77960_j()) && ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    protected boolean func_75135_a(ItemStack stack, int start, int end, boolean backwards) {
        Slot slot;
        int slotNumber;
        boolean success = false;
        if (stack.func_77985_e()) {
            int n = slotNumber = backwards ? end - 1 : start;
            while (stack.field_77994_a > 0 && !(!backwards ? slotNumber >= end : slotNumber < start)) {
                int maxStackSize;
                slot = (Slot)this.field_75151_b.get(slotNumber);
                if (!slot.func_75214_a(stack)) {
                    slotNumber += backwards ? -1 : 1;
                    continue;
                }
                ItemStack stackInSlot = slot.func_75211_c();
                if (stackInSlot != null && stackInSlot.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == stackInSlot.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackInSlot) && (maxStackSize = Math.min(slot.func_75219_a(), stack.func_77976_d())) > 0) {
                    int newStackInSlotSize = stackInSlot.field_77994_a + stack.field_77994_a;
                    if (newStackInSlotSize <= maxStackSize) {
                        stack.field_77994_a = 0;
                        stackInSlot.field_77994_a = newStackInSlotSize;
                        this.magnetInventory.func_70296_d();
                        success = true;
                    } else if (stackInSlot.field_77994_a < maxStackSize) {
                        stack.field_77994_a -= maxStackSize - stackInSlot.field_77994_a;
                        stackInSlot.field_77994_a = maxStackSize;
                        this.magnetInventory.func_70296_d();
                        success = true;
                    }
                }
                slotNumber += backwards ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n = slotNumber = backwards ? end - 1 : start;
            while (!(stack.field_77994_a <= 0 || !backwards ? slotNumber >= end : slotNumber < start)) {
                slot = (Slot)this.field_75151_b.get(slotNumber);
                if (!slot.func_75214_a(stack)) {
                    slotNumber += backwards ? -1 : 1;
                    continue;
                }
                if (slot.func_75211_c() == null) {
                    int maxStackSize2 = Math.min(slot.func_75219_a(), stack.func_77976_d());
                    if (maxStackSize2 <= 0) {
                        slotNumber += backwards ? -1 : 1;
                        continue;
                    }
                    if (stack.field_77994_a <= maxStackSize2) {
                        slot.func_75215_d(stack.func_77946_l());
                        stack.field_77994_a = 0;
                        this.magnetInventory.func_70296_d();
                        success = true;
                        break;
                    }
                    this.func_75141_a(slotNumber, stack.func_77979_a(maxStackSize2));
                    this.magnetInventory.func_70296_d();
                    success = true;
                }
                slotNumber += backwards ? -1 : 1;
            }
        }
        return success;
    }
}

