/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotME;
import appeng.container.ContainerNull;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.InventoryAction;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTermHandler;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTIActionHost;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTPlayerSource;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerOpenContext;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.GuiSync;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.SyncData;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.AppEngCraftingSlot;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.AppEngSlot;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.NullSlot;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotArmor;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotBooster;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingMatrix;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingTerm;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotDisabled;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotFake;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotInaccessible;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotMagnet;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotPlayerHotBar;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotPlayerInv;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotTrash;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryBooster;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryCrafting;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryMagnet;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryTrash;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketInventoryAction;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketMEInventoryUpdate;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketPartialItem;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketValueConfig;
import net.p455w0rd.wirelesscraftingterminal.handlers.LocaleHandler;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;
import net.p455w0rd.wirelesscraftingterminal.items.ItemInfinityBooster;
import net.p455w0rd.wirelesscraftingterminal.items.ItemMagnet;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class ContainerWirelessCraftingTerminal
extends Container
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEItemStack>,
IAEAppEngInventory,
IContainerCraftingPacket {
    private static final int HOTBAR_START = 1;
    private static final int HOTBAR_END = 9;
    private static final int INV_START = 10;
    private static final int INV_END = 36;
    private static final int ARMOR_START = 37;
    private static final int ARMOR_END = 40;
    private static final int CRAFT_GRID_START = 41;
    private static final int CRAFT_GRID_END = 49;
    private static final int CRAFT_RESULT = 50;
    private static final int BOOSTER_INDEX = 0;
    private static final int MAGNET_INDEX = 51;
    public static int CRAFTING_SLOT_X_POS = 80;
    public static int CRAFTING_SLOT_Y_POS = 83;
    @GuiSync(value=98)
    public static boolean hasPower = false;
    public final WCTInventoryBooster boosterInventory;
    public final WCTInventoryMagnet magnetInventory;
    public final WCTInventoryTrash trashInventory;
    public final InventoryPlayer inventoryPlayer;
    private final ItemStack containerstack;
    private final World worldObj;
    private final EntityPlayer player;
    private final SlotMagnet magnetSlot;
    private final Slot[] hotbarSlot;
    private final Slot[] inventorySlot;
    private final SlotArmor[] armorSlot;
    private final SlotCraftingMatrix[] craftMatrixSlot;
    private final SlotCraftingTerm craftingSlot;
    private final WirelessTerminalGuiObject obj;
    private final IPortableCell civ;
    private final IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    private final IConfigManager clientCM;
    private final BaseActionSource mySrc;
    private final HashMap<Integer, SyncData> syncData = new HashMap();
    private final List<PacketPartialItem> dataChunks = new LinkedList<PacketPartialItem>();
    private final AppEngInternalInventory output = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final HashSet<Integer> locked = new HashSet();
    private final IWirelessCraftingTerminalItem thisItem;
    private final IGridNode networkNode;
    public WCTInventoryCrafting craftingGrid;
    public ItemStack[] craftMatrixInventory;
    public ItemStack craftItem;
    public SlotTrash trashSlot;
    private SlotBooster boosterSlot;
    private NullSlot nullSlot;
    private int firstCraftingSlotNumber = -1;
    private int lastCraftingSlotNumber = -1;
    private boolean isContainerValid = true;
    private double powerMultiplier = 0.5;
    private int ticks = 0;
    private IConfigManager serverCM;
    private IEnergySource powerSrc;
    private IConfigManagerHost gui;
    private IAEItemStack clientRequestedTargetItem = null;
    private int ticksSinceCheck = 900;
    private String customName;
    private boolean sentCustomName;
    private ContainerOpenContext openContext;
    private IMEInventoryHandler<IAEItemStack> cellInv;

    public ContainerWirelessCraftingTerminal(EntityPlayer player, InventoryPlayer inventoryPlayer) {
        int l;
        int j;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.mySrc = new WCTPlayerSource(inventoryPlayer.field_70458_d, this.getActionHost());
        this.customName = "WCTContainer";
        this.containerstack = RandomUtils.getWirelessTerm(inventoryPlayer);
        this.boosterInventory = new WCTInventoryBooster(this.containerstack);
        this.magnetInventory = new WCTInventoryMagnet(this.containerstack);
        this.trashInventory = new WCTInventoryTrash(this.containerstack);
        this.thisItem = (IWirelessCraftingTerminalItem)this.containerstack.func_77973_b();
        this.worldObj = player.field_70170_p;
        this.craftingGrid = new WCTInventoryCrafting(this, 3, 3, this.containerstack);
        this.inventoryPlayer = inventoryPlayer;
        this.player = player;
        this.craftMatrixInventory = new ItemStack[9];
        this.hotbarSlot = new Slot[9];
        this.inventorySlot = new Slot[27];
        this.armorSlot = new SlotArmor[4];
        this.craftMatrixSlot = new SlotCraftingMatrix[9];
        this.obj = this.getGuiObject(this.containerstack, player, this.worldObj, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        this.civ = this.obj;
        this.networkNode = this.obj.getGridNode(ForgeDirection.UNKNOWN);
        this.prepareSync();
        if (Platform.isServer()) {
            this.serverCM = this.civ.getConfigManager();
            this.monitor = this.civ.getItemInventory();
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setCellInventory((IMEInventoryHandler<IAEItemStack>)this.monitor);
                if (this.civ instanceof IPortableCell) {
                    this.setPowerSource((IEnergySource)this.civ);
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        if (Reference.WCT_BOOSTER_ENABLED) {
            this.boosterSlot = new SlotBooster(this.boosterInventory, 0, 134, -20);
            this.func_75146_a(this.boosterSlot);
        } else {
            this.nullSlot = new NullSlot();
            this.func_75146_a(this.nullSlot);
        }
        for (int i = 0; i < 9; ++i) {
            this.hotbarSlot[i] = new SlotPlayerHotBar((IInventory)this.inventoryPlayer, i, i * 18 + 8, 58);
            this.func_75146_a(this.hotbarSlot[i]);
        }
        int k = 0;
        for (j = 0; j < 3; ++j) {
            for (l = 0; l < 9; ++l) {
                this.inventorySlot[k] = new SlotPlayerInv((IInventory)this.inventoryPlayer, l + j * 9 + 9, l * 18 + 8, j * 18);
                this.func_75146_a(this.inventorySlot[k]);
                ++k;
            }
        }
        for (j = 0; j < 4; ++j) {
            this.armorSlot[j] = new SlotArmor(this.player, (IInventory)this.inventoryPlayer, 39 - j, 8, j * 18 - 76, j);
            this.func_75146_a(this.armorSlot[j]);
        }
        k = 0;
        for (j = 0; j < 3; ++j) {
            for (l = 0; l < 3; ++l) {
                this.craftMatrixSlot[k] = new SlotCraftingMatrix(this, (IInventory)this.craftingGrid, l + j * 3, 80 + l * 18, j * 18 - 76);
                this.func_75146_a(this.craftMatrixSlot[k]);
                if (k == 0) {
                    this.firstCraftingSlotNumber = this.craftMatrixSlot[k].field_75222_d;
                }
                ++k;
            }
        }
        this.lastCraftingSlotNumber = this.craftMatrixSlot[8].field_75222_d;
        this.craftingSlot = new SlotCraftingTerm(this.getPlayerInv().field_70458_d, this.mySrc, this.getPowerSource(), (IStorageMonitorable)this.obj, (IInventory)this.craftingGrid, (IInventory)this.craftingGrid, (IInventory)this.output, 174, -58, this);
        this.func_75146_a(this.craftingSlot);
        this.magnetSlot = new SlotMagnet(this.magnetInventory, 152, -20);
        this.func_75146_a(this.magnetSlot);
        this.trashSlot = new SlotTrash((IInventory)this.trashInventory, 80, -20, player);
        this.trashSlot.setContainer(this);
        this.func_75146_a(this.trashSlot);
        this.updateCraftingMatrix();
        this.func_75130_a((IInventory)this.craftingGrid);
        this.thisItem.checkForBooster(this.containerstack);
    }

    public void onSlotChange(Slot s) {
        this.writeToNBT("all");
    }

    protected Slot func_75146_a(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setContainer(this);
            return super.func_75146_a(newSlot);
        }
        throw new IllegalArgumentException("Invalid Slot [" + newSlot + "] for WCT Container instead of AppEngSlot.");
    }

    public boolean func_94531_b(Slot s) {
        return ((AppEngSlot)s).isDraggable();
    }

    public void func_75130_a(IInventory iinv) {
        ContainerNull cn = new ContainerNull();
        InventoryCrafting ic = new InventoryCrafting((Container)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.func_70299_a(x, this.craftMatrixSlot[x].func_75211_c());
        }
        this.craftingSlot.func_75215_d(CraftingManager.func_77594_a().func_82787_a(ic, this.worldObj));
        this.writeToNBT("crafting");
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (slot >= 0 && slot < this.field_75151_b.size()) {
            Slot s = this.func_75139_a(slot);
            if (s instanceof SlotCraftingTerm) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((SlotCraftingTerm)s).doClick(action, (EntityPlayer)player);
                        this.updateHeld(player);
                    }
                }
            }
            if (s instanceof SlotFake) {
                ItemStack hand = player.field_71071_by.func_70445_o();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (hand == null) {
                            s.func_75215_d(null);
                            break;
                        }
                        s.func_75215_d(hand.func_77946_l());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (hand == null) break;
                        Object is = hand.func_77946_l();
                        ((ItemStack)is).field_77994_a = 1;
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        Object is = s.func_75211_c();
                        if (is != null) {
                            if (hand == null) {
                                ItemStack itemStack = is;
                                --itemStack.field_77994_a;
                            } else if (hand.func_77969_a((ItemStack)is)) {
                                ((ItemStack)is).field_77994_a = Math.min(is.func_77976_d(), ((ItemStack)is).field_77994_a + 1);
                            } else {
                                is = hand.func_77946_l();
                                ((ItemStack)is).field_77994_a = 1;
                            }
                            s.func_75215_d((ItemStack)is);
                            break;
                        }
                        if (hand == null) break;
                        is = hand.func_77946_l();
                        ((ItemStack)is).field_77994_a = 1;
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                LinkedList<Slot> from = new LinkedList<Slot>();
                for (Object j : this.field_75151_b) {
                    if (!(j instanceof Slot) || j.getClass() != s.getClass()) continue;
                    from.add((Slot)j);
                }
                for (Slot fr : from) {
                    this.func_82846_b((EntityPlayer)player, fr.field_75222_d);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.clientRequestedTargetItem;
        switch (action) {
            case SHIFT_CLICK: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                IAEItemStack ais = slotItem.copy();
                ItemStack myItem = ais.getItemStack();
                ais.setStackSize((long)myItem.func_77976_d());
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                myItem.field_77994_a = (int)ais.getStackSize();
                myItem = adp.simulateAdd(myItem);
                if (myItem != null) {
                    ais.setStackSize(ais.getStackSize() - (long)myItem.field_77994_a);
                }
                if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource())) == null) break;
                adp.addItems(ais.getItemStack());
                break;
            }
            case ROLL_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                boolean releaseQty = true;
                ItemStack isg = player.field_71071_by.func_70445_o();
                if (isg == null) break;
                IAEItemStack ais2 = AEApi.instance().storage().createItemStack(isg);
                ais2.setStackSize(1L);
                IAEItemStack extracted = ais2.copy();
                ais2 = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais2, (BaseActionSource)this.getActionSource());
                if (ais2 != null) break;
                AdaptorPlayerHand ia = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail = ia.removeItems(1, extracted.getItemStack(), null);
                if (fail == null) {
                    this.getCellInventory().extractItems((IAEStack)extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int liftQty = 1;
                ItemStack item = player.field_71071_by.func_70445_o();
                if (item != null) {
                    if (item.field_77994_a >= item.func_77976_d()) {
                        liftQty = 0;
                    }
                    if (!Platform.isSameItemPrecise((ItemStack)slotItem.getItemStack(), (ItemStack)item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais3 = slotItem.copy();
                ais3.setStackSize(1L);
                ais3 = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais3, (BaseActionSource)this.getActionSource());
                if (ais3 == null) break;
                AdaptorPlayerHand ia2 = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail2 = ia2.addItems(ais3.getItemStack());
                if (fail2 != null) {
                    this.getCellInventory().injectItems((IAEStack)ais3, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o() != null) {
                    IAEItemStack ais2 = AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o());
                    ais2 = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais2, (BaseActionSource)this.getActionSource());
                    if (ais2 != null) {
                        player.field_71071_by.func_70437_b(ais2.getItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                if (slotItem == null) break;
                IAEItemStack ais2 = slotItem.copy();
                ais2.setStackSize((long)ais2.getItemStack().func_77976_d());
                ais2 = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais2, (BaseActionSource)this.getActionSource());
                if (ais2 != null) {
                    player.field_71071_by.func_70437_b(ais2.getItemStack());
                } else {
                    player.field_71071_by.func_70437_b(null);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o() != null) {
                    ItemStack itemStack2;
                    IAEItemStack ais2 = AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o());
                    ais2.setStackSize(1L);
                    ais2 = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais2, (BaseActionSource)this.getActionSource());
                    if (ais2 != null) break;
                    ItemStack is2 = itemStack2 = player.field_71071_by.func_70445_o();
                    --itemStack2.field_77994_a;
                    if (is2.field_77994_a <= 0) {
                        player.field_71071_by.func_70437_b(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                if (slotItem == null) break;
                IAEItemStack ais2 = slotItem.copy();
                long maxSize = ais2.getItemStack().func_77976_d();
                ais2.setStackSize(maxSize);
                ais2 = (IAEItemStack)this.getCellInventory().extractItems((IAEStack)ais2, Actionable.SIMULATE, this.getActionSource());
                if (ais2 != null) {
                    long stackSize = Math.min(maxSize, ais2.getStackSize());
                    ais2.setStackSize(stackSize + 1L >> 1);
                    ais2 = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais2, (BaseActionSource)this.getActionSource());
                }
                if (ais2 != null) {
                    player.field_71071_by.func_70437_b(ais2.getItemStack());
                } else {
                    player.field_71071_by.func_70437_b(null);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.field_71075_bZ.field_75098_d || slotItem == null) break;
                ItemStack is3 = slotItem.getItemStack();
                is3.field_77994_a = is3.func_77976_d();
                player.field_71071_by.func_70437_b(is3);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int playerInv = 36;
                for (int slotNum = 0; slotNum < 36; ++slotNum) {
                    IAEItemStack ais3 = slotItem.copy();
                    ItemStack myItem2 = ais3.getItemStack();
                    ais3.setStackSize((long)myItem2.func_77976_d());
                    InventoryAdaptor adp2 = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                    myItem2.field_77994_a = (int)ais3.getStackSize();
                    myItem2 = adp2.simulateAdd(myItem2);
                    if (myItem2 != null) {
                        ais3.setStackSize(ais3.getStackSize() - (long)myItem2.field_77994_a);
                    }
                    if ((ais3 = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais3, (BaseActionSource)this.getActionSource())) == null) {
                        return;
                    }
                    adp2.addItems(ais3.getItemStack());
                }
                break;
            }
        }
    }

    public IMEInventoryHandler<IAEItemStack> getCellInventory() {
        return this.cellInv;
    }

    public void setCellInventory(IMEInventoryHandler<IAEItemStack> cellInv) {
        this.cellInv = cellInv;
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                NetworkHandler.instance.sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.create((ItemStack)p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
    }

    private void updateCraftingMatrix() {
        if (!this.containerstack.func_77942_o()) {
            this.containerstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound stack = this.containerstack.func_77978_p();
        this.readMatrixNBT(stack);
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid.func_70299_a(i, this.craftMatrixInventory[i]);
        }
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public boolean useRealItems() {
        return true;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player") || name.equals("container.inventory")) {
            return this.getInventoryPlayer();
        }
        if (name.equals("crafting")) {
            return this.craftingGrid;
        }
        return null;
    }

    public ItemStack[] getViewCells() {
        return null;
    }

    private WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    public void func_75142_b() {
        if (!Platform.isServer()) {
            super.func_75142_b();
            return;
        }
        this.sendCustomName();
        ++this.ticks;
        if (this.ticks > 10) {
            if (!this.isBoosterInstalled() || !Reference.WCT_BOOSTER_ENABLED) {
                this.civ.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            } else {
                this.civ.extractAEPower((double)((int)(0.5 * (double)this.ticks)), Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
            this.ticks = 0;
        }
        if (this.monitor != this.civ.getItemInventory()) {
            this.setValidContainer(false);
        }
        for (Settings set : this.serverCM.getSettings()) {
            Enum sideRemote;
            Enum sideLocal = this.serverCM.getSetting(set);
            if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
            this.clientCM.putSetting(set, sideLocal);
            for (Object crafter : this.field_75149_d) {
                try {
                    NetworkHandler.instance.sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                }
                catch (IOException e) {
                    WCTLog.debug(e.getMessage(), new Object[0]);
                }
            }
        }
        if (!this.items.isEmpty()) {
            try {
                IItemList monitorCache = this.monitor.getStorageList();
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                for (IAEItemStack is : this.items) {
                    IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                    if (send == null) {
                        is.setStackSize(0L);
                        piu.appendItem(is);
                        continue;
                    }
                    piu.appendItem(send);
                }
                if (!piu.isEmpty()) {
                    this.items.resetStatus();
                    for (Object c : this.field_75149_d) {
                        if (!(c instanceof EntityPlayer)) continue;
                        NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                    }
                }
            }
            catch (IOException e2) {
                WCTLog.debug(e2.getMessage(), new Object[0]);
            }
        }
        this.sendCustomName();
        if (Platform.isServer()) {
            for (Object crafter2 : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter2;
                for (SyncData sd : this.syncData.values()) {
                    sd.tick(icrafting);
                }
            }
        }
        if (!this.isInRange()) {
            if (!this.isBoosterInstalled() || !Reference.WCT_BOOSTER_ENABLED) {
                if (this.isValidContainer()) {
                    this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.OutOfRange.get());
                }
                this.setValidContainer(false);
            }
            if (!this.networkIsPowered()) {
                if (this.isValidContainer()) {
                    this.getPlayerInv().field_70458_d.func_145747_a((IChatComponent)new ChatComponentText(LocaleHandler.NoNetworkPower.getLocal()));
                }
                this.setValidContainer(false);
            }
        } else if (!(this.hasAccess(SecurityPermissions.CRAFT, true) && this.hasAccess(SecurityPermissions.EXTRACT, true) && this.hasAccess(SecurityPermissions.INJECT, true))) {
            if (this.isValidContainer()) {
                this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.CommunicationError.get());
            }
            this.setValidContainer(false);
        } else {
            this.setPowerMultiplier(AEConfig.instance.wireless_getDrainRate(this.obj.getRange()));
        }
        super.func_75142_b();
    }

    public boolean isBoosterInstalled() {
        Slot slot = this.func_75147_a(this.boosterInventory, 0);
        if (slot == null) {
            return false;
        }
        boolean hasStack = this.func_75147_a(this.boosterInventory, 0).func_75216_d();
        if (hasStack) {
            Item boosterSlotContents = this.func_75147_a(this.boosterInventory, 0).func_75211_c().func_77973_b();
            return boosterSlotContents instanceof ItemInfinityBooster;
        }
        return false;
    }

    public boolean isMagnetInstalled() {
        Slot slot = this.func_75147_a(this.magnetInventory, 51);
        if (slot == null) {
            return false;
        }
        boolean hasStack = this.func_75147_a(this.magnetInventory, 51).func_75216_d();
        if (hasStack) {
            Item magnetSlotContents = this.func_75147_a(this.magnetInventory, 51).func_75211_c().func_77973_b();
            return magnetSlotContents instanceof ItemMagnet;
        }
        return false;
    }

    public BaseActionSource getActionSource() {
        return this.mySrc;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.isValidContainer();
    }

    private void sendCustomName() {
        if (!this.sentCustomName) {
            this.sentCustomName = true;
            if (Platform.isServer()) {
                ICustomNameObject name = null;
                if (this.obj instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.obj;
                }
                if (this instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this;
                }
                if (name != null) {
                    if (name.hasCustomName()) {
                        this.setCustomName(name.getCustomName());
                    }
                    if (this.getCustomName() != null) {
                        try {
                            NetworkHandler.instance.sendTo(new PacketValueConfig("CustomName", this.getCustomName()), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
                        }
                        catch (IOException e) {
                            WCTLog.debug(e.getMessage(), new Object[0]);
                        }
                    }
                }
            }
        }
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void stringSync(int idx, String value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (Platform.isClient()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean isInRange() {
        return this.obj.rangeCheck(Reference.WCT_BOOSTER_ENABLED && this.isBoosterInstalled());
    }

    protected boolean networkIsPowered() {
        IGrid grid;
        WCTIActionHost host = this.getActionHost();
        if (host != null && (grid = this.obj.getTargetGrid()) != null) {
            IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            return eg.isNetworkPowered();
        }
        return false;
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IEnergyGrid eg;
        IGrid grid = this.obj.getTargetGrid();
        if (grid != null && !(eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class)).isNetworkPowered()) {
            return false;
        }
        ISecurityGrid sg = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        return sg.hasPermission(this.getInventoryPlayer().field_70458_d, perm);
    }

    public void lockPlayerInventorySlot(int idx) {
        this.locked.add(idx);
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public void postPartial(PacketPartialItem packetPartialItem) {
        this.dataChunks.add(packetPartialItem);
        if (packetPartialItem.getPageCount() == this.dataChunks.size()) {
            this.parsePartials();
        }
    }

    private void parsePartials() {
        int total = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            total += ppi.getSize();
        }
        byte[] buffer = new byte[total];
        int cursor = 0;
        for (PacketPartialItem ppi2 : this.dataChunks) {
            cursor = ppi2.write(buffer, cursor);
        }
        try {
            NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(buffer));
            if (data != null) {
                this.setTargetStack(AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)data)));
            }
        }
        catch (IOException e) {
            WCTLog.debug(e.getMessage(), new Object[0]);
        }
        this.dataChunks.clear();
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            ItemStack b;
            ItemStack a = stack == null ? null : stack.getItemStack();
            ItemStack itemStack = b = this.clientRequestedTargetItem == null ? null : this.clientRequestedTargetItem.getItemStack();
            if (Platform.isSameItemPrecise((ItemStack)a, (ItemStack)b)) {
                return;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            NBTTagCompound item = new NBTTagCompound();
            if (stack != null) {
                stack.writeToNBT(item);
            }
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)item, (OutputStream)stream);
                int maxChunkSize = 30000;
                LinkedList<byte[]> miniPackets = new LinkedList<byte[]>();
                byte[] data = stream.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(data, 0, stream.size());
                while (bis.available() > 0) {
                    int nextBLock = bis.available() > 30000 ? 30000 : bis.available();
                    byte[] nextSegment = new byte[nextBLock];
                    bis.read(nextSegment);
                    miniPackets.add(nextSegment);
                }
                bis.close();
                stream.close();
                int page = 0;
                for (byte[] packet : miniPackets) {
                    PacketPartialItem ppi = new PacketPartialItem(page, miniPackets.size(), packet);
                    ++page;
                    NetworkHandler.instance.sendToServer(ppi);
                }
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
                return;
            }
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    private void prepareSync() {
        for (Field f : ((Object)((Object)this)).getClass().getFields()) {
            if (!f.isAnnotationPresent(GuiSync.class)) continue;
            GuiSync annotation = f.getAnnotation(GuiSync.class);
            if (this.syncData.containsKey(annotation.value())) {
                WCTLog.warning("Channel already in use: " + annotation.value() + " for " + f.getName(), new Object[0]);
                continue;
            }
            this.syncData.put(annotation.value(), new SyncData(this, f, annotation));
        }
    }

    protected WCTIActionHost getActionHost() {
        if (this.obj instanceof WCTIActionHost) {
            return this.obj;
        }
        return null;
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public void onListUpdate() {
        for (Object c : this.field_75149_d) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource source) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    private void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                IItemList monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEInventoryUpdate();
                        piu.appendItem(send);
                    }
                }
                NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
    }

    public IEnergySource getPowerSource() {
        return this.powerSrc;
    }

    public void setPowerSource(IEnergySource powerSrc) {
        this.powerSrc = powerSrc;
    }

    public boolean isPowered() {
        double pwr = this.thisItem.getAECurrentPower(this.containerstack);
        return pwr > 0.0;
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    public InventoryPlayer getPlayerInv() {
        return this.getInventoryPlayer();
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public Object getTarget() {
        return this.obj;
    }

    public ContainerOpenContext getOpenContext() {
        return this.openContext;
    }

    public void setOpenContext(ContainerOpenContext openContext) {
        this.openContext = openContext;
    }

    private void readMatrixNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = nbtTagCompound.func_150295_c("CraftingMatrix", 10);
        this.craftMatrixInventory = new ItemStack[9];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.craftMatrixInventory.length) continue;
            this.craftMatrixInventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    public void writeToNBT(String which) {
        if (!this.containerstack.func_77942_o()) {
            this.containerstack.func_77982_d(new NBTTagCompound());
        }
        switch (which) {
            case "booster": {
                this.boosterInventory.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            case "crafting": {
                this.craftingGrid.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            case "magnet": {
                this.magnetInventory.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            case "trash": {
                this.trashInventory.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            default: {
                this.boosterInventory.writeNBT(this.containerstack.func_77978_p());
                this.craftingGrid.writeNBT(this.containerstack.func_77978_p());
                this.magnetInventory.writeNBT(this.containerstack.func_77978_p());
                this.trashInventory.writeNBT(this.containerstack.func_77978_p());
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int idx) {
        AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_75151_b.get(idx));
        ItemStack tis = clickSlot.func_75211_c();
        if (tis == null) {
            return null;
        }
        if (this.isInInventory(idx) || this.isInHotbar(idx)) {
            if (tis.func_77973_b() instanceof ItemArmor) {
                int type = ((ItemArmor)tis.func_77973_b()).field_77881_a;
                if (this.func_75135_a(tis, 37 + type, 37 + type + 1, false)) {
                    clickSlot.clearStack();
                    return null;
                }
            } else if (tis.func_77973_b() instanceof ItemInfinityBooster) {
                if (this.func_75135_a(tis, 0, 1, false)) {
                    clickSlot.clearStack();
                    return null;
                }
            } else if (tis.func_77973_b() instanceof ItemMagnet && this.func_75135_a(tis, 51, 52, false)) {
                clickSlot.clearStack();
                return null;
            }
        }
        if (Platform.isClient()) {
            return null;
        }
        boolean hasMETiles = false;
        for (Object is : this.field_75151_b) {
            if (!(is instanceof InternalSlotME)) continue;
            hasMETiles = true;
            break;
        }
        if (hasMETiles && Platform.isClient()) {
            return null;
        }
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessible) {
            return null;
        }
        if (clickSlot != null && clickSlot.func_75216_d()) {
            AppEngSlot cs;
            ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
            if (clickSlot.isPlayerSide()) {
                tis = this.shiftStoreItem(tis);
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    if (cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            } else {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    if (!cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && tis != null) {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    ItemStack destination = cs.func_75211_c();
                    if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                    if (Platform.isSameItemPrecise((ItemStack)destination, (ItemStack)tis)) {
                        return null;
                    }
                    if (destination != null) continue;
                    cs.func_75215_d(tis.func_77946_l());
                    cs.func_75218_e();
                    this.updateSlot(cs);
                    return null;
                }
            }
            if (tis != null) {
                for (Slot slot : selectedSlots) {
                    int placeAble;
                    ItemStack t;
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis) || !slot.func_75216_d() || !Platform.isSameItemPrecise((ItemStack)tis, (ItemStack)(t = slot.func_75211_c()))) continue;
                    int maxSize = t.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                        placeAble = tis.field_77994_a;
                    }
                    ItemStack itemStack = t;
                    itemStack.field_77994_a += placeAble;
                    ItemStack itemStack2 = tis;
                    itemStack2.field_77994_a -= placeAble;
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
                for (Slot slot : selectedSlots) {
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis)) continue;
                    if (slot.func_75216_d()) {
                        int placeAble;
                        ItemStack t = slot.func_75211_c();
                        if (!Platform.isSameItemPrecise((ItemStack)t, (ItemStack)tis)) continue;
                        int maxSize = t.func_77976_d();
                        if (slot.func_75219_a() < maxSize) {
                            maxSize = slot.func_75219_a();
                        }
                        if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                            placeAble = tis.field_77994_a;
                        }
                        ItemStack itemStack3 = t;
                        itemStack3.field_77994_a += placeAble;
                        ItemStack itemStack4 = tis;
                        itemStack4.field_77994_a -= placeAble;
                        if (tis.field_77994_a <= 0) {
                            clickSlot.func_75215_d(null);
                            slot.func_75218_e();
                            this.updateSlot(clickSlot);
                            this.updateSlot(slot);
                            return null;
                        }
                        this.updateSlot(slot);
                        continue;
                    }
                    int maxSize2 = tis.func_77976_d();
                    if (maxSize2 > slot.func_75219_a()) {
                        maxSize2 = slot.func_75219_a();
                    }
                    ItemStack tmp = tis.func_77946_l();
                    if (tmp.field_77994_a > maxSize2) {
                        tmp.field_77994_a = maxSize2;
                    }
                    ItemStack itemStack5 = tis;
                    itemStack5.field_77994_a -= tmp.field_77994_a;
                    slot.func_75215_d(tmp);
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
            }
            clickSlot.func_75215_d(tis != null ? tis.func_77946_l() : null);
        }
        this.updateSlot(clickSlot);
        return null;
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.func_75139_a(slotA);
        Slot b = this.func_75139_a(slotB);
        if (a == null || b == null) {
            return;
        }
        ItemStack isA = a.func_75211_c();
        ItemStack isB = b.func_75211_c();
        if (isA == null && isB == null) {
            return;
        }
        if (isA != null && !a.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (isB != null && !b.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (isB != null && !a.func_75214_a(isB)) {
            return;
        }
        if (isA != null && !b.func_75214_a(isA)) {
            return;
        }
        ItemStack testA = isB == null ? null : isB.func_77946_l();
        ItemStack itemStack = testB = isA == null ? null : isA.func_77946_l();
        if (testA != null && testA.field_77994_a > a.func_75219_a()) {
            if (testB != null) {
                return;
            }
            int totalA = testA.field_77994_a;
            testA.field_77994_a = a.func_75219_a();
            testB = testA.func_77946_l();
            testB.field_77994_a = totalA - testA.field_77994_a;
        }
        if (testB != null && testB.field_77994_a > b.func_75219_a()) {
            if (testA != null) {
                return;
            }
            int totalB = testB.field_77994_a;
            testB.field_77994_a = b.func_75219_a();
            testA = testB.func_77946_l();
            testA.field_77994_a = totalB - testA.field_77994_a;
        }
        a.func_75215_d(testA);
        b.func_75215_d(testB);
    }

    private boolean isCraftMatrixSlot(AppEngSlot cs) {
        return cs.getSlotIndex() >= this.firstCraftingSlotNumber && cs.getSlotIndex() > this.lastCraftingSlotNumber;
    }

    private void updateSlot(Slot clickSlot) {
        this.func_75142_b();
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.civ == null) {
            return input;
        }
        IAEItemStack ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.civ, (IAEStack)AEApi.instance().storage().createItemStack(input), (BaseActionSource)this.getActionSource());
        if (ais == null) {
            return null;
        }
        return ais.getItemStack();
    }

    private boolean isInHotbar(@Nonnull int index) {
        return index >= 1 && index <= 9;
    }

    private boolean isInInventory(@Nonnull int index) {
        return index >= 10 && index <= 36;
    }

    private boolean isInArmorSlot(@Nonnull int index) {
        return index >= 37 && index <= 40;
    }

    private boolean isInBoosterSlot(@Nonnull int index) {
        return index == 0;
    }

    private boolean isCraftResult(@Nonnull int index) {
        return index == 50;
    }

    private boolean isInCraftMatrix(@Nonnull int index) {
        return index >= 41 && index <= 49;
    }

    private boolean notArmorOrBooster(ItemStack is) {
        return !(is.func_77973_b() instanceof ItemInfinityBooster) && !(is.func_77973_b() instanceof ItemArmor);
    }

    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        try {
            Slot slotObj;
            if (slot >= 0 && (slotObj = this.func_75139_a(slot)) != null && slotObj.func_75211_c() == RandomUtils.getWirelessTerm(player.field_71071_by)) {
                return null;
            }
            return super.func_75144_a(slot, button, flag, player);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public final void updateFullProgressBar(int idx, long value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
            return;
        }
        this.func_75137_b(idx, (int)value);
    }

    protected boolean func_75135_a(ItemStack stack, int start, int end, boolean backwards) {
        Slot slot;
        int slotNumber;
        boolean success = false;
        if (stack.func_77985_e()) {
            int n = slotNumber = backwards ? end - 1 : start;
            while (stack.field_77994_a > 0 && !(!backwards ? slotNumber >= end : slotNumber < start)) {
                int maxStackSize;
                slot = (Slot)this.field_75151_b.get(slotNumber);
                if (!slot.func_75214_a(stack)) {
                    slotNumber += backwards ? -1 : 1;
                    continue;
                }
                ItemStack stackInSlot = slot.func_75211_c();
                if (stackInSlot != null && stackInSlot.func_77973_b() == stack.func_77973_b() && stack.func_77960_j() == stackInSlot.func_77960_j() && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackInSlot) && (maxStackSize = Math.min(slot.func_75219_a(), stack.func_77976_d())) > 0) {
                    int newStackInSlotSize = stackInSlot.field_77994_a + stack.field_77994_a;
                    if (newStackInSlotSize <= maxStackSize) {
                        stack.field_77994_a = 0;
                        stackInSlot.field_77994_a = newStackInSlotSize;
                        this.boosterInventory.func_70296_d();
                        success = true;
                    } else if (stackInSlot.field_77994_a < maxStackSize) {
                        stack.field_77994_a -= maxStackSize - stackInSlot.field_77994_a;
                        stackInSlot.field_77994_a = maxStackSize;
                        this.boosterInventory.func_70296_d();
                        success = true;
                    }
                }
                slotNumber += backwards ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n = slotNumber = backwards ? end - 1 : start;
            while (!(stack.field_77994_a <= 0 || !backwards ? slotNumber >= end : slotNumber < start)) {
                slot = (Slot)this.field_75151_b.get(slotNumber);
                if (!slot.func_75214_a(stack)) {
                    slotNumber += backwards ? -1 : 1;
                    continue;
                }
                if (slot.func_75211_c() == null) {
                    int maxStackSize2 = Math.min(slot.func_75219_a(), stack.func_77976_d());
                    if (maxStackSize2 <= 0) {
                        slotNumber += backwards ? -1 : 1;
                        continue;
                    }
                    if (stack.field_77994_a <= maxStackSize2) {
                        slot.func_75215_d(stack.func_77946_l());
                        stack.field_77994_a = 0;
                        this.boosterInventory.func_70296_d();
                        success = true;
                        break;
                    }
                    this.func_75141_a(slotNumber, stack.func_77979_a(maxStackSize2));
                    this.boosterInventory.func_70296_d();
                    success = true;
                }
                slotNumber += backwards ? -1 : 1;
            }
        }
        return success;
    }
}

