/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container.guisync;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.common.container.WCTBaseContainer;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.GuiSync;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketValueConfig;

public class SyncData {
    private final Container source;
    private final Field field;
    private final int channel;
    private Object clientVersion;

    public SyncData(Container container, Field field, GuiSync annotation) {
        this.source = container instanceof ContainerWirelessCraftingTerminal ? container : (container instanceof WCTBaseContainer ? container : container);
        this.clientVersion = null;
        this.field = field;
        this.channel = annotation.value();
    }

    public int getChannel() {
        return this.channel;
    }

    public void tick(ICrafting c) {
        try {
            Object val = this.field.get(this.source);
            if (val != null && this.clientVersion == null) {
                this.send(c, val);
            } else if (!val.equals(this.clientVersion)) {
                this.send(c, val);
            }
        }
        catch (IllegalArgumentException e) {
            WCTLog.debug(e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e2) {
            WCTLog.debug(e2.getMessage(), new Object[0]);
        }
        catch (IOException e3) {
            WCTLog.debug(e3.getMessage(), new Object[0]);
        }
    }

    private void send(ICrafting o, Object val) throws IOException {
        if (val instanceof String) {
            if (o instanceof EntityPlayerMP) {
                NetworkHandler.instance.sendTo(new PacketValueConfig("SyncDat." + this.channel, (String)val), (EntityPlayerMP)o);
            }
        } else if (this.field.getType().isEnum()) {
            o.func_71112_a(this.source, this.channel, ((Enum)val).ordinal());
        } else if (!(val instanceof Long) && val.getClass() != Long.TYPE) {
            if (val instanceof Boolean || val.getClass() == Boolean.TYPE) {
                o.func_71112_a(this.source, this.channel, (Boolean)val != false ? 1 : 0);
            } else {
                o.func_71112_a(this.source, this.channel, ((Integer)val).intValue());
            }
        }
        this.clientVersion = val;
    }

    public void update(Object val) {
        try {
            Object oldValue = this.field.get(this.source);
            if (val instanceof String) {
                this.updateString(oldValue, (String)val);
            } else {
                this.updateValue(oldValue, (Long)val);
            }
        }
        catch (IllegalArgumentException e) {
            WCTLog.debug(e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e2) {
            WCTLog.debug(e2.getMessage(), new Object[0]);
        }
    }

    private void updateString(Object oldValue, String val) {
        try {
            this.field.set(this.source, val);
        }
        catch (IllegalArgumentException e) {
            WCTLog.debug(e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e2) {
            WCTLog.debug(e2.getMessage(), new Object[0]);
        }
    }

    private void updateValue(Object oldValue, long val) {
        try {
            if (this.field.getType().isEnum()) {
                EnumSet<Enum> valList = EnumSet.allOf(this.field.getType());
                for (Enum e : valList) {
                    if ((long)e.ordinal() != val) continue;
                    this.field.set(this.source, e);
                    break;
                }
            } else if (this.field.getType().equals(Integer.TYPE)) {
                this.field.set(this.source, (int)val);
            } else if (this.field.getType().equals(Long.TYPE)) {
                this.field.set(this.source, val);
            } else if (this.field.getType().equals(Boolean.TYPE)) {
                this.field.set(this.source, val == 1L);
            } else if (this.field.getType().equals(Integer.class)) {
                this.field.set(this.source, (int)val);
            } else if (this.field.getType().equals(Long.class)) {
                this.field.set(this.source, val);
            } else if (this.field.getType().equals(Boolean.class)) {
                this.field.set(this.source, val == 1L);
            }
            if (this.source instanceof ContainerWirelessCraftingTerminal) {
                ((ContainerWirelessCraftingTerminal)this.source).onUpdate(this.field.getName(), oldValue, this.field.get(this.source));
            }
            if (this.source instanceof WCTBaseContainer) {
                ((WCTBaseContainer)this.source).onUpdate(this.field.getName(), oldValue, this.field.get(this.source));
            }
        }
        catch (IllegalArgumentException e2) {
            WCTLog.debug(e2.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e3) {
            WCTLog.debug(e3.getMessage(), new Object[0]);
        }
    }
}

