/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.core.sync.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.IPacketHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.WCTClientPacketHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.WCTServerPacketHandler;

public class NetworkHandler {
    public static NetworkHandler instance;
    private final FMLEventChannel ec;
    private final String myChannelName;
    private final IPacketHandler clientHandler;
    private final IPacketHandler serveHandler;

    public NetworkHandler(String channelName) {
        FMLCommonHandler.instance().bus().register((Object)this);
        NetworkRegistry instance = NetworkRegistry.INSTANCE;
        this.myChannelName = channelName;
        this.ec = instance.newEventDrivenChannel(channelName);
        this.ec.register((Object)this);
        this.clientHandler = this.createClientSide();
        this.serveHandler = this.createServerSide();
    }

    private IPacketHandler createClientSide() {
        try {
            return new WCTClientPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private IPacketHandler createServerSide() {
        try {
            return new WCTServerPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.packet.handler();
        if (this.serveHandler != null) {
            this.serveHandler.onPacketData(null, ev.packet, (EntityPlayer)srv.field_147369_b);
        }
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        if (this.clientHandler != null) {
            this.clientHandler.onPacketData(null, ev.packet, null);
        }
    }

    public String getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(WCTPacket message) {
        this.ec.sendToAll(message.getProxy());
    }

    public void sendTo(WCTPacket message, EntityPlayerMP player) {
        this.ec.sendTo(message.getProxy(), player);
    }

    public void sendToAllAround(WCTPacket message, NetworkRegistry.TargetPoint point) {
        this.ec.sendToAllAround(message.getProxy(), point);
    }

    public void sendToDimension(WCTPacket message, int dimensionId) {
        this.ec.sendToDimension(message.getProxy(), dimensionId);
    }

    public void sendToServer(WCTPacket message) {
        this.ec.sendToServer(message.getProxy());
    }
}

