/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.integration;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import java.lang.reflect.Field;
import net.p455w0rd.wirelesscraftingterminal.api.exceptions.ModNotInstalled;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.integration.IIntegrationModule;
import net.p455w0rd.wirelesscraftingterminal.integration.IntegrationStage;
import net.p455w0rd.wirelesscraftingterminal.integration.IntegrationType;

public final class IntegrationNode {
    private final String displayName;
    private final String modID;
    private final IntegrationType shortName;
    private IntegrationStage state = IntegrationStage.PRE_INIT;
    private IntegrationStage failedStage = IntegrationStage.PRE_INIT;
    private Throwable exception = null;
    private String name = null;
    private Class<?> classValue = null;
    private Object instance;
    private IIntegrationModule mod = null;

    public IntegrationNode(String displayName, String modID, IntegrationType shortName, String name) {
        this.displayName = displayName;
        this.shortName = shortName;
        this.modID = modID;
        this.name = name;
    }

    public String toString() {
        return this.getShortName().name() + ':' + this.getState().name();
    }

    boolean isActive() {
        if (this.getState() == IntegrationStage.PRE_INIT) {
            this.call(IntegrationStage.PRE_INIT);
        }
        return this.getState() != IntegrationStage.FAILED;
    }

    void call(IntegrationStage stage) {
        if (this.getState() != IntegrationStage.FAILED) {
            if (this.getState().ordinal() > stage.ordinal()) {
                return;
            }
            try {
                switch (stage) {
                    case PRE_INIT: {
                        boolean enabled;
                        ModAPIManager apiManager = ModAPIManager.INSTANCE;
                        boolean bl = enabled = this.modID == null || Loader.isModLoaded((String)this.modID) || apiManager.hasAPI(this.modID);
                        if (enabled) {
                            this.classValue = this.getClass().getClassLoader().loadClass(this.name);
                            this.mod = (IIntegrationModule)this.classValue.getConstructor(new Class[0]).newInstance(new Object[0]);
                            Field f = this.classValue.getField("instance");
                            f.set(this.classValue, this.setInstance(this.mod));
                            this.setState(IntegrationStage.INIT);
                            break;
                        }
                        throw new ModNotInstalled(this.modID);
                    }
                    case INIT: {
                        this.mod.init();
                        this.setState(IntegrationStage.POST_INIT);
                        break;
                    }
                    case POST_INIT: {
                        this.mod.postInit();
                        this.setState(IntegrationStage.READY);
                    }
                }
            }
            catch (Throwable t) {
                this.failedStage = stage;
                this.exception = t;
                this.setState(IntegrationStage.FAILED);
            }
        }
        if (stage == IntegrationStage.POST_INIT) {
            if (this.getState() == IntegrationStage.FAILED) {
                WCTLog.info(this.displayName + " - Integration Disabled", new Object[0]);
                if (!(this.exception instanceof ModNotInstalled)) {
                    WCTLog.integration(this.exception);
                }
            } else {
                WCTLog.info(this.displayName + " - Integration Enable", new Object[0]);
            }
        }
    }

    Object getInstance() {
        return this.instance;
    }

    private Object setInstance(Object instance) {
        this.instance = instance;
        return this.instance;
    }

    IntegrationType getShortName() {
        return this.shortName;
    }

    IntegrationStage getState() {
        return this.state;
    }

    private void setState(IntegrationStage state) {
        this.state = state;
    }
}

