/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCellWorkbench;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.container.implementations.ContainerLevelEmitter;
import appeng.container.implementations.ContainerNetworkTool;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPriority;
import appeng.container.implementations.ContainerQuartzKnife;
import appeng.container.implementations.ContainerSecurity;
import appeng.container.implementations.ContainerStorageBus;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IMouseWheelItem;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class PacketValueConfig
extends AppEngPacket {
    private String Name;
    private String Value;
    private byte packetType;
    private byte extraByte;
    private byte extraSecondByte;
    private int extraInt;
    public static final int ITEM = 0;
    public static final int TERMINAL_CPU = 1;
    public static final int CRAFT_START_OR_CANCEL = 2;
    public static final int NAME = 3;
    public static final int SECURITY_MODIFY = 4;
    public static final int PRIORITY_MODIFY = 5;
    public static final int LEVEL_EMITTER = 6;
    public static final int PATTERN_CRAFT_MODE = 7;
    public static final int PATTERN_ENCODE = 8;
    public static final int PATTERN_CLEAR_GRID = 9;
    public static final int PATTERN_SUBSTITUTE_MODE = 10;
    public static final int STORAGE_BUS_PARTITION = 11;
    public static final int STORAGE_BUS_CLEAR = 12;
    public static final int CELL_WORKBENCH_COPY_MODE = 13;
    public static final int CELL_WORKBENCH_PARTITION = 14;
    public static final int CELL_WORKBENCH_CLEAR = 15;
    public static final int CELL_WORKBENCH_FUZZY = 16;
    public static final int NETWORK_TOOL_TOGGLE_FACADES = 17;
    public static final int CHANGE_SETTING = 18;

    public PacketValueConfig(ByteBuf stream) throws IOException {
        if (Minecraft.func_71410_x().func_71356_B()) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(stream.array(), stream.readerIndex(), stream.readableBytes()));
            this.Name = dis.readUTF();
            this.Value = dis.readUTF();
        } else {
            this.packetType = stream.readByte();
            switch (this.packetType) {
                case 1: {
                    this.Value = ByteBufUtils.readUTF8String((ByteBuf)stream);
                    break;
                }
                case 3: {
                    this.extraInt = stream.readInt();
                    this.Value = ByteBufUtils.readUTF8String((ByteBuf)stream);
                    break;
                }
                case 4: {
                    this.extraByte = stream.readByte();
                    this.extraSecondByte = stream.readByte();
                }
            }
        }
    }

    public PacketValueConfig(String name, String value) throws IOException {
        this.Name = name;
        this.Value = value;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeUTF(name);
        dos.writeUTF(value);
        data.writeBytes(bos.toByteArray());
        this.configureWrite(data);
    }

    private PacketValueConfig() {
    }

    public static PacketValueConfig createPacket(int packetID) {
        PacketValueConfig packet = new PacketValueConfig();
        ByteBuf data = Unpooled.buffer();
        data.writeInt(packet.getPacketID());
        data.writeByte(packetID);
        packet.configureWrite(data);
        return packet;
    }

    public static PacketValueConfig createPacket(int packetID, boolean value) {
        PacketValueConfig packet = new PacketValueConfig();
        ByteBuf data = Unpooled.buffer();
        data.writeInt(packet.getPacketID());
        data.writeByte(packetID);
        data.writeBoolean(value);
        packet.configureWrite(data);
        return packet;
    }

    public static PacketValueConfig createPacket(int packetID, String value) {
        PacketValueConfig packet = new PacketValueConfig();
        ByteBuf data = Unpooled.buffer();
        data.writeInt(packet.getPacketID());
        data.writeByte(packetID);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)value);
        packet.configureWrite(data);
        return packet;
    }

    public static PacketValueConfig createPacket(int packetID, int value) {
        PacketValueConfig packet = new PacketValueConfig();
        ByteBuf data = Unpooled.buffer();
        data.writeInt(packet.getPacketID());
        data.writeByte(packetID);
        data.writeInt(value);
        packet.configureWrite(data);
        return packet;
    }

    public static PacketValueConfig createPacket(int packetID, long value) {
        PacketValueConfig packet = new PacketValueConfig();
        ByteBuf data = Unpooled.buffer();
        data.writeInt(packet.getPacketID());
        data.writeByte(packetID);
        data.writeLong(value);
        packet.configureWrite(data);
        return packet;
    }

    public static PacketValueConfig createPacket(int packetID, byte value) {
        PacketValueConfig packet = new PacketValueConfig();
        ByteBuf data = Unpooled.buffer();
        data.writeInt(packet.getPacketID());
        data.writeByte(packetID);
        data.writeByte((int)value);
        packet.configureWrite(data);
        return packet;
    }

    public static PacketValueConfig createPacket(int packetID, int firstValue, int secondValue) {
        PacketValueConfig packet = new PacketValueConfig();
        ByteBuf data = Unpooled.buffer();
        data.writeInt(packet.getPacketID());
        data.writeByte(packetID);
        data.writeByte(firstValue);
        data.writeByte(secondValue);
        packet.configureWrite(data);
        return packet;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        block5: {
            Container c;
            block24: {
                block20: {
                    ContainerCellWorkbench ccw;
                    block21: {
                        block23: {
                            block22: {
                                block18: {
                                    ContainerStorageBus ccw2;
                                    block19: {
                                        block14: {
                                            ContainerPatternTerm cpt;
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block13: {
                                                            block12: {
                                                                block11: {
                                                                    block10: {
                                                                        block9: {
                                                                            block8: {
                                                                                block7: {
                                                                                    block6: {
                                                                                        block4: {
                                                                                            c = player.field_71070_bA;
                                                                                            if (!this.Name.equals("Item") || player.func_70694_bm() == null || !(player.func_70694_bm().func_77973_b() instanceof IMouseWheelItem)) break block4;
                                                                                            ItemStack is = player.func_70694_bm();
                                                                                            IMouseWheelItem si = (IMouseWheelItem)is.func_77973_b();
                                                                                            si.onWheel(is, this.Value.equals("WheelUp"));
                                                                                            break block5;
                                                                                        }
                                                                                        if (!this.Name.equals("Terminal.Cpu") || !(c instanceof ContainerCraftingStatus)) break block6;
                                                                                        ContainerCraftingStatus qk = (ContainerCraftingStatus)c;
                                                                                        qk.cycleCpu(this.Value.equals("Next"));
                                                                                        break block5;
                                                                                    }
                                                                                    if (!this.Name.equals("Terminal.Cpu") || !(c instanceof ContainerCraftConfirm)) break block7;
                                                                                    ContainerCraftConfirm qk = (ContainerCraftConfirm)c;
                                                                                    qk.cycleCpu(this.Value.equals("Next"));
                                                                                    break block5;
                                                                                }
                                                                                if (!this.Name.equals("Terminal.Start") || !(c instanceof ContainerCraftConfirm)) break block8;
                                                                                ContainerCraftConfirm qk = (ContainerCraftConfirm)c;
                                                                                qk.startJob();
                                                                                break block5;
                                                                            }
                                                                            if (!this.Name.equals("TileCrafting.Cancel") || !(c instanceof ContainerCraftingCPU)) break block9;
                                                                            ContainerCraftingCPU qk = (ContainerCraftingCPU)c;
                                                                            qk.cancelCrafting();
                                                                            break block5;
                                                                        }
                                                                        if (!this.Name.equals("QuartzKnife.Name") || !(c instanceof ContainerQuartzKnife)) break block10;
                                                                        ContainerQuartzKnife qk = (ContainerQuartzKnife)c;
                                                                        qk.setName(this.Value);
                                                                        break block5;
                                                                    }
                                                                    if (!this.Name.equals("TileSecurity.ToggleOption") || !(c instanceof ContainerSecurity)) break block11;
                                                                    ContainerSecurity sc = (ContainerSecurity)c;
                                                                    sc.toggleSetting(this.Value, player);
                                                                    break block5;
                                                                }
                                                                if (!this.Name.equals("PriorityHost.Priority") || !(c instanceof ContainerPriority)) break block12;
                                                                ContainerPriority pc = (ContainerPriority)c;
                                                                pc.setPriority(Integer.parseInt(this.Value), player);
                                                                break block5;
                                                            }
                                                            if (!this.Name.equals("LevelEmitter.Value") || !(c instanceof ContainerLevelEmitter)) break block13;
                                                            ContainerLevelEmitter lvc = (ContainerLevelEmitter)c;
                                                            lvc.setLevel(Long.parseLong(this.Value), player);
                                                            break block5;
                                                        }
                                                        if (!this.Name.startsWith("PatternTerminal.") || !(c instanceof ContainerPatternTerm)) break block14;
                                                        cpt = (ContainerPatternTerm)c;
                                                        if (!this.Name.equals("PatternTerminal.CraftMode")) break block15;
                                                        cpt.getPatternTerminal().setCraftingRecipe(this.Value.equals("1"));
                                                        break block5;
                                                    }
                                                    if (!this.Name.equals("PatternTerminal.Encode")) break block16;
                                                    cpt.encode();
                                                    break block5;
                                                }
                                                if (!this.Name.equals("PatternTerminal.Clear")) break block17;
                                                cpt.clear();
                                                break block5;
                                            }
                                            if (!this.Name.equals("PatternTerminal.Substitute")) break block5;
                                            cpt.getPatternTerminal().setSubstitution(this.Value.equals("1"));
                                            break block5;
                                        }
                                        if (!this.Name.startsWith("StorageBus.") || !(c instanceof ContainerStorageBus)) break block18;
                                        ccw2 = (ContainerStorageBus)c;
                                        if (!this.Name.equals("StorageBus.Action")) break block5;
                                        if (!this.Value.equals("Partition")) break block19;
                                        ccw2.partition();
                                        break block5;
                                    }
                                    if (!this.Value.equals("Clear")) break block5;
                                    ccw2.clear();
                                    break block5;
                                }
                                if (!this.Name.startsWith("CellWorkbench.") || !(c instanceof ContainerCellWorkbench)) break block20;
                                ccw = (ContainerCellWorkbench)c;
                                if (!this.Name.equals("CellWorkbench.Action")) break block21;
                                if (!this.Value.equals("CopyMode")) break block22;
                                ccw.nextWorkBenchCopyMode();
                                break block5;
                            }
                            if (!this.Value.equals("Partition")) break block23;
                            ccw.partition();
                            break block5;
                        }
                        if (!this.Value.equals("Clear")) break block5;
                        ccw.clear();
                        break block5;
                    }
                    if (!this.Name.equals("CellWorkbench.Fuzzy")) break block5;
                    ccw.setFuzzy(FuzzyMode.valueOf(this.Value));
                    break block5;
                }
                if (!(c instanceof ContainerNetworkTool)) break block24;
                if (!this.Name.equals("NetworkTool") || !this.Value.equals("Toggle")) break block5;
                ((ContainerNetworkTool)c).toggleFacadeMode();
                break block5;
            }
            if (c instanceof IConfigurableObject) {
                IConfigManager cm = ((IConfigurableObject)c).getConfigManager();
                for (Settings e : cm.getSettings()) {
                    if (!e.name().equals(this.Name)) continue;
                    Enum<?> def = cm.getSetting(e);
                    try {
                        cm.putSetting(e, (Enum<?>)Enum.valueOf(def.getClass(), this.Value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        Container c = player.field_71070_bA;
        if (Minecraft.func_71410_x().func_71356_B()) {
            if (this.Name.equals("CustomName") && c instanceof AEBaseContainer) {
                ((AEBaseContainer)c).setCustomName(this.Value);
            } else if (this.Name.startsWith("SyncDat.")) {
                ((AEBaseContainer)c).stringSync(Integer.parseInt(this.Name.substring(8)), this.Value);
            } else if (this.Name.equals("CraftingStatus") && this.Value.equals("Clear")) {
                GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
                if (gs instanceof GuiCraftingCPU) {
                    ((GuiCraftingCPU)gs).clearItems();
                }
            } else if (c instanceof IConfigurableObject) {
                IConfigManager cm = ((IConfigurableObject)c).getConfigManager();
                for (Settings e : cm.getSettings()) {
                    if (!e.name().equals(this.Name)) continue;
                    Enum<?> def = cm.getSetting(e);
                    try {
                        cm.putSetting(e, (Enum<?>)Enum.valueOf(def.getClass(), this.Value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
            }
        } else {
            block2 : switch (this.packetType) {
                case 1: {
                    if (this.Value != null && c instanceof AEBaseContainer) {
                        ((AEBaseContainer)c).setCustomName(this.Value);
                    }
                    break;
                }
                case 2: {
                    GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
                    if (!(gs instanceof GuiCraftingCPU)) break;
                    ((GuiCraftingCPU)gs).clearItems();
                    break;
                }
                case 3: {
                    if (this.Value != null && c instanceof AEBaseContainer) {
                        ((AEBaseContainer)c).stringSync(this.extraInt, this.Value);
                    }
                    break;
                }
                case 4: {
                    if (!(c instanceof IConfigurableObject)) break;
                    IConfigManager cm = ((IConfigurableObject)c).getConfigManager();
                    for (Settings setting : cm.getSettings()) {
                        if (setting.ordinal() != this.extraByte) continue;
                        try {
                            cm.putSetting(setting, ((Enum[])cm.getSetting(setting).getClass().getEnumConstants())[this.extraSecondByte]);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        break block2;
                    }
                    break;
                }
            }
        }
    }
}

