/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.util.Platform;
import appeng.util.item.AEItemDef;
import appeng.util.item.AESharedNBT;
import appeng.util.item.AEStack;
import appeng.util.item.OreHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack,
Comparable<AEItemStack> {
    private AEItemDef def;

    private AEItemStack(AEItemStack is) {
        this.def = is.def;
        this.setStackSize(is.getStackSize());
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
    }

    private AEItemStack(ItemStack is) {
        AEItemDef d;
        if (is == null) {
            throw new InvalidParameterException("null is not a valid ItemStack for AEItemStack.");
        }
        Item item = is.func_77973_b();
        if (item == null) {
            throw new InvalidParameterException("Contained item is null, thus not a valid ItemStack for AEItemStack.");
        }
        this.def = d = new AEItemDef(item);
        d.damageValue = Items.field_151072_bj.getDamage(is);
        d.displayDamage = is.func_77952_i();
        d.setMaxDamage(is.func_77958_k());
        NBTTagCompound tagCompound = is.field_77990_d;
        if (tagCompound != null) {
            d.setTagCompound((AESharedNBT)AESharedNBT.getSharedTagCompound(tagCompound, is));
        }
        this.setStackSize(is.field_77994_a);
        d.reHash();
        d.lazyOreRef = new OreHelper.ItemRef(item, d.itemID, d.damageValue);
    }

    public static IAEItemStack loadItemStackFromNBT(NBTTagCompound i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)i);
        if (itemstack == null) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.setStackSize(i.func_74763_f("Cnt"));
        item.setCountRequestable(i.func_74763_f("Req"));
        item.setCraftable(i.func_74767_n("Craft"));
        return item;
    }

    @Nullable
    public static AEItemStack create(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return new AEItemStack(stack);
    }

    public static IAEItemStack loadItemStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        d.func_74777_a("id", data.readShort());
        d.func_74777_a("Damage", data.readShort());
        d.func_74774_a("Count", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            ByteArrayInputStream di = new ByteArrayInputStream(bd);
            d.func_74782_a("tag", (NBTBase)CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(di)));
        }
        long stackSize = AEItemStack.getPacketValue(stackType, data);
        long countRequestable = AEItemStack.getPacketValue(countReqType, data);
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)d);
        if (itemstack == null) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.setStackSize(stackSize);
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        return item;
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public void writeToNBT(NBTTagCompound i) {
        i.func_74777_a("id", (short)this.def.getItemID());
        i.func_74774_a("Count", (byte)0);
        i.func_74772_a("Cnt", this.getStackSize());
        i.func_74772_a("Req", this.getCountRequestable());
        i.func_74757_a("Craft", this.isCraftable());
        i.func_74777_a("Damage", (short)this.def.getDamageValue());
        if (this.def.getTagCompound() != null) {
            i.func_74782_a("tag", (NBTBase)this.def.getTagCompound());
        } else {
            i.func_82580_o("tag");
        }
    }

    @Override
    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        IAEItemStack o;
        if (st instanceof IAEItemStack) {
            o = (IAEItemStack)st;
            if (this.sameOre(o)) {
                return true;
            }
            if (o.getItem() == this.getItem()) {
                if (this.def.getItem().func_77645_m()) {
                    ItemStack a = this.getItemStackRaw();
                    ItemStack b = o instanceof AEItemStack ? ((AEItemStack)o).getItemStackRaw() : o.getItemStack();
                    try {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                        }
                        float percentDamageOfA = 1.0f - (float)a.func_77952_i() / (float)a.func_77958_k();
                        float percentDamageOfB = 1.0f - (float)b.func_77952_i() / (float)b.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77960_j() > 1 == b.func_77960_j() > 1;
                        }
                        float percentDamageOfA = (float)a.func_77960_j() / (float)a.func_77958_k();
                        float percentDamageOfB = (float)b.func_77960_j() / (float)b.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.getItemDamage();
            }
        }
        if (st instanceof ItemStack && (o = (ItemStack)st).func_77973_b() == this.getItem()) {
            if (this.def.getItem().func_77645_m()) {
                ItemStack a = this.getItemStackRaw();
                try {
                    if (mode == FuzzyMode.IGNORE_ALL) {
                        return true;
                    }
                    if (mode == FuzzyMode.PERCENT_99) {
                        return a.func_77952_i() > 1 == o.func_77952_i() > 1;
                    }
                    float percentDamageOfA = 1.0f - (float)a.func_77952_i() / (float)a.func_77958_k();
                    float percentDamageOfB = 1.0f - (float)o.func_77952_i() / (float)o.func_77958_k();
                    return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                }
                catch (Throwable e) {
                    if (mode == FuzzyMode.PERCENT_99) {
                        return a.func_77960_j() > 1 == o.func_77960_j() > 1;
                    }
                    float percentDamageOfA = (float)a.func_77960_j() / (float)a.func_77958_k();
                    float percentDamageOfB = (float)o.func_77960_j() / (float)o.func_77958_k();
                    return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                }
            }
            return this.getItemDamage() == o.func_77960_j();
        }
        return false;
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public IAEItemStack empty() {
        IAEItemStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public IAETagCompound getTagCompound() {
        return this.def.getTagCompound();
    }

    @Override
    public boolean isItem() {
        return true;
    }

    @Override
    public boolean isFluid() {
        return false;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public ItemStack getItemStack() {
        long count = this.getStackSize();
        ItemStack is = new ItemStack(this.def.getItem(), count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count, this.def.getDamageValue());
        if (this.def.getTagCompound() != null) {
            is.field_77990_d = this.def.getTagCompound().getNBTTagCompoundCopy();
        }
        return is;
    }

    @Override
    public Item getItem() {
        return this.def.getItem();
    }

    @Override
    public int getItemDamage() {
        return this.def.getDamageValue();
    }

    @Override
    public boolean sameOre(IAEItemStack is) {
        return OreHelper.INSTANCE.sameOre(this, is);
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.def.equals(((AEItemStack)otherStack).def);
    }

    @Override
    public boolean isSameType(ItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.def.isItem(otherStack);
    }

    public int hashCode() {
        return this.def.myHash;
    }

    @Override
    public boolean equals(Object ia) {
        if (ia instanceof AEItemStack) {
            return ((AEItemStack)ia).def.equals0(this.def);
        }
        if (ia instanceof ItemStack) {
            ItemStack is = (ItemStack)ia;
            AEItemDef deff = this.def;
            if (Items.field_151072_bj.getDamage(is) == deff.damageValue && is.func_77973_b() == deff.item) {
                AESharedNBT ta = deff.tagCompound;
                NBTTagCompound tb = is.func_77978_p();
                if (ta == tb) {
                    return true;
                }
                if (ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
                    return true;
                }
                if (ta == null || tb == null) {
                    return false;
                }
                if (tb instanceof AESharedNBT) {
                    return ta == tb;
                }
                return Platform.NBTEqualityTest((NBTBase)ta, (NBTBase)tb);
            }
        }
        return false;
    }

    public String toString() {
        return this.getItemStackRaw().toString();
    }

    @Override
    public int compareTo(AEItemStack b) {
        int m;
        AEItemDef currentDef = this.def;
        AEItemDef testDef = b.def;
        int id = currentDef.itemID - testDef.itemID;
        if (id != 0) {
            return id;
        }
        int damageValue = currentDef.damageValue - testDef.damageValue;
        if (damageValue != 0) {
            return damageValue;
        }
        int displayDamage = currentDef.displayDamage - testDef.displayDamage;
        if (displayDamage != 0) {
            return displayDamage;
        }
        if (currentDef.tagCompound == testDef.tagCompound) {
            return 0;
        }
        int l = currentDef.tagCompound == null ? 0 : currentDef.tagCompound.nbtIdentityHash;
        int n = m = testDef.tagCompound == null ? 0 : testDef.tagCompound.nbtIdentityHash;
        return l < m ? -1 : (l > m ? 1 : 0);
    }

    private int compareNBT(AEItemDef b) {
        int m;
        AEItemDef deff = this.def;
        int l = deff.tagCompound == null ? 0 : deff.tagCompound.nbtIdentityHash;
        int n = m = b.tagCompound == null ? 0 : b.tagCompound.nbtIdentityHash;
        return l < m ? -1 : (l > m ? 1 : 0);
    }

    private int compare(int l, int m) {
        return l < m ? -1 : (l > m ? 1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public List getToolTip() {
        if (this.def.getTooltip() != null) {
            return this.def.getTooltip();
        }
        return this.def.setTooltip(Platform.getTooltip(this.getItemStack()));
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.def.getDisplayName() == null) {
            this.def.setDisplayName(Platform.getItemDisplayName(this.getItemStack()));
        }
        return this.def.getDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    public String getModID() {
        if (this.def.getUniqueID() != null) {
            return this.getModName(this.def.getUniqueID());
        }
        return this.getModName(this.def.setUniqueID(GameRegistry.findUniqueIdentifierFor((Item)this.def.getItem())));
    }

    private String getModName(GameRegistry.UniqueIdentifier uniqueIdentifier) {
        if (uniqueIdentifier == null) {
            return "** Null";
        }
        return uniqueIdentifier.modId == null ? "** Null" : uniqueIdentifier.modId;
    }

    IAEItemStack getLow(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack bottom = new AEItemStack(this);
        AEItemDef newDef = bottom.setDefinition(bottom.def.copy());
        if (ignoreMeta) {
            newDef.setDisplayDamage(newDef.setDamageValue(0));
            newDef.reHash();
            return bottom;
        }
        if (newDef.getItem().func_77645_m()) {
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                newDef.setDisplayDamage(0);
            } else if (fuzzy == FuzzyMode.PERCENT_99) {
                if (this.def.getDamageValue() == 0) {
                    newDef.setDisplayDamage(0);
                } else {
                    newDef.setDisplayDamage(1);
                }
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(this.def.getMaxDamage());
                newDef.setDisplayDamage(breakpoint <= this.def.getDisplayDamage() ? breakpoint : 0);
            }
            newDef.setDamageValue(newDef.getDisplayDamage());
        }
        newDef.setTagCompound(AEItemDef.LOW_TAG);
        newDef.reHash();
        return bottom;
    }

    IAEItemStack getHigh(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack top = new AEItemStack(this);
        AEItemDef newDef = top.setDefinition(top.def.copy());
        if (ignoreMeta) {
            newDef.setDisplayDamage(newDef.setDamageValue(Integer.MAX_VALUE));
            newDef.reHash();
            return top;
        }
        if (newDef.getItem().func_77645_m()) {
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                newDef.setDisplayDamage(this.def.getMaxDamage() + 1);
            } else if (fuzzy == FuzzyMode.PERCENT_99) {
                if (this.def.getDamageValue() == 0) {
                    newDef.setDisplayDamage(0);
                } else {
                    newDef.setDisplayDamage(this.def.getMaxDamage() + 1);
                }
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(this.def.getMaxDamage());
                newDef.setDisplayDamage(this.def.getDisplayDamage() < breakpoint ? breakpoint - 1 : this.def.getMaxDamage() + 1);
            }
            newDef.setDamageValue(newDef.getDisplayDamage());
        }
        newDef.setTagCompound(AEItemDef.HIGH_TAG);
        newDef.reHash();
        return top;
    }

    public boolean isOre() {
        return this.getDefinition().getIsOre() != null;
    }

    @Override
    void writeIdentity(ByteBuf i) throws IOException {
        i.writeShort(Item.field_150901_e.func_148757_b((Object)this.getDefinition().getItem()));
        i.writeShort(this.getItemDamage());
    }

    @Override
    void readNBT(ByteBuf i) throws IOException {
        if (this.hasTagCompound()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)this.getTagCompound()), (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            i.writeInt(size);
            i.writeBytes(tagBytes);
        }
    }

    @Override
    public boolean hasTagCompound() {
        return this.getDefinition().getTagCompound() != null;
    }

    AEItemDef getDefinition() {
        return this.def;
    }

    private AEItemDef setDefinition(AEItemDef def) {
        this.def = def;
        return def;
    }

    public ItemStack getItemStackRaw() {
        ItemStack is = new ItemStack(this.def.getItem(), (int)Math.min(Integer.MAX_VALUE, this.getStackSize()), this.def.getDamageValue());
        is.func_77982_d((NBTTagCompound)this.def.getTagCompound());
        return is;
    }
}

