/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import appeng.util.item.OreReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreHelper {
    public static final OreHelper INSTANCE = new OreHelper();
    private static final Map<StringKey, List<ItemStack>> ORE_IDS_CACHE = new HashMap<StringKey, List<ItemStack>>(256);
    private final Map<ItemRef, OreReference> references = new HashMap<ItemRef, OreReference>(150);
    private static final OreReference NULL_REF;

    public OreReference isOre(ItemStack itemStack) {
        return this.isOre(new ItemRef(itemStack));
    }

    public final OreReference isOre(ItemRef rawRef) {
        OreReference v = this.references.computeIfAbsent(rawRef, key -> {
            OreReference ref = new OreReference();
            Collection<Integer> ores = ref.getOres();
            Collection<String> set = ref.getEquivalents();
            HashSet<String> toAdd = new HashSet<String>();
            Class<OreHelper> clazz = OreHelper.class;
            synchronized (OreHelper.class) {
                ItemStack searchPattern = new ItemStack(((ItemRef)key).ref, 1, ((ItemRef)key).realDamage);
                block3: for (String ore : OreDictionary.getOreNames()) {
                    if (ore == null || toAdd.contains(ore)) continue;
                    for (ItemStack oreItem : ORE_IDS_CACHE.computeIfAbsent(new StringKey(ore), name -> OreDictionary.getOres((String)ore))) {
                        if (!OreDictionary.itemMatches((ItemStack)oreItem, (ItemStack)searchPattern, (boolean)false)) continue;
                        toAdd.add(ore);
                        continue block3;
                    }
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                for (String ore : toAdd) {
                    set.add(ore);
                    ores.add(OreDictionary.getOreID((String)ore));
                }
                if (!set.isEmpty()) {
                    return ref;
                }
                return NULL_REF;
            }
        });
        if (v == NULL_REF) {
            return null;
        }
        return v;
    }

    boolean sameOre(AEItemStack aeItemStack, IAEItemStack is) {
        OreReference a = aeItemStack.getDefinition().getIsOre();
        OreReference b = aeItemStack.getDefinition().getIsOre();
        return this.sameOre(a, b);
    }

    public boolean sameOre(OreReference a, OreReference b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        Collection<Integer> bOres = b.getOres();
        for (Integer ore : a.getOres()) {
            if (!bOres.contains(ore)) continue;
            return true;
        }
        return false;
    }

    boolean sameOre(AEItemStack aeItemStack, ItemStack o) {
        OreReference a = aeItemStack.getDefinition().getIsOre();
        if (a == null) {
            return false;
        }
        for (String oreName : a.getEquivalents()) {
            for (ItemStack oreItem : ORE_IDS_CACHE.computeIfAbsent(new StringKey(oreName), name -> OreDictionary.getOres((String)oreName))) {
                if (!OreDictionary.itemMatches((ItemStack)oreItem, (ItemStack)o, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    List<ItemStack> getCachedOres(String oreName) {
        return ORE_IDS_CACHE.computeIfAbsent(new StringKey(oreName), name -> OreDictionary.getOres((String)oreName));
    }

    static {
        Thread cleanThread = new Thread(() -> {
            while (true) {
                Class<OreHelper> clazz = OreHelper.class;
                // MONITORENTER : appeng.util.item.OreHelper.class
                long time = System.currentTimeMillis();
                ORE_IDS_CACHE.keySet().removeIf(itemStackKey -> itemStackKey.expireTime < time);
                // MONITOREXIT : clazz
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        cleanThread.setDaemon(true);
        cleanThread.setPriority(1);
        cleanThread.start();
        NULL_REF = new OreReference();
    }

    private static final class StringKey {
        final String string;
        final long expireTime = System.currentTimeMillis() + 300000L;

        public StringKey(@Nonnull String string) {
            this.string = string;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            StringKey that = (StringKey)o;
            return Objects.equals(this.string, that.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }
    }

    public static class ItemRef {
        private final Item ref;
        private final int damage;
        private final int hash;
        private final int realDamage;

        public ItemRef(ItemStack stack) {
            this.ref = stack.func_77973_b();
            this.realDamage = Items.field_151055_y.getDamage(stack);
            this.damage = this.ref.func_77645_m() ? 0 : this.realDamage;
            this.hash = Item.func_150891_b((Item)this.ref) << 16 | this.damage;
        }

        public ItemRef(Item item, int id, int meta) {
            this.ref = item;
            this.realDamage = meta;
            this.damage = this.ref.func_77645_m() ? 0 : meta;
            this.hash = id << 16 | this.damage;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            ItemRef other = (ItemRef)obj;
            return this.damage == other.damage && this.ref == other.ref;
        }

        public String toString() {
            return "ItemRef [ref=" + this.ref.func_77658_a() + ", damage=" + this.damage + ", hash=" + this.hash + ']';
        }
    }
}

