/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.core.genetics.Gene;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import binnie.genetics.GeneticsCreativeTab;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemAnalysable;
import binnie.genetics.api.IItemChargable;
import binnie.genetics.genetics.GeneItem;
import binnie.genetics.genetics.SequencerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import team.luxinfine.binnie.EventConfig;

public class ItemSequence
extends Item
implements IItemAnalysable,
IItemChargable {
    public ItemSequence() {
        this.func_77625_d(1);
        this.func_77656_e(5);
        this.func_77655_b("sequence");
        this.func_77637_a(GeneticsCreativeTab.instance);
    }

    public static ItemStack create(IGene gene) {
        return ItemSequence.create(gene, false);
    }

    public static ItemStack create(IGene gene, boolean sequenced) {
        ItemStack item = new ItemStack(Genetics.itemSequencer);
        item.func_77964_b(sequenced ? 0 : item.func_77958_k());
        SequencerItem seq = new SequencerItem(gene);
        seq.writeToItem(item);
        return item;
    }

    public String func_77653_i(ItemStack stack) {
        GeneItem gene = new GeneItem(stack);
        if (gene.isCorrupted()) {
            return I18N.localise("genetics.sequence.corrupted");
        }
        return I18N.localise("genetics.sequence.descriptor", gene.getBreedingSystem().getDescriptor());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        tooltip.add(I18N.localise("genetics.item.sequence." + (5 - stack.func_77960_j() % 6)));
        SequencerItem gene = new SequencerItem(stack);
        if (gene.isCorrupted()) {
            return;
        }
        if (gene.analysed) {
            gene.getInfo(tooltip);
        } else {
            tooltip.add(I18N.localise("genetics.sequence.unknown"));
        }
        int seq = gene.sequenced;
        if (seq == 0) {
            tooltip.add(I18N.localise("genetics.sequence.unsequenced"));
        } else if (seq < 100) {
            tooltip.add(I18N.localise("genetics.sequence.partially", seq));
        } else {
            tooltip.add(I18N.localise("genetics.sequence.fully"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = Genetics.proxy.getIcon(register, "sequencer");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (EventConfig.hideSerums) {
            return;
        }
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMeadows");
        list.add(ItemSequence.create(new Gene((IAllele)species, (IChromosomeType)EnumBeeChromosome.SPECIES, (ISpeciesRoot)Binnie.Genetics.getBeeRoot()), false));
    }

    @Override
    public boolean isAnalysed(ItemStack stack) {
        SequencerItem seq = new SequencerItem(stack);
        return seq.isCorrupted() || seq.analysed;
    }

    @Override
    public ItemStack analyse(ItemStack stack) {
        SequencerItem seq = new SequencerItem(stack);
        seq.analysed = true;
        seq.writeToItem(stack);
        return stack;
    }

    @Override
    public float getAnalyseTimeMult(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77973_b().func_77612_l() - stack.func_77960_j();
    }
}

