/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.sequencer;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.api.IGene;
import binnie.genetics.genetics.GeneTracker;
import binnie.genetics.genetics.SequencerItem;
import binnie.genetics.item.GeneticsItems;
import net.minecraft.item.ItemStack;

public class SequencerComponentLogic
extends ComponentProcess
implements IProcess,
ComponentInventoryTransfer.ITransferRestockListener {
    public SequencerComponentLogic(Machine machine) {
        super(machine);
    }

    public float getSequenceStrength() {
        ItemStack stack = this.getUtil().getStack(5);
        if (stack == null) {
            return 1.0f;
        }
        float mult = 1.0f - (float)(stack.func_77960_j() % 6) / 5.0f;
        float sequenceStrength = 1.0f - mult * mult * 0.75f;
        if (sequenceStrength == 0.0f) {
            return 1.0f;
        }
        return sequenceStrength;
    }

    @Override
    public int getProcessLength() {
        return (int)(19200.0f * this.getSequenceStrength());
    }

    @Override
    public int getProcessEnergy() {
        return this.getProcessLength() * 20;
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(5)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.sequencer.error.noSequence"), 5);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.getMachine().getOwner() == null) {
            return new ErrorState(I18N.localise("genetics.machine.sequencer.error.noOwner.title"), I18N.localise("genetics.machine.sequencer.error.noOwner"));
        }
        MachineUtil util = this.getUtil();
        if (util.getSlotCharge(0) == 0.0f) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.sequencer.error.noDye"), 0);
        }
        ItemStack stack = util.getStack(6);
        if (stack != null && stack.field_77994_a >= 64) {
            return new ErrorState.NoSpace(I18N.localise("genetics.machine.sequencer.error.noSpace"), 6);
        }
        return super.canProgress();
    }

    @Override
    public void onRestock(int target) {
        this.onStartTask();
    }

    @Override
    protected void onStartTask() {
        super.onStartTask();
        ItemStack item = this.getUtil().getStack(5);
        SequencerItem seqItem = new SequencerItem(item);
        int seq = seqItem.sequenced;
        if (seq != 0) {
            this.setProgress(seq);
        }
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        this.updateSequence();
        MachineUtil util = this.getUtil();
        SequencerItem seqItem = new SequencerItem(util.getStack(5));
        IGene gene = seqItem.getGene();
        if (gene != null) {
            GeneTracker.getTracker(this.getMachine().getWorld(), this.getMachine().getOwner()).registerGene(gene);
        }
        util.decreaseStack(5, 1);
        if (util.getStack(6) == null) {
            util.setStack(6, GeneticsItems.EmptySequencer.get(1));
        } else {
            util.decreaseStack(6, -1);
        }
    }

    @Override
    protected void onTickTask() {
        this.updateSequence();
        this.getUtil().useCharge(0, 0.4f * this.getProgressPerTick() / 100.0f);
    }

    private void updateSequence() {
        int prog = (int)this.getProgress();
        ItemStack item = this.getUtil().getStack(5);
        SequencerItem seqItem = new SequencerItem(item);
        int seq = seqItem.sequenced;
        if (prog != seq) {
            seqItem.sequenced = prog;
            seqItem.writeToItem(item);
        }
    }
}

