/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.enderquarry;

import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.tileentity.enderquarry.BlockDummy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class BlockBreakingRegistry {
    public static BlockBreakingRegistry instance = new BlockBreakingRegistry();
    public static Set<String> methodNames = null;
    private static Map<String, Boolean> names = new HashMap<String, Boolean>();
    public static LaunchClassLoader cl = (LaunchClassLoader)BlockBreakingRegistry.class.getClassLoader();
    private static Set<Block> specials = new HashSet<Block>();

    public static boolean blackList(Block id) {
        return id == Blocks.field_150478_aa || BlockBreakingRegistry.isFluid(id);
    }

    public static boolean isSpecial(Block id) {
        return specials.contains(id);
    }

    public static boolean isFence(Block id) {
        return id instanceof BlockFence || id.func_149645_b() == 11;
    }

    public static boolean isFluid(Block id) {
        return XUHelper.isFluidBlock(id) || id == Blocks.field_150356_k || id == Blocks.field_150358_i || id instanceof BlockLiquid;
    }

    public void setupBreaking() {
        if (methodNames == null) {
            methodNames = new HashSet<String>();
            for (Method m : BlockDummy.class.getDeclaredMethods()) {
                methodNames.add(m.getName());
            }
            for (Object aBlockRegistry : Block.field_149771_c) {
                Block block = (Block)aBlockRegistry;
                if (!this.hasSpecialBreaking(block.getClass())) continue;
                specials.add(block);
            }
            names.clear();
        }
    }

    public boolean hasSpecialBreaking(Class clazz) {
        if (clazz != null && !clazz.equals(Block.class)) {
            if (names.containsKey(clazz.getName())) {
                return names.get(clazz.getName());
            }
            try {
                byte[] bytes = clazz.getClassLoader() instanceof LaunchClassLoader ? ((LaunchClassLoader)clazz.getClassLoader()).getClassBytes(clazz.getName()) : cl.getClassBytes(clazz.getName());
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)classNode, 0);
                for (MethodNode method : classNode.methods) {
                    if (!methodNames.contains(method.name)) continue;
                    LogHelper.fine("Detected special block breaking code in class: " + clazz.getName(), new Object[0]);
                    names.put(clazz.getName(), Boolean.TRUE);
                    return true;
                }
            }
            catch (Throwable var8) {
                try {
                    for (Method m : clazz.getDeclaredMethods()) {
                        if (!methodNames.contains(m.getName())) continue;
                        LogHelper.fine("Detected special block breaking code in class: " + clazz.getName(), new Object[0]);
                        names.put(clazz.getName(), Boolean.TRUE);
                        return true;
                    }
                }
                catch (Throwable var7) {
                    LogHelper.error("Error checking block class code: " + clazz.getName(), new Object[0]);
                    var8.printStackTrace();
                    var7.printStackTrace();
                    names.put(clazz.getName(), Boolean.TRUE);
                    return true;
                }
            }
            boolean result = this.hasSpecialBreaking(clazz.getSuperclass());
            names.put(clazz.getName(), result);
            return result;
        }
        return false;
    }

    public static class entry {
        public boolean isSpecial = false;
        public boolean blackList = false;
        public boolean isFence = false;
        public boolean isFluid = false;
    }
}

