/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import cofh.api.energy.IEnergyHandler;
import forestry.api.core.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.energy.EnergyManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IEnergyHandler,
IActivatable,
IAlvearyComponent.Climatiser {
    private static final int WORK_CYCLES = 1;
    private static final int ENERGY_PER_OPERATION = 50;
    private final EnergyManager energyManager;
    private final IClimitiserDefinition definition;
    private int workingTime = 0;
    private boolean active;

    protected TileAlvearyClimatiser(IClimitiserDefinition definition) {
        this.definition = definition;
        this.energyManager = new EnergyManager(1000, 2000);
        this.energyManager.setReceiveOnly();
    }

    @Override
    public void changeClimate(int tick, IClimateControlled climateControlled) {
        if (this.workingTime < 20 && this.energyManager.consumeEnergyToDoWork(1, 50)) {
            this.workingTime += 5;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            climateControlled.addTemperatureChange(this.definition.getChangePerTransfer(), this.definition.getBoundaryDown(), this.definition.getBoundaryUp());
        }
        this.setActive(this.workingTime > 0);
    }

    @Override
    public int getIcon(int side) {
        if (this.active) {
            return this.definition.getIconOn();
        }
        return this.definition.getIconOff();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energyManager.readFromNBT(nbttagcompound);
        this.workingTime = nbttagcompound.func_74762_e("Heating");
        this.setActive(this.workingTime > 0);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.energyManager.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Heating", this.workingTime);
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.field_145850_b);
            }
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }

    protected static interface IClimitiserDefinition {
        public float getChangePerTransfer();

        public float getBoundaryUp();

        public float getBoundaryDown();

        public int getIconOff();

        public int getIconOn();
    }
}

