/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.blocks.BlockWood;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLog
extends BlockWood {
    public BlockLog(boolean fireproof) {
        super("log", fireproof);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
    }

    public int func_149645_b() {
        return Blocks.field_150364_r.func_149645_b();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        int radius = 4;
        int boundary = radius + 1;
        if (world.func_72904_c(x - boundary, y - boundary, z - boundary, x + boundary, y + boundary, z + boundary)) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        Block neighbor = world.func_147439_a(x + i, y + j, z + k);
                        neighbor.beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        int b0 = 0;
        switch (side) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        return meta | b0;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            list.add(TreeManager.woodItemAccess.getLog(woodType, this.isFireproof()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return IconProviderWood.getLogIcon(EnumWoodType.LARCH, meta, side);
    }

    @Override
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        TileWood wood = TileWood.getWoodTile(world, x, y, z);
        if (wood == null) {
            return this.func_149691_a(side, meta);
        }
        EnumWoodType type = wood.getWoodType();
        if (type == null) {
            return this.func_149691_a(side, meta);
        }
        return IconProviderWood.getLogIcon(type, meta, side);
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.isFireproof()) {
            return 0;
        }
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

