/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.render.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSlab
extends net.minecraft.block.BlockSlab
implements IWoodTyped,
ITileEntityProvider {
    private final ParticleHelper.Callback particleCallback;
    private final boolean fireproof;
    private final ThreadLocal<ArrayList<ItemStack>> drops = new ThreadLocal();

    public BlockSlab(boolean doubleSlab, boolean fireproof) {
        super(doubleSlab, Material.field_151575_d);
        this.fireproof = fireproof;
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149713_g(0);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
        this.setHarvestLevel("axe", 0);
        this.particleCallback = new ParticleHelper.DefaultCallback((Block)this);
    }

    public boolean isDoubleSlab() {
        return this.field_150004_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        IconProviderWood.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return IconProviderWood.getPlankIcon(EnumWoodType.LARCH);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileWood wood = TileWood.getWoodTile(world, x, y, z);
        if (wood == null) {
            return this.func_149691_a(side, world.func_72805_g(x, y, z));
        }
        EnumWoodType woodType = wood.getWoodType();
        return IconProviderWood.getPlankIcon(woodType);
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)Blocks.field_150376_bx, 2, meta & 7);
    }

    public String func_150002_b(int var1) {
        return "SomeSlab";
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        if (!this.isDoubleSlab()) {
            for (EnumWoodType woodType : EnumWoodType.VALUES) {
                list.add(TreeManager.woodItemAccess.getSlab(woodType, this.fireproof));
            }
        }
    }

    public final TileEntity func_149915_a(World world, int meta) {
        return new TileWood();
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return TileWood.getPickBlock((Block)this, (IBlockAccess)world, x, y, z);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer playerProfile) {
        this.drops.set(TileWood.getDrops(this, world, x, y, z));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = this.drops.get();
        this.drops.remove();
        if (ret == null) {
            ret = TileWood.getDrops(this, world, x, y, z);
        }
        return ret;
    }

    public final float func_149712_f(World world, int x, int y, int z) {
        TileWood wood = TileWood.getWoodTile((IBlockAccess)world, x, y, z);
        if (wood == null) {
            return 2.0f;
        }
        return wood.getWoodType().getHardness();
    }

    public final boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return !this.isFireproof();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 5;
    }

    @Override
    public String getBlockKind() {
        return "slab";
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    public boolean func_149710_n() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, (Block)this, target, effectRenderer, this.particleCallback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, (Block)this, x, y, z, meta, effectRenderer, this.particleCallback);
    }
}

