/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.items.ItemForestryMultiPass;
import forestry.plugins.PluginCore;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemCircuitBoard
extends ItemForestryMultiPass {
    public ItemCircuitBoard() {
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]));
    }

    public boolean func_77651_p() {
        return true;
    }

    public int func_82790_a(ItemStack itemstack, int pass) {
        if (itemstack.func_77960_j() < 0 || itemstack.func_77960_j() >= EnumCircuitBoardType.values().length) {
            return super.func_82790_a(itemstack, pass);
        }
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[itemstack.func_77960_j()];
        if (pass == 0) {
            return type.getPrimaryColor();
        }
        return type.getSecondaryColor();
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() < 0 || stack.func_77960_j() >= EnumCircuitBoardType.values().length) {
            return "item.for.circuitboard.basic";
        }
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[stack.func_77960_j()];
        return "item.for.circuitboard." + type.toString().toLowerCase(Locale.ENGLISH);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ICircuitBoard circuitboard = ChipsetManager.circuitRegistry.getCircuitboard(itemstack);
        if (circuitboard != null) {
            circuitboard.addTooltip(list);
        }
    }

    public static ItemStack createCircuitboard(EnumCircuitBoardType type, ICircuitLayout layout, ICircuit[] circuits) {
        ItemStack chipset = PluginCore.items.circuitboards.get(type);
        ItemCircuitBoard.saveChipset(chipset, new CircuitBoard(type, layout, circuits));
        return chipset;
    }

    private static void saveChipset(ItemStack itemstack, ICircuitBoard circuitboard) {
        if (circuitboard == null) {
            itemstack.func_77982_d(null);
            return;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        circuitboard.writeToNBT(nbttagcompound);
        itemstack.func_77982_d(nbttagcompound);
    }

    public ItemStack get(EnumCircuitBoardType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }
}

