/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CropBlock
extends Crop {
    protected final Block block;
    protected final int meta;

    public CropBlock(World world, Block block, int meta, Vect position) {
        super(world, position);
        this.block = block;
        this.meta = meta;
    }

    @Override
    protected boolean isCrop(Vect pos) {
        return this.getBlock(pos) == this.block && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(Vect pos) {
        ArrayList harvested = this.block.getDrops(this.world, pos.x, pos.y, pos.z, this.meta, 0);
        Proxies.common.addBlockDestroyEffects(this.world, pos.x, pos.y, pos.z, this.block, 0);
        this.world.func_147468_f(pos.x, pos.y, pos.z);
        return harvested;
    }

    public String toString() {
        return String.format("CropBlock [ position: [ %s ]; block: %s; meta: %s ]", this.position.toString(), this.block.func_149739_a(), this.meta);
    }
}

