/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.common.registry.GameData;
import ic2.core.IC2;
import ic2.core.block.BlockMultiID;
import ic2.core.block.BlockWall;
import ic2.core.block.IObscurable;
import ic2.core.block.TileEntityBlock;
import ic2.core.network.ClientModifiable;
import java.util.ArrayList;
import java.util.List;
import ml.luxinfine.ic2.ShadowBlockAccess;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWall
extends TileEntityBlock
implements IObscurable {
    @ClientModifiable
    public Block[] retextureRef;
    @ClientModifiable
    public int[] retextureRefMeta;
    @ClientModifiable
    public int[] retextureRefSide;
    public final TileEntity[] retextureRefTile = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
    public final ShadowBlockAccess shadowAccess = new ShadowBlockAccess();

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("retextureRefMeta")) {
            this.retextureRef = new Block[6];
            boolean found = false;
            for (int i = 0; i < 6; ++i) {
                if (!nbttagcompound.func_74764_b("retextureRef" + i)) continue;
                this.retextureRef[i] = (Block)GameData.getBlockRegistry().getRaw(nbttagcompound.func_74779_i("retextureRef" + i));
                found = found || this.retextureRef[i] != null;
            }
            if (found) {
                this.retextureRefMeta = nbttagcompound.func_74759_k("retextureRefMeta");
                this.retextureRefSide = nbttagcompound.func_74759_k("retextureRefSide");
                if (this.retextureRefMeta.length != 6 || this.retextureRefSide.length != 6) {
                    this.clearRetexture();
                }
            } else {
                this.clearRetexture();
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.retextureRef != null) {
            for (int i = 0; i < this.retextureRef.length; ++i) {
                if (this.retextureRef[i] == null) continue;
                nbttagcompound.func_74778_a("retextureRef" + i, GameData.getBlockRegistry().func_148750_c((Object)this.retextureRef[i]));
            }
            nbttagcompound.func_74783_a("retextureRefMeta", this.retextureRefMeta);
            nbttagcompound.func_74783_a("retextureRefSide", this.retextureRefSide);
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("retextureRef");
        ret.add("retextureRefMeta");
        ret.add("retextureRefSide");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("retextureRef") || field.equals("retextureRefMeta") || field.equals("retextureRefSide")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public boolean retexture(int side, Block referencedBlock, int referencedMeta, int referencedSide) {
        boolean ret = false;
        boolean updateAll = false;
        if (this.retextureRef == null) {
            this.retextureRef = new Block[6];
            this.retextureRefMeta = new int[6];
            this.retextureRefSide = new int[6];
            updateAll = true;
        }
        if (this.retextureRef[side] != referencedBlock || updateAll) {
            this.retextureRef[side] = referencedBlock;
            IC2.network.get().updateTileEntityField(this, "retextureRef");
            ret = true;
        }
        if (this.retextureRefMeta[side] != referencedMeta || updateAll) {
            this.retextureRefMeta[side] = referencedMeta;
            IC2.network.get().updateTileEntityField(this, "retextureRefMeta");
            ret = true;
        }
        if (this.retextureRefSide[side] != referencedSide || updateAll) {
            this.retextureRefSide[side] = referencedSide;
            IC2.network.get().updateTileEntityField(this, "retextureRefSide");
            ret = true;
        }
        return ret;
    }

    @Override
    public Block getReferencedBlock(int side) {
        return this.retextureRef != null ? this.retextureRef[side] : null;
    }

    @Override
    public int getReferencedMeta(int side) {
        return this.retextureRefMeta != null ? this.retextureRefMeta[side] : 0;
    }

    @Override
    public void setColorMultiplier(int colorMultiplier) {
        ((BlockWall)this.func_145838_q()).colorMultiplier = colorMultiplier;
    }

    @Override
    public void setRenderMask(int mask) {
        ((BlockMultiID)this.func_145838_q()).renderMask = mask;
    }

    private void clearRetexture() {
        this.retextureRef = null;
        this.retextureRefMeta = null;
        this.retextureRefSide = null;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        if (nbt != null) {
            for (int i = 0; i < this.retextureRefTile.length; ++i) {
                this.retextureRefTile[i] = TileEntity.func_145827_c((NBTTagCompound)nbt.func_74775_l("retextureTile" + i));
                if (this.retextureRefTile[i] == null) {
                    int meta;
                    int n = meta = this.retextureRefMeta != null && this.retextureRefMeta.length > i ? this.retextureRefMeta[i] : 0;
                    if (this.retextureRef != null && this.retextureRef.length > i && this.retextureRef[i] != null && this.retextureRef[i].hasTileEntity(meta)) {
                        this.retextureRefTile[i] = this.retextureRef[i].createTileEntity(this.field_145850_b, meta);
                    }
                }
                if (this.retextureRefTile[i] == null) continue;
                this.retextureRefTile[i].func_145834_a(null);
                this.retextureRefTile[i].field_145851_c = this.field_145851_c;
                this.retextureRefTile[i].field_145848_d = this.field_145848_d;
                this.retextureRefTile[i].field_145849_e = this.field_145849_e;
            }
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public IIcon getIcon(int side) {
        side = MathHelper.func_76125_a((int)side, (int)0, (int)(ForgeDirection.VALID_DIRECTIONS.length - 1));
        IIcon icon = null;
        Block referencedBlock = this.getReferencedBlock(side);
        if (referencedBlock != null) {
            if (Minecraft.func_71410_x().func_71356_B()) {
                try {
                    icon = referencedBlock.func_149691_a(this.retextureRefSide[side], this.retextureRefMeta[side]);
                }
                catch (Exception exception) {}
            } else {
                this.shadowAccess.bindRealWorld(this.field_145850_b);
                this.shadowAccess.setTarget(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                try {
                    this.shadowAccess.setMask(referencedBlock, this.retextureRefMeta[side], this.retextureRefTile[side]);
                    icon = referencedBlock.func_149673_e((IBlockAccess)this.shadowAccess, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.retextureRefSide[side]);
                }
                catch (Exception ignored) {
                    icon = referencedBlock.func_149691_a(this.retextureRefSide[side], this.retextureRefMeta[side]);
                }
            }
        }
        return icon;
    }
}

