/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.ic2;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class ShadowBlockAccess
implements IBlockAccess {
    private int overrideX;
    private int overrideY;
    private int overrideZ;
    private World originalWorld;
    private Block maskBlock;
    private TileEntity maskTile;
    private int maskBlockMeta;

    public void setTarget(int x, int y, int z) {
        this.overrideX = x;
        this.overrideY = y;
        this.overrideZ = z;
    }

    public void bindRealWorld(World world) {
        this.originalWorld = world;
    }

    public void setMask(Block block, int meta, TileEntity tile) {
        this.maskBlock = block;
        this.maskBlockMeta = meta;
        this.maskTile = tile;
    }

    public boolean hasMask() {
        return this.maskBlock != null;
    }

    public Block func_147439_a(int x, int y, int z) {
        return x == this.overrideX && y == this.overrideY && z == this.overrideZ ? this.maskBlock : this.originalWorld.func_147439_a(x, y, z);
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        return x == this.overrideX && y == this.overrideY && z == this.overrideZ ? this.maskTile : this.originalWorld.func_147438_o(x, y, z);
    }

    public int func_72802_i(int x, int y, int z, int p_72802_4_) {
        int i1 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, x, y, z);
        int j1 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Block, x, y, z);
        if (j1 < p_72802_4_) {
            j1 = p_72802_4_;
        }
        return i1 << 20 | j1 << 4;
    }

    public int func_72805_g(int x, int y, int z) {
        return x == this.overrideX && y == this.overrideY && z == this.overrideZ ? this.maskBlockMeta : this.originalWorld.func_72805_g(x, y, z);
    }

    public int func_72879_k(int x, int y, int z, int dir) {
        return this.func_147439_a(x, y, z).func_149748_c((IBlockAccess)this, x, y, z, dir);
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z).isAir((IBlockAccess)this, x, y, z);
    }

    public BiomeGenBase func_72807_a(int x, int z) {
        return this.originalWorld.func_72807_a(x, z);
    }

    public int func_72800_K() {
        return this.originalWorld.func_72800_K();
    }

    public boolean func_72806_N() {
        return this.originalWorld.func_72806_N();
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return _default;
        }
        Chunk chunk = this.originalWorld.func_72863_F().func_73154_d(x >> 4, z >> 4);
        if (chunk == null || chunk.func_76621_g()) {
            return _default;
        }
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    private int getSkyBlockTypeBrightness(EnumSkyBlock type, int x, int y, int z) {
        if (this.originalWorld.field_73011_w.field_76576_e && type == EnumSkyBlock.Sky) {
            return 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= 256) {
            return type.field_77198_c;
        }
        if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000) {
            int l = x >> 4;
            int i1 = z >> 4;
            if (!this.originalWorld.func_72863_F().func_73149_a(l, i1)) {
                return type.field_77198_c;
            }
            if (this.func_147439_a(x, y, z).func_149710_n()) {
                int j2 = this.originalWorld.func_72972_b(type, x, y + 1, z);
                int j1 = this.originalWorld.func_72972_b(type, x + 1, y, z);
                int k1 = this.originalWorld.func_72972_b(type, x - 1, y, z);
                int l1 = this.originalWorld.func_72972_b(type, x, y, z + 1);
                int i2 = this.originalWorld.func_72972_b(type, x, y, z - 1);
                if (j1 > j2) {
                    j2 = j1;
                }
                if (k1 > j2) {
                    j2 = k1;
                }
                if (l1 > j2) {
                    j2 = l1;
                }
                if (i2 > j2) {
                    j2 = i2;
                }
                return j2;
            }
            Chunk chunk = this.originalWorld.func_72964_e(l, i1);
            return chunk.func_76614_a(type, x & 0xF, y, z & 0xF);
        }
        return type.field_77198_c;
    }
}

