/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CommonOps;

public class QRDecompositionHouseholder_D64
implements QRDecomposition<DenseMatrix64F> {
    protected DenseMatrix64F QR;
    protected double[] u;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] dataQR;
    protected double[] gammas;
    protected double gamma;
    protected double tau;
    protected boolean error;

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.error = false;
        this.numCols = numCols;
        this.numRows = numRows;
        this.minLength = Math.min(numRows, numCols);
        int maxLength = Math.max(numRows, numCols);
        if (this.QR == null) {
            this.QR = new DenseMatrix64F(numRows, numCols);
            this.u = new double[maxLength];
            this.v = new double[maxLength];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(numRows, numCols, false);
        }
        this.dataQR = this.QR.data;
        if (this.u.length < maxLength) {
            this.u = new double[maxLength];
            this.v = new double[maxLength];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public DenseMatrix64F getQR() {
        return this.QR;
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F Q, boolean compact) {
        if (compact) {
            if (Q == null) {
                Q = CommonOps.identity(this.numRows, this.minLength);
            } else {
                if (Q.numRows != this.numRows || Q.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CommonOps.setIdentity(Q);
            }
        } else if (Q == null) {
            Q = CommonOps.identity(this.numRows);
        } else {
            if (Q.numRows != this.numRows || Q.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CommonOps.setIdentity(Q);
        }
        for (int j = this.minLength - 1; j >= 0; --j) {
            this.u[j] = 1.0;
            for (int i = j + 1; i < this.numRows; ++i) {
                this.u[i] = this.QR.get(i, j);
            }
            QrHelperFunctions.rank1UpdateMultR(Q, this.u, this.gammas[j], j, j, this.numRows, this.v);
        }
        return Q;
    }

    @Override
    public DenseMatrix64F getR(DenseMatrix64F R, boolean compact) {
        int i;
        if (R == null) {
            R = compact ? new DenseMatrix64F(this.minLength, this.numCols) : new DenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (compact ? R.numCols != this.numCols || R.numRows != this.minLength : R.numCols != this.numCols || R.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (i = 0; i < R.numRows; ++i) {
                int min = Math.min(i, R.numCols);
                for (int j = 0; j < min; ++j) {
                    R.set(i, j, 0.0);
                }
            }
        }
        for (i = 0; i < this.minLength; ++i) {
            for (int k = i; k < this.numCols; ++k) {
                double val = this.QR.get(i, k);
                R.set(i, k, val);
            }
        }
        return R;
    }

    @Override
    public boolean decompose(DenseMatrix64F A) {
        this.commonSetup(A);
        for (int j = 0; j < this.minLength; ++j) {
            this.householder(j);
            this.updateA(j);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void householder(int j) {
        int i;
        int index = j + j * this.numCols;
        double max = 0.0;
        for (i = j; i < this.numRows; ++i) {
            double n2;
            double[] u = this.u;
            int n = i;
            u[n] = n2 = this.dataQR[index];
            double d = n2;
            if (d < 0.0) {
                d = -d;
            }
            if (max < d) {
                max = d;
            }
            index += this.numCols;
        }
        if (max == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.tau = 0.0;
            for (i = j; i < this.numRows; ++i) {
                int n3;
                double[] u2 = this.u;
                int n = n3 = i;
                u2[n] = u2[n] / max;
                double d = this.u[i];
                this.tau += d * d;
            }
            this.tau = Math.sqrt(this.tau);
            if (this.u[j] < 0.0) {
                this.tau = -this.tau;
            }
            double u_0 = this.u[j] + this.tau;
            this.gamma = u_0 / this.tau;
            int k = j + 1;
            while (k < this.numRows) {
                int n4;
                double[] u3 = this.u;
                int n = n4 = k++;
                u3[n] = u3[n] / u_0;
            }
            this.u[j] = 1.0;
            this.tau *= max;
        }
        this.gammas[j] = this.gamma;
    }

    protected void updateA(int w) {
        int i;
        for (i = w + 1; i < this.numCols; ++i) {
            this.v[i] = this.u[w] * this.dataQR[w * this.numCols + i];
        }
        for (int k = w + 1; k < this.numRows; ++k) {
            int indexQR = k * this.numCols + w + 1;
            int j = w + 1;
            while (j < this.numCols) {
                int n;
                double[] v = this.v;
                int n2 = n = j++;
                v[n2] = v[n2] + this.u[k] * this.dataQR[indexQR++];
            }
        }
        i = w + 1;
        while (i < this.numCols) {
            int n2;
            double[] v2 = this.v;
            int n = n2 = i++;
            v2[n] = v2[n] * this.gamma;
        }
        for (i = w; i < this.numRows; ++i) {
            double valU = this.u[i];
            int indexQR2 = i * this.numCols + w + 1;
            for (int l = w + 1; l < this.numCols; ++l) {
                int n3;
                double[] dataQR = this.dataQR;
                int n = n3 = indexQR2++;
                dataQR[n] = dataQR[n] - valU * this.v[l];
            }
        }
        if (w < this.numCols) {
            this.dataQR[w + w * this.numCols] = -this.tau;
        }
        for (i = w + 1; i < this.numRows; ++i) {
            this.dataQR[w + i * this.numCols] = this.u[i];
        }
    }

    protected void commonSetup(DenseMatrix64F A) {
        this.setExpectedMaxSize(A.numRows, A.numCols);
        this.QR.set(A);
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

