/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.alg.dense.linsol.lu.LinearSolverLuBase;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.SpecializedOps;

public class LinearSolverLuKJI
extends LinearSolverLuBase {
    private double[] dataLU;
    private int[] pivot;

    public LinearSolverLuKJI(LUDecompositionBase_D64 decomp) {
        super(decomp);
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        boolean ret = super.setA(A);
        this.pivot = this.decomp.getPivot();
        this.dataLU = this.decomp.getLU().data;
        return ret;
    }

    @Override
    public void solve(DenseMatrix64F b, DenseMatrix64F x) {
        if (b.numCols != x.numCols || b.numRows != this.numRows || x.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        if (b != x) {
            int i;
            int k;
            SpecializedOps.copyChangeRow(this.pivot, b, x);
            int nx = b.numCols;
            double[] dataX = x.data;
            for (k = 0; k < this.numCols; ++k) {
                for (i = k + 1; i < this.numCols; ++i) {
                    for (int j = 0; j < nx; ++j) {
                        int n;
                        double[] array = dataX;
                        int n2 = n = i * nx + j;
                        array[n2] = array[n2] - dataX[k * nx + j] * this.dataLU[i * this.numCols + k];
                    }
                }
            }
            for (k = this.numCols - 1; k >= 0; --k) {
                for (int l = 0; l < nx; ++l) {
                    int n2;
                    double[] array2 = dataX;
                    int n = n2 = k * nx + l;
                    array2[n] = array2[n] / this.dataLU[k * this.numCols + k];
                }
                for (i = 0; i < k; ++i) {
                    for (int j = 0; j < nx; ++j) {
                        int n3;
                        double[] array3 = dataX;
                        int n = n3 = i * nx + j;
                        array3[n] = array3[n] - dataX[k * nx + j] * this.dataLU[i * this.numCols + k];
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException("Current doesn't support using the same matrix instance");
    }
}

