/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.linsol.ReducedRowEchelonForm;

public class RrefGaussJordanRowPivot
implements ReducedRowEchelonForm<DenseMatrix64F> {
    double tol;

    @Override
    public void setTolerance(double tol) {
        this.tol = tol;
    }

    @Override
    public void reduce(DenseMatrix64F A, int coefficientColumns) {
        if (A.numCols < coefficientColumns) {
            throw new IllegalArgumentException("The system must be at least as wide as A");
        }
        int leadIndex = 0;
        for (int i = 0; i < coefficientColumns; ++i) {
            int row;
            int pivotRow = -1;
            double maxValue = this.tol;
            for (row = leadIndex; row < A.numRows; ++row) {
                double v = Math.abs(A.data[row * A.numCols + i]);
                if (!(v > maxValue)) continue;
                maxValue = v;
                pivotRow = row;
            }
            if (pivotRow == -1) continue;
            if (leadIndex != pivotRow) {
                RrefGaussJordanRowPivot.swapRows(A, leadIndex, pivotRow);
            }
            for (row = 0; row < A.numRows; ++row) {
                if (row == leadIndex) continue;
                int indexPivot = leadIndex * A.numCols + i;
                int indexTarget = row * A.numCols + i;
                double alpha = A.data[indexTarget] / A.data[indexPivot++];
                A.data[indexTarget++] = 0.0;
                for (int col = i + 1; col < A.numCols; ++col) {
                    int n;
                    double[] data = A.data;
                    int n2 = n = indexTarget++;
                    data[n2] = data[n2] - A.data[indexPivot++] * alpha;
                }
            }
            int indexPivot2 = leadIndex * A.numCols + i;
            double alpha2 = 1.0 / A.data[indexPivot2];
            A.data[indexPivot2++] = 1.0;
            for (int col2 = i + 1; col2 < A.numCols; ++col2) {
                int n2;
                double[] data2 = A.data;
                int n = n2 = indexPivot2++;
                data2[n] = data2[n] * alpha2;
            }
            ++leadIndex;
        }
    }

    protected static void swapRows(DenseMatrix64F A, int rowA, int rowB) {
        int indexA = rowA * A.numCols;
        int indexB = rowB * A.numCols;
        int i = 0;
        while (i < A.numCols) {
            double temp = A.data[indexA];
            A.data[indexA] = A.data[indexB];
            A.data[indexB] = temp;
            ++i;
            ++indexA;
            ++indexB;
        }
    }
}

