/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.Common.Blocks;

import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModBlocks;
import DelirusCrux.Netherlicious.Utility.ModSounds;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class SoulFarmland
extends BlockFarmland {
    @SideOnly(value=Side.CLIENT)
    private IIcon wetIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon dryIcon;

    public SoulFarmland() {
        this.func_149711_c(0.5f);
        this.func_149713_g(0);
        this.func_149672_a(ModSounds.soundSoulSoil);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!this.isWaterNearby(world, x, y, z) && !world.func_72951_B(x, y + 1, z)) {
            int meta = world.func_72805_g(x, y, z);
            if (meta > 0) {
                world.func_72921_c(x, y, z, --meta, 2);
            } else if (!this.isCropsNearby(world, x, y, z)) {
                world.func_147465_d(x, y, z, ModBlocks.SoulSoil, 0, 2);
            }
        } else {
            world.func_72921_c(x, y, z, 7, 2);
        }
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) > 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        super.func_149695_a(world, x, y, z, neighbour);
        Material material = world.func_147439_a(x, y + 1, z).func_149688_o();
        if (material.func_76220_a()) {
            world.func_147465_d(x, y, z, ModBlocks.SoulSoil, 0, 2);
        }
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return ModBlocks.SoulSoil.func_149650_a(0, rand, fortune);
    }

    public void func_149746_a(World p_149746_1_, int p_149746_2_, int p_149746_3_, int p_149746_4_, Entity p_149746_5_, float p_149746_6_) {
        if (!p_149746_1_.field_72995_K && p_149746_1_.field_73012_v.nextFloat() < p_149746_6_ - 0.5f) {
            if (!(p_149746_5_ instanceof EntityPlayer) && !p_149746_1_.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            p_149746_1_.func_147465_d(p_149746_2_, p_149746_3_, p_149746_4_, ModBlocks.SoulSoil, 0, 2);
        }
    }

    private boolean isWaterNearby(World world, int x, int y, int z) {
        for (int i = x - 4; i <= x + 4; ++i) {
            for (int j = y; j <= y + 1; ++j) {
                for (int k = z - 4; k <= z + 4; ++k) {
                    if (world.func_147439_a(i, j, k).func_149688_o() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isCropsNearby(World world, int x, int y, int z) {
        for (int i = x; i <= x; ++i) {
            for (int j = z; j <= z; ++j) {
                Block plant = world.func_147439_a(i, y + 1, j);
                if (!(plant instanceof IPlantable) || !this.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)plant)) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)ModBlocks.SoulSoil);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.wetIcon = reg.func_94245_a("netherlicious:soul_farmland_wet");
        this.dryIcon = reg.func_94245_a("netherlicious:soul_farmland_dry");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? (meta > 0 ? this.wetIcon : this.dryIcon) : ModBlocks.SoulSoil.func_149733_h(side);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack(ModBlocks.SoulSoil, 1, 0);
    }
}

