/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.Common.Items.Armor;

import DelirusCrux.Netherlicious.Common.BlockItemUtility.FireproofItemEntity;
import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModCreativeTab;
import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModItems;
import DelirusCrux.Netherlicious.Utility.Configuration.ArmorToolConfiguration;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class HeavyBlazeArmor
extends ItemArmor {
    AttributeModifier knockBack;
    AttributeModifier moveSpeed;

    public HeavyBlazeArmor(ItemArmor.ArmorMaterial armorMaterial, int renderIndex, int armorType) {
        super(armorMaterial, renderIndex, armorType);
        this.func_77637_a(ModCreativeTab.tabNetherliciousArmorTools);
        this.knockBack = new AttributeModifier("Knockback modification", 0.1, 1);
        this.moveSpeed = new AttributeModifier("Movespeed modification", -0.05, 1);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean who) {
        tooltip.add(EnumChatFormatting.DARK_PURPLE + "" + StatCollector.func_74838_a((String)"tooltip.heavyblazearmor.desc"));
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)this.knockBack);
        if (ArmorToolConfiguration.HBlazeNegativeEffects) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)this.moveSpeed);
        }
        return multimap;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this.field_77881_a == 2) {
            return "netherlicious:textures/models/armor/heavy_blaze_layer_2.png";
        }
        return "netherlicious:textures/models/armor/heavy_blaze_layer_1.png";
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack itemToRepairWith) {
        return itemToRepairWith.func_77973_b() == ModItems.Materials && itemToRepairWith.func_77960_j() == 0;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        boolean hasHeavyBlazeHelmet = false;
        boolean hasHeavyBlazeChest = false;
        boolean hasHeavyBlazeLegs = false;
        boolean hasHeavyBlazeBoots = false;
        ItemStack helmet = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack legs = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        if (helmet != null) {
            boolean bl = hasHeavyBlazeHelmet = helmet.func_77973_b() == ModItems.HeavyBlazeHelmet;
        }
        if (chest != null) {
            boolean bl = hasHeavyBlazeChest = chest.func_77973_b() == ModItems.HeavyBlazeChestPlate;
        }
        if (legs != null) {
            boolean bl = hasHeavyBlazeLegs = legs.func_77973_b() == ModItems.HeavyBlazeLeggings;
        }
        if (boots != null) {
            boolean bl = hasHeavyBlazeBoots = boots.func_77973_b() == ModItems.HeavyBlazeBoots;
        }
        if (hasHeavyBlazeHelmet && hasHeavyBlazeChest && hasHeavyBlazeLegs && hasHeavyBlazeBoots) {
            player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 100));
            if (ArmorToolConfiguration.HBlazeNegativeEffects) {
                player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 100, ArmorToolConfiguration.HBlazeArmorNegativeEffectLevel));
            }
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new FireproofItemEntity(world, location, itemstack);
    }
}

