/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.util.Iterator;
import java.util.List;
import mods.railcraft.common.util.crafting.BlastFurnaceCraftingManager;
import net.minecraft.item.ItemStack;
import wanion.unidict.UniDict;
import wanion.unidict.common.FixedSizeList;
import wanion.unidict.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class RailcraftIntegration
extends AbstractIntegrationThread {
    private final List<BlastFurnaceCraftingManager.BlastFurnaceRecipe> blastFurnaceRecipes = (List)Util.getField(BlastFurnaceCraftingManager.class, "recipes", BlastFurnaceCraftingManager.getInstance(), List.class);

    RailcraftIntegration() {
        super("Railcraft");
    }

    @Override
    public String call() {
        try {
            this.fixBlastFurnaceRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "The things that are made in the explosion chamber had to change.";
    }

    private void fixBlastFurnaceRecipes() {
        if (this.blastFurnaceRecipes == null) {
            return;
        }
        FixedSizeList<BlastFurnaceCraftingManager.BlastFurnaceRecipe> newRecipes = new FixedSizeList<BlastFurnaceCraftingManager.BlastFurnaceRecipe>(this.blastFurnaceRecipes.size());
        Iterator<BlastFurnaceCraftingManager.BlastFurnaceRecipe> blastFurnaceRecipeIterator = this.blastFurnaceRecipes.iterator();
        while (blastFurnaceRecipeIterator.hasNext()) {
            BlastFurnaceCraftingManager.BlastFurnaceRecipe recipe = blastFurnaceRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipe.getOutput());
            if (correctOutput == recipe.getOutput()) continue;
            newRecipes.add(new BlastFurnaceCraftingManager.BlastFurnaceRecipe(recipe.getInput(), recipe.matchDamage(), recipe.matchNBT(), recipe.getCookTime(), correctOutput));
            blastFurnaceRecipeIterator.remove();
        }
        this.blastFurnaceRecipes.addAll(newRecipes);
    }
}

