/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mapwriter.CircularHashMap;
import mapwriter.Mw;
import mapwriter.region.MwChunk;
import mapwriter.tasks.SaveChunkTask;
import mapwriter.tasks.UpdateSurfaceChunksTask;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkManager {
    public Mw mw;
    private boolean closed = false;
    private CircularHashMap<Chunk, Integer> chunkMap = new CircularHashMap();
    private static final int VISIBLE_FLAG = 1;
    private static final int VIEWED_FLAG = 2;

    public ChunkManager(Mw mw) {
        this.mw = mw;
    }

    public synchronized void close() {
        this.closed = true;
        this.saveChunks();
        this.chunkMap.clear();
    }

    public static MwChunk copyToMwChunk(Chunk chunk) {
        byte[][] msbArray = new byte[16][];
        byte[][] lsbArray = new byte[16][];
        byte[][] metaArray = new byte[16][];
        byte[][] lightingArray = new byte[16][];
        HashMap TileEntityMap = new HashMap();
        TileEntityMap.putAll(chunk.field_150816_i);
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        if (storageArrays != null) {
            for (ExtendedBlockStorage storage : storageArrays) {
                if (storage == null) continue;
                int y = storage.func_76662_d() >> 4 & 0xF;
                lsbArray[y] = Arrays.copyOf(storage.func_76658_g(), storage.func_76658_g().length);
                msbArray[y] = storage.func_76660_i() != null ? Arrays.copyOf(storage.func_76660_i().field_76585_a, storage.func_76660_i().field_76585_a.length) : null;
                metaArray[y] = storage.func_76669_j() != null ? Arrays.copyOf(storage.func_76669_j().field_76585_a, storage.func_76669_j().field_76585_a.length) : null;
                lightingArray[y] = storage.func_76661_k() != null ? Arrays.copyOf(storage.func_76661_k().field_76585_a, storage.func_76661_k().field_76585_a.length) : null;
            }
        }
        return new MwChunk(chunk.field_76635_g, chunk.field_76647_h, chunk.field_76637_e.field_73011_w.field_76574_g, msbArray, lsbArray, metaArray, lightingArray, Arrays.copyOf(chunk.func_76605_m(), chunk.func_76605_m().length), TileEntityMap);
    }

    public synchronized void addChunk(Chunk chunk) {
        if (!this.closed && chunk != null && !this.chunkMap.containsKey(chunk)) {
            this.chunkMap.put(chunk, 0);
        }
    }

    public synchronized void removeChunk(Chunk chunk) {
        if (!this.closed && chunk != null) {
            if (!this.chunkMap.containsKey(chunk)) {
                return;
            }
            int flags = this.chunkMap.get(chunk);
            if ((flags & 2) != 0) {
                this.addSaveChunkTask(chunk);
            }
            this.chunkMap.remove(chunk);
        }
    }

    public synchronized void saveChunks() {
        for (Map.Entry<Chunk, Integer> entry : this.chunkMap.entrySet()) {
            int flags = entry.getValue();
            if ((flags & 2) == 0) continue;
            this.addSaveChunkTask(entry.getKey());
        }
    }

    public void updateUndergroundChunks() {
        int chunkArrayX = (this.mw.playerXInt >> 4) - 1;
        int chunkArrayZ = (this.mw.playerZInt >> 4) - 1;
        MwChunk[] chunkArray = new MwChunk[9];
        for (int z = 0; z < 3; ++z) {
            for (int x = 0; x < 3; ++x) {
                Chunk chunk = this.mw.mc.field_71441_e.func_72964_e(chunkArrayX + x, chunkArrayZ + z);
                if (chunk.func_76621_g()) continue;
                chunkArray[z * 3 + x] = ChunkManager.copyToMwChunk(chunk);
            }
        }
    }

    public void updateSurfaceChunks() {
        int chunkArrayX = (this.mw.playerXInt >> 4) - (this.mw.renderRadius - 1);
        int chunkArrayZ = (this.mw.playerZInt >> 4) - (this.mw.renderRadius - 1);
        for (int z = 0; z < 2 * this.mw.renderRadius - 1; ++z) {
            for (int x = 0; x < 2 * this.mw.renderRadius - 1; ++x) {
                Chunk chunk = this.mw.mc.field_71441_e.func_72964_e(chunkArrayX + x, chunkArrayZ + z);
                if (chunk.func_76621_g()) continue;
                this.addChunk(chunk);
            }
        }
        MwChunk[] chunkArray = new MwChunk[this.chunkMap.size()];
        for (int i = 0; i < this.chunkMap.size(); ++i) {
            Map.Entry<Chunk, Integer> entry = this.chunkMap.getNextEntry();
            Chunk chunk = entry.getKey();
            chunkArray[i] = ChunkManager.copyToMwChunk(chunk);
        }
        this.mw.executor.addTask(new UpdateSurfaceChunksTask(this.mw, chunkArray));
        this.chunkMap.clear();
    }

    public void onTick() {
        if (!this.closed) {
            if ((this.mw.tickCounter & 0xF) == 0) {
                this.updateUndergroundChunks();
            } else if (this.mw.ticksBetweenUpdates == 0 || this.mw.tickCounter % this.mw.ticksBetweenUpdates == 0) {
                this.updateSurfaceChunks();
            }
        }
    }

    public void forceChunks(MwChunk[] chunkArray) {
        this.mw.executor.addTask(new UpdateSurfaceChunksTask(this.mw, chunkArray));
    }

    private void addSaveChunkTask(Chunk chunk) {
        if ((this.mw.multiplayer && this.mw.regionFileOutputEnabledMP || !this.mw.multiplayer && this.mw.regionFileOutputEnabledSP) && !chunk.func_76621_g()) {
            this.mw.executor.addTask(new SaveChunkTask(ChunkManager.copyToMwChunk(chunk), this.mw.regionManager));
        }
    }
}

