/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import mapwriter.forge.MwForge;
import mapwriter.map.Marker;
import mapwriter.map.MarkerManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.chunk.Chunk;

public class MwUtil {
    public static final Pattern patternInvalidChars = Pattern.compile("[^\\p{IsAlphabetic}\\p{Digit}_]");

    public static void logInfo(String s, Object ... args) {
        MwForge.logger.info(String.format(s, args));
    }

    public static void logWarning(String s, Object ... args) {
        MwForge.logger.warn(String.format(s, args));
    }

    public static void logError(String s, Object ... args) {
        MwForge.logger.error(String.format(s, args));
    }

    public static void debug(String s, Object ... args) {
        MwForge.logger.debug(String.format(s, args));
    }

    public static void log(String s, Object ... args) {
        MwUtil.logInfo(String.format(s, args), new Object[0]);
    }

    public static String mungeString(String s) {
        s = s.replace('.', '_');
        s = s.replace('-', '_');
        s = s.replace(' ', '_');
        s = s.replace('/', '_');
        s = s.replace('\\', '_');
        return patternInvalidChars.matcher(s).replaceAll("");
    }

    public static File getFreeFilename(File dir, String baseName, String ext) {
        int i;
        File outputFile = dir != null ? new File(dir, baseName + "." + ext) : new File(baseName + "." + ext);
        for (i = 0; outputFile.exists() && i < 1000; ++i) {
            outputFile = dir != null ? new File(dir, baseName + "." + i + "." + ext) : new File(baseName + "." + i + "." + ext);
        }
        return i < 1000 ? outputFile : null;
    }

    public static void printBoth(String msg) {
        EntityClientPlayerMP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer != null) {
            thePlayer.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
        MwUtil.log("%s", msg);
    }

    public static File getDimensionDir(File worldDir, int dimension) {
        File dimDir = dimension != 0 ? new File(worldDir, "DIM" + dimension) : worldDir;
        return dimDir;
    }

    public static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static int nextHighestPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return v + 1;
    }

    public static String getCurrentDateString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
        return dateFormat.format(new Date());
    }

    public static int distToChunkSq(int x, int z, Chunk chunk) {
        int dx = (chunk.field_76635_g << 4) + 8 - x;
        int dz = (chunk.field_76647_h << 4) + 8 - z;
        return dx * dx + dz * dz;
    }

    public static List getTargetInfo(int sourceX, int sourceZ, int targetX, int targetZ) {
        ArrayList<Object> targetInfo = new ArrayList<Object>();
        double diffX = sourceX - targetX;
        double diffZ = sourceZ - targetZ;
        int angle = (int)Math.toDegrees(Math.atan2(diffX, diffZ));
        int n = angle = angle < 0 ? angle + 360 : angle;
        String compassPoint = angle <= 10 || angle > 350 ? "N" : (angle <= 80 && angle > 10 ? "NW" : (angle <= 100 && angle > 80 ? "W" : (angle <= 170 && angle > 100 ? "SW" : (angle <= 190 && angle > 170 ? "S" : (angle <= 260 && angle > 190 ? "SE" : (angle <= 280 && angle > 260 ? "E" : "NE"))))));
        targetInfo.add(compassPoint);
        targetInfo.add((int)Math.sqrt(Math.abs(diffX) * Math.abs(diffX) + Math.abs(diffZ) * Math.abs(diffZ)));
        return targetInfo;
    }

    public static File getJMWaypointsFolder() {
        String minecraftRootFolders = null;
        try {
            minecraftRootFolders = Minecraft.func_71410_x().field_71412_D.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String jmDataFolder = minecraftRootFolders + "\\journeymap\\data\\";
        jmDataFolder = Minecraft.func_71410_x().func_71387_A() ? jmDataFolder + "sp\\" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "\\waypoints" : jmDataFolder + "mp\\" + Minecraft.func_71410_x().func_147104_D().field_78847_a + "\\waypoints";
        File jmWaypointsFolder = new File(jmDataFolder);
        return jmWaypointsFolder;
    }

    public static String getGameMode() {
        if (Minecraft.func_71410_x().func_71387_A()) {
            return "sp";
        }
        return "mp";
    }

    public static String getCurrentMcWorldName() {
        if (Minecraft.func_71410_x().func_71387_A()) {
            return Minecraft.func_71410_x().func_71401_C().func_71270_I();
        }
        return Minecraft.func_71410_x().func_147104_D().field_78847_a;
    }

    public static void importMarkersFromJourneymap(MarkerManager markerManager, File jmWaypountsFolder) {
        JsonParser parser = new JsonParser();
        HashMap<String, String> uniqueMarker = new HashMap<String, String>();
        for (Marker marker : markerManager.markerList) {
            String hashString = marker.name + String.valueOf(marker.x) + String.valueOf(marker.y) + String.valueOf(marker.z) + String.valueOf(marker.dimension);
            if (uniqueMarker.containsKey(hashString)) continue;
            uniqueMarker.put(hashString, "");
        }
        if (jmWaypountsFolder.isDirectory()) {
            block3: for (File fileEntry : jmWaypountsFolder.listFiles()) {
                if (!fileEntry.isDirectory() && fileEntry.getPath().contains(".json") && fileEntry.length() > 0L) {
                    int counter = 0;
                    JsonElement jmJsonMarkerObject = null;
                    try {
                        jmJsonMarkerObject = parser.parse((Reader)new FileReader(fileEntry));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (jmJsonMarkerObject.equals(null)) continue;
                    JsonObject jmMarkerData = (JsonObject)jmJsonMarkerObject;
                    JsonArray markerDimensions = jmMarkerData.getAsJsonArray("dimensions");
                    int markerColour = -16711936;
                    if (markerDimensions.size() > 0) {
                        for (int i = 0; i < markerDimensions.size(); ++i) {
                            String markerName;
                            int dimension = markerDimensions.get(i).getAsInt();
                            String markerGroup = "importJM";
                            if (jmMarkerData.get("x") == null) {
                                MwUtil.logInfo("%s is not contains information about X coordinates", fileEntry.getName());
                                continue block3;
                            }
                            int markerX = jmMarkerData.get("x").getAsInt();
                            if (jmMarkerData.get("y") == null) {
                                MwUtil.logInfo("%s is not contains information about Y coordinates", fileEntry.getName());
                                continue block3;
                            }
                            int markerY = jmMarkerData.get("y").getAsInt();
                            if (jmMarkerData.get("z") == null) {
                                MwUtil.logInfo("%s is not contains information about Z coordinates", fileEntry.getName());
                                continue block3;
                            }
                            int markerZ = jmMarkerData.get("z").getAsInt();
                            if (jmMarkerData.get("name") != null && jmMarkerData.get("name").getAsString().length() > 0) {
                                markerName = jmMarkerData.get("name").getAsString();
                            } else {
                                MwUtil.logInfo("%s is not contains information about name. Name will be assign from coordinates", fileEntry.getName());
                                markerName = String.valueOf(markerX) + ";" + String.valueOf(markerY) + ";" + String.valueOf(markerZ);
                            }
                            String hashString = markerName + String.valueOf(markerX) + String.valueOf(markerY) + String.valueOf(markerZ) + String.valueOf(dimension);
                            if (uniqueMarker.containsKey(hashString)) continue;
                            markerManager.addMarker(markerName, markerGroup, markerX, markerY, markerZ, dimension, markerColour);
                            ++counter;
                        }
                        continue;
                    }
                    MwUtil.logInfo("%s is not contains information about dimension", fileEntry.getName());
                    continue;
                }
                MwUtil.logInfo("%s is not JourneyMap`s waypoints file", fileEntry.getName());
            }
        }
        markerManager.update();
        markerManager.saveMarkersToFile();
    }

    public static File chooseDirectory(String startFolderPath) {
        File selectedFile = null;
        JFrame frame = new JFrame("Select");
        File skinFile = new File(startFolderPath);
        JFileChooser chooser = new JFileChooser(startFolderPath);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        int result = chooser.showOpenDialog(frame);
        selectedFile = result == 0 ? chooser.getSelectedFile() : new File(startFolderPath);
        return selectedFile;
    }

    public static class JmWorldList {
        private String worldName;
        private File jmWorldFolder;

        public JmWorldList(String worldName, File jmWorldFolder) {
            this.worldName = worldName;
            this.jmWorldFolder = jmWorldFolder;
        }

        public String getWorldName() {
            return this.worldName;
        }

        public File getJmWorldFolder() {
            return this.jmWorldFolder;
        }
    }
}

