/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.ArrayList;
import java.util.List;
import mapwriter.Render;
import net.minecraft.client.gui.GuiScreen;

public class MwColorPallete
extends GuiScreen {
    private int x;
    private int y;
    private int palleteWidth;
    private int palleteHeight;
    private String palleteLabel = "Colour";
    private int colorCellHSpacing = 5;
    private int colorCellVSpacing = 5;
    private int colorCellsRowCount;
    private int colorCellsColumnCount;
    private int parentScreenWidth;
    private int parentScreenStartXpos;
    private int[] colors;
    private int selectedColor;
    public List<MwColorCell> colorCells = new ArrayList<MwColorCell>();

    public MwColorPallete(int x, int y, int palleteHeight, int[] colors, int selectedColor, int parentScreenWidth, int parentScreenStartXpos) {
        this.x = x;
        this.y = y;
        this.palleteWidth = palleteHeight;
        this.palleteHeight = palleteHeight;
        this.colors = colors;
        this.selectedColor = selectedColor;
        this.parentScreenWidth = parentScreenWidth;
        this.parentScreenStartXpos = parentScreenStartXpos;
        this.colorCellsRowCount = 0;
        this.colorCellsColumnCount = 0;
        int colorCellXPos = this.x;
        int colorCellYPos = this.y;
        for (int i = 0; i < this.colors.length; ++i) {
            if (this.x + (this.colorCellsColumnCount + 1) * this.palleteWidth + (this.colorCellsColumnCount + 1) * this.colorCellHSpacing > this.parentScreenStartXpos + this.parentScreenWidth) {
                this.colorCellsColumnCount = 0;
                ++this.colorCellsRowCount;
                colorCellXPos = this.x + this.colorCellsColumnCount * (this.palleteHeight + this.colorCellHSpacing);
                colorCellYPos = this.y + this.colorCellsRowCount * (this.colorCellVSpacing + this.palleteHeight);
            } else {
                colorCellXPos = this.x + this.colorCellsColumnCount * (this.palleteHeight + this.colorCellHSpacing);
                colorCellYPos = this.y + this.colorCellsRowCount * (this.colorCellVSpacing + this.palleteHeight);
            }
            this.colorCells.add(new MwColorCell(i, colorCellXPos, colorCellYPos, this.palleteWidth, this.palleteHeight, this.colors[i], false));
            ++this.colorCellsColumnCount;
        }
        this.setActiveCell(this.getIndexFromColor(selectedColor));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getpaletteLabel() {
        return this.palleteLabel;
    }

    public int getSelectedColor() {
        return this.selectedColor;
    }

    public int getIndexFromColor(int color) {
        for (int i = 0; i < this.colorCells.size(); ++i) {
            if (this.colorCells.get(i).cellColor != color) continue;
            return i;
        }
        return 0;
    }

    public int getActiveCell() {
        for (int i = 0; i < this.colorCells.size(); ++i) {
            if (!this.colorCells.get(i).cellActive) continue;
            return i;
        }
        return 0;
    }

    public void setActiveCell(int index) {
        for (int i = 0; i < this.colorCells.size(); ++i) {
            this.colorCells.get(i).setCellInacive();
        }
        this.colorCells.get(index).setCellActive();
        this.selectedColor = this.colorCells.get(index).cellColor;
    }

    public void setNextAcctiveCell(int index) {
        index = index + 1 > this.colorCells.size() - 1 ? 0 : index + 1;
        this.setActiveCell(index);
    }

    public void setPrevAcctiveCell(int index) {
        index = index - 1 < 0 ? this.colorCells.size() - 1 : index - 1;
        this.setActiveCell(index);
    }

    public int getColorCellsRowCount() {
        return this.colorCellsRowCount;
    }

    public int getColorCellsColumnCount() {
        return this.colorCellsColumnCount;
    }

    public int getPalleteWidth() {
        return this.palleteWidth;
    }

    public int getPalleteHeight() {
        return this.palleteHeight;
    }

    public int getColorCellVSpacing() {
        return this.colorCellVSpacing;
    }

    public void draw() {
        for (int i = 0; i < this.colorCells.size(); ++i) {
            this.colorCells.get(i).draw();
        }
    }

    class MwColorCell {
        private int index;
        private int cellX;
        private int cellY;
        private int cellWidth;
        private int cellHeight;
        private int cellColor;
        private boolean cellActive;

        public MwColorCell(int index, int cellX, int cellY, int cellWidth, int cellHeight, int cellColor, boolean cellActive) {
            this.index = index;
            this.cellX = cellX;
            this.cellY = cellY;
            this.cellWidth = cellWidth;
            this.cellHeight = cellHeight;
            this.cellColor = cellColor;
            this.cellActive = cellActive;
        }

        public void draw() {
            boolean colorCellRow = true;
            Render.setColour(this.cellColor);
            Render.drawRect(this.cellX, this.cellY, this.cellWidth, this.cellHeight);
            Render.setColour(-6250336);
            Render.drawRectBorder(this.cellX, this.cellY, this.cellWidth, this.cellHeight, 1.0);
            Render.setColour(this.cellActive ? -1 : 0xA0A0A0);
            Render.drawRectBorder(this.cellX - 1, this.cellY - 1, this.cellWidth + 2, this.cellHeight + 2, 1.0);
        }

        public void setCellActive() {
            this.cellActive = true;
        }

        public void setCellInacive() {
            this.cellActive = false;
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (mouseButton == 0 && mouseX >= this.cellX && mouseX <= this.cellX + this.cellWidth && mouseY >= this.cellY && mouseY <= this.cellY + this.cellWidth) {
                MwColorPallete.this.setActiveCell(this.index);
            }
        }

        public void mouseDWheelScrolled(int mouseX, int mouseY, int direction) {
            if (mouseX >= this.cellX && mouseX <= this.cellX + this.cellWidth && mouseY >= this.cellY && mouseY <= this.cellY + this.cellWidth) {
                if (direction > 0) {
                    MwColorPallete.this.setNextAcctiveCell(MwColorPallete.this.getActiveCell());
                } else {
                    MwColorPallete.this.setPrevAcctiveCell(MwColorPallete.this.getActiveCell());
                }
            }
        }
    }
}

