/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import mapwriter.Mw;
import mapwriter.MwUtil;
import mapwriter.api.IMwDataProvider;
import mapwriter.api.MwAPI;
import mapwriter.forge.MwKeyHandler;
import mapwriter.gui.MwGuiDropDownList;
import mapwriter.gui.MwGuiGroupManage;
import mapwriter.gui.MwGuiImportMarkerFromJM;
import mapwriter.gui.MwGuiMarkerDialog;
import mapwriter.gui.MwGuiMarkerDialogNew;
import mapwriter.gui.MwGuiMarkerManage;
import mapwriter.gui.MwGuiMarkerSearch;
import mapwriter.gui.MwGuiOptions;
import mapwriter.gui.MwGuiTeleportDialog;
import mapwriter.gui.MwGuiUserPresets;
import mapwriter.map.MapRenderer;
import mapwriter.map.MapView;
import mapwriter.map.Marker;
import mapwriter.map.mapmode.FullScreenMapMode;
import mapwriter.map.mapmode.MapMode;
import mapwriter.tasks.MergeTask;
import mapwriter.tasks.RebuildRegionsTask;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MwGui
extends GuiScreen {
    private Mw mw;
    private MapMode mapMode;
    public MapView mapView;
    private MapRenderer map;
    private static final double PAN_FACTOR = 0.3;
    private static final int menuY = 5;
    private static final int menuX = 5;
    private int mouseLeftHeld = 0;
    private int mouseLeftDragStartX = 0;
    private int mouseLeftDragStartY = 0;
    private double viewXStart;
    private double viewZStart;
    private Marker movingMarker = null;
    private int movingMarkerXStart = 0;
    private int movingMarkerZStart = 0;
    private int mouseBlockX = 0;
    private int mouseBlockY = 0;
    private int mouseBlockZ = 0;
    public boolean backFromMarkerSearch = false;
    private boolean forbidenMapDragDrop = false;
    private int forbidenMapDragDropCounter = 0;
    private int exit = 0;
    private List<MwGuiDropDownList> mainMenuItems = new ArrayList<MwGuiDropDownList>();
    private boolean mainMenuItemMouseClick = false;
    private int mainMenuActiveElementIndex;
    private int mainMenuElementHspacing = 10;
    private int mainMenuEndPosX;
    private GuiButton optionsButton;

    public MwGui(Mw mw) {
        this.mw = mw;
        this.mapMode = new FullScreenMapMode(mw.config);
        this.mapView = new MapView(this.mw);
        this.map = new MapRenderer(this.mw, this.mapMode, this.mapView);
        this.mapView.setDimension(this.mw.miniMap.view.getDimension());
        this.mapView.setViewCentreScaled(this.mw.playerX, this.mw.playerZ, this.mw.playerDimension);
        this.mapView.setZoomLevel(0);
        this.menuInit();
    }

    public MwGui(Mw mw, int dim, int x, int z) {
        this(mw);
        this.mapView.setDimension(dim);
        this.mapView.setViewCentreScaled(x, z, dim);
        this.mapView.setZoomLevel(0);
        this.menuInit();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    private void menuInit() {
        this.mainMenuItems.add(new MwGuiDropDownList(this.mw.mc.field_71466_p, "options", I18n.func_135052_a((String)"mw.gui.mwgui.options", (Object[])new Object[0]), new ArrayList<String>(), true));
        ArrayList<String> dimensionMenuElement = new ArrayList<String>();
        for (int i = 0; i < this.mw.dimensionList.size(); ++i) {
            dimensionMenuElement.add(this.mw.dimensionList.get(i).toString());
        }
        this.mainMenuItems.add(new MwGuiDropDownList(this.mw.mc.field_71466_p, "dimension", I18n.func_135052_a((String)"mw.gui.mwgui.dimension", (Object[])new Object[0]), dimensionMenuElement, true, true));
        this.mainMenuItems.add(new MwGuiDropDownList(this.mw.mc.field_71466_p, "group", I18n.func_135052_a((String)"mw.gui.mwgui.group", (Object[])new Object[0]), this.mw.markerManager.groupList, true, true));
        ArrayList<String> overlayMenuElement = new ArrayList<String>();
        overlayMenuElement.add("None");
        for (int i = 0; i < MwAPI.getProviderKeys().size(); ++i) {
            overlayMenuElement.add(MwAPI.getProviderKeys().get(i));
        }
        this.mainMenuItems.add(new MwGuiDropDownList(this.mw.mc.field_71466_p, "overlay", I18n.func_135052_a((String)"mw.gui.mwgui.overlay", (Object[])new Object[0]), overlayMenuElement, true, true));
        ArrayList<String> markerMenuElement = new ArrayList<String>();
        markerMenuElement.add(I18n.func_135052_a((String)"mw.gui.mwguimenumarkerssearch", (Object[])new Object[0]));
        markerMenuElement.add(I18n.func_135052_a((String)"mw.gui.mwguimenumarkersmanage", (Object[])new Object[0]));
        markerMenuElement.add(I18n.func_135052_a((String)"mw.gui.mwguimenumarkersgroup", (Object[])new Object[0]));
        markerMenuElement.add(I18n.func_135052_a((String)"mw.gui.mwguimenumarkersimportJM", (Object[])new Object[0]));
        markerMenuElement.add(I18n.func_135052_a((String)"mw.gui.mwguimenumarkersuserpreset", (Object[])new Object[0]));
        this.mainMenuItems.add(new MwGuiDropDownList(this.mw.mc.field_71466_p, "markers", I18n.func_135052_a((String)"mw.gui.mwgui.markers", (Object[])new Object[0]), markerMenuElement, true));
        this.mainMenuItems.add(new MwGuiDropDownList(this.mw.mc.field_71466_p, "help", I18n.func_135052_a((String)"mw.gui.mwgui.help", (Object[])new Object[0]), new ArrayList<String>(), false));
        for (int i = 0; i < this.mainMenuItems.size(); ++i) {
            this.mainMenuItems.get(i).init();
            this.mainMenuItems.get(i).setDropDownListPosY(5 + this.mw.mc.field_71466_p.field_78288_b);
        }
    }

    private boolean isPosInsideMainMenu(int mouseX, int mouseY) {
        int startXDetect = 5;
        int endXDetect = this.mainMenuEndPosX + this.mainMenuItems.size() * this.mainMenuElementHspacing;
        int startYDetect = 5;
        int endYDetect = startYDetect + this.mw.mc.field_71466_p.field_78288_b;
        return mouseX > startXDetect && mouseX < endXDetect && mouseY > startYDetect && mouseY < endYDetect;
    }

    private boolean isInsideMainMenuElementClickable(int mainMenuActiveElementIndex) {
        return this.mainMenuItems.get(mainMenuActiveElementIndex).isElementMenuClickable();
    }

    protected void func_146284_a(GuiButton button) {
    }

    public void exitGui() {
        this.mw.miniMap.view.setDimension(this.mapView.getDimension());
        this.mapMode.close();
        Keyboard.enableRepeatEvents((boolean)false);
        this.field_146297_k.func_147108_a((GuiScreen)null);
        this.field_146297_k.func_71381_h();
        this.field_146297_k.func_147118_V().func_147687_e();
    }

    public Marker getMarkerNearScreenPos(int x, int y) {
        Marker nearMarker = null;
        for (Marker marker : this.mw.markerManager.visibleMarkerList) {
            if (marker.screenPos == null || !(marker.screenPos.distanceSq(x, y) < 6.0)) continue;
            nearMarker = marker;
        }
        return nearMarker;
    }

    public int getHeightAtBlockPos(int bX, int bZ) {
        int bY = 0;
        int worldDimension = this.mw.mc.field_71441_e.field_73011_w.field_76574_g;
        if (worldDimension == this.mapView.getDimension() && worldDimension != -1) {
            bY = this.mw.mc.field_71441_e.func_72938_d(bX, bZ).func_76611_b(bX & 0xF, bZ & 0xF);
        }
        return bY;
    }

    public boolean isPlayerNearScreenPos(int x, int y) {
        Point2D.Double p = this.map.playerArrowScreenPos;
        return p.distanceSq(x, y) < 9.0;
    }

    public void deleteSelectedMarker() {
        if (this.mw.markerManager.selectedMarker != null) {
            this.mw.markerManager.delMarker(this.mw.markerManager.selectedMarker);
            this.mw.markerManager.update();
            this.mw.markerManager.selectedMarker = null;
            this.mw.markerManager.saveMarkersToFile();
        }
    }

    public void mergeMapViewToImage() {
        this.mw.chunkManager.saveChunks();
        this.mw.executor.addTask(new MergeTask(this.mw.regionManager, (int)this.mapView.getX(), (int)this.mapView.getZ(), (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), this.mapView.getDimension(), this.mw.worldDir, this.mw.worldDir.getName()));
        MwUtil.printBoth(I18n.func_135052_a((String)"mw.gui.mwgui.chatmsg.merge", (Object[])new Object[0]) + " '" + this.mw.worldDir.getAbsolutePath() + "'");
    }

    public void regenerateView() {
        MwUtil.printBoth(String.format(I18n.func_135052_a((String)"mw.gui.mwgui.chatmsg.regenmap.1", (Object[])new Object[0]) + " %dx%d " + I18n.func_135052_a((String)"mw.gui.mwgui.chatmsg.regenmap.2", (Object[])new Object[0]) + " (%d, %d)", (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), (int)this.mapView.getMinX(), (int)this.mapView.getMinZ()));
        this.mw.reloadBlockColours();
        this.mw.executor.addTask(new RebuildRegionsTask(this.mw, (int)this.mapView.getMinX(), (int)this.mapView.getMinZ(), (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), this.mapView.getDimension()));
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.exitGui();
                break;
            }
            case 211: {
                this.deleteSelectedMarker();
                break;
            }
            case 57: {
                this.mw.markerManager.nextGroup();
                this.mw.markerManager.update();
                break;
            }
            case 46: {
                if (this.mw.markerManager.selectedMarker == null) break;
                this.mw.markerManager.selectedMarker.colourNext(this.mw.markerManager, this.mw.markerManager.selectedMarker);
                break;
            }
            case 49: {
                this.mw.markerManager.selectNextMarker();
                break;
            }
            case 199: {
                this.mapView.setViewCentreScaled(this.mw.playerX, this.mw.playerZ, this.mw.playerDimension);
                break;
            }
            case 207: {
                if (this.mw.markerManager.selectedMarker == null) break;
                this.mapView.setViewCentreScaled(this.mw.markerManager.selectedMarker.x, this.mw.markerManager.selectedMarker.z, 0);
                break;
            }
            case 25: {
                this.mergeMapViewToImage();
                this.exitGui();
                break;
            }
            case 20: {
                if (this.mw.markerManager.selectedMarker != null) {
                    this.mw.teleportToMarker(this.mw.markerManager.selectedMarker);
                    this.exitGui();
                    break;
                }
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiTeleportDialog(this, this.mw, this.mapView, this.mouseBlockX, this.mw.defaultTeleportHeight, this.mouseBlockZ));
                break;
            }
            case 203: {
                this.mapView.panView(-0.3, 0.0);
                break;
            }
            case 205: {
                this.mapView.panView(0.3, 0.0);
                break;
            }
            case 200: {
                this.mapView.panView(0.0, -0.3);
                break;
            }
            case 208: {
                this.mapView.panView(0.0, 0.3);
                break;
            }
            case 19: {
                this.regenerateView();
                this.exitGui();
                break;
            }
            default: {
                if (key == MwKeyHandler.keyMapGui.func_151463_i()) {
                    this.exit = 1;
                    break;
                }
                if (key == MwKeyHandler.keyZoomIn.func_151463_i()) {
                    this.mapView.adjustZoomLevel(-1);
                    break;
                }
                if (key == MwKeyHandler.keyZoomOut.func_151463_i()) {
                    this.mapView.adjustZoomLevel(1);
                    break;
                }
                if (key == MwKeyHandler.keyNextGroup.func_151463_i()) {
                    this.mw.markerManager.nextGroup();
                    this.mw.markerManager.update();
                    break;
                }
                if (key == MwKeyHandler.keyPrevGroup.func_151463_i()) {
                    this.mw.markerManager.prevGroup();
                    this.mw.markerManager.update();
                    break;
                }
                if (key != MwKeyHandler.keyUndergroundMode.func_151463_i()) break;
                this.mw.toggleUndergroundMode();
                this.mapView.setUndergroundMode(this.mw.undergroundMode);
            }
        }
    }

    public void func_146274_d() {
        if (MwAPI.getCurrentDataProvider() != null && MwAPI.getCurrentDataProvider().onMouseInput(this.mapView, this.mapMode)) {
            return;
        }
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int direction = Mouse.getEventDWheel();
        if (direction != 0) {
            this.mouseDWheelScrolled(x, y, direction);
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int x, int y, int button) {
        Marker marker = this.getMarkerNearScreenPos(x, y);
        Marker prevMarker = this.mw.markerManager.selectedMarker;
        if (button == 0) {
            if (this.mainMenuItemMouseClick && this.mainMenuItems.get(this.mainMenuActiveElementIndex).isPosInsideDropdownList(this.mainMenuItems.get(this.mainMenuActiveElementIndex), x, y)) {
                this.dropDownListClicked(this.mainMenuActiveElementIndex, x, y);
            }
            if (this.isPosInsideMainMenu(x, y) && this.isInsideMainMenuElementClickable(this.mainMenuActiveElementIndex)) {
                this.mainMenuItemMouseClick = !this.mainMenuItemMouseClick;
            } else {
                this.mainMenuItemMouseClick = false;
                this.mouseLeftHeld = 1;
                this.mouseLeftDragStartX = x;
                this.mouseLeftDragStartY = y;
            }
            if (this.isPosInsideMainMenu(x, y) && this.mainMenuActiveElementIndex == 0) {
                this.mainMenuItemMouseClick = false;
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiOptions(this, this.mw));
            }
            if (!this.backFromMarkerSearch) {
                this.mw.markerManager.selectedMarker = marker;
            } else {
                this.backFromMarkerSearch = false;
            }
            if (marker != null && prevMarker == marker) {
                this.movingMarker = marker;
                this.movingMarkerXStart = marker.x;
                this.movingMarkerZStart = marker.z;
            }
        } else if (button == 1) {
            if (marker != null && prevMarker == marker) {
                if (this.mw.newMarkerDialog) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialogNew(this, this.mw.markerManager, marker));
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialog(this, this.mw.markerManager, marker));
                }
            } else if (marker == null) {
                int mz;
                int my;
                int mx;
                String group = this.mw.markerManager.getVisibleGroupName();
                if (group.equals("none")) {
                    group = I18n.func_135052_a((String)"mw.gui.mwgui.group", (Object[])new Object[0]);
                }
                if (this.isPlayerNearScreenPos(x, y)) {
                    mx = this.mw.playerXInt;
                    my = this.mw.playerYInt;
                    mz = this.mw.playerZInt;
                } else {
                    mx = this.mouseBlockX;
                    my = this.mouseBlockY > 0 ? this.mouseBlockY : this.mw.defaultTeleportHeight;
                    mz = this.mouseBlockZ;
                }
                if (this.mw.newMarkerDialog) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialogNew(this, this.mw.markerManager, "", group, mx, my, mz, this.mapView.getDimension()));
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialog(this, this.mw.markerManager, "", group, mx, my, mz, this.mapView.getDimension()));
                }
            }
        } else if (button == 2) {
            Point blockPoint = this.mapMode.screenXYtoBlockXZ(this.mapView, x, y);
            IMwDataProvider provider = MwAPI.getCurrentDataProvider();
            if (provider != null) {
                provider.onMiddleClick(this.mapView.getDimension(), blockPoint.x, blockPoint.y, this.mapView);
            }
        }
        this.viewXStart = this.mapView.getX();
        this.viewZStart = this.mapView.getZ();
    }

    public void dropDownListClicked(int mainMenuActiveElementIndex, int posX, int posY) {
        MwGuiDropDownList activeDropDownList = this.mainMenuItems.get(mainMenuActiveElementIndex);
        int activeDropDownListItemIndex = activeDropDownList.getDropDownActiveElementIndex(activeDropDownList, posX, posY);
        if (activeDropDownList.getMenuID().equals("dimension")) {
            this.mapView.setDimension(Integer.parseInt(activeDropDownList.getDropDownActiveElement(activeDropDownListItemIndex)));
        } else if (activeDropDownList.getMenuID().equals("group")) {
            this.mw.markerManager.setVisibleGroupName(activeDropDownList.getDropDownActiveElement(activeDropDownListItemIndex));
            this.mw.markerManager.update();
        } else if (activeDropDownList.getMenuID().equals("overlay")) {
            MwAPI.setCurrentDataProvider(activeDropDownList.getDropDownActiveElement(activeDropDownListItemIndex));
        } else if (activeDropDownList.getMenuID().equals("markers")) {
            if (activeDropDownListItemIndex == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerSearch(this, this.mw));
            } else if (activeDropDownListItemIndex == 1) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerManage(this, this.mw));
            } else if (activeDropDownListItemIndex == 2) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiGroupManage(this.mw, this, this.field_146294_l / 2, this.field_146295_m / 2));
            } else if (activeDropDownListItemIndex == 3) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiImportMarkerFromJM(this, this.mw.markerManager));
            } else if (activeDropDownListItemIndex == 4) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiUserPresets(this.mw, this));
                this.forbidenMapDragDropCounter = 0;
                this.forbidenMapDragDrop = true;
            }
        }
    }

    protected void mouseReleased(int x, int y, int button) {
        if (button == 0) {
            this.mouseLeftHeld = 0;
            this.movingMarker = null;
        } else if (button == 1) {
            // empty if block
        }
    }

    public void mouseDWheelScrolled(int x, int y, int direction) {
        Marker marker = this.getMarkerNearScreenPos(x, y);
        if (marker != null && marker == this.mw.markerManager.selectedMarker) {
            if (direction > 0) {
                marker.colourNext(this.mw.markerManager, marker);
                this.mw.markerManager.saveMarkersToFile();
            } else {
                marker.colourPrev(this.mw.markerManager, marker);
                this.mw.markerManager.saveMarkersToFile();
            }
        } else if (this.isPosInsideMainMenu(x, y) && this.mainMenuActiveElementIndex == 1) {
            int n = direction > 0 ? 1 : -1;
            this.mapView.nextDimension(this.mw.dimensionList, n);
        } else if (this.isPosInsideMainMenu(x, y) && this.mainMenuActiveElementIndex == 2) {
            int n = direction > 0 ? 1 : -1;
            this.mw.markerManager.nextGroup(n);
            this.mw.markerManager.update();
        } else if (this.isPosInsideMainMenu(x, y) && this.mainMenuActiveElementIndex == 3) {
            int n;
            int n2 = n = direction > 0 ? 1 : -1;
            if (MwAPI.getCurrentDataProvider() != null) {
                MwAPI.getCurrentDataProvider().onOverlayDeactivated(this.mapView);
            }
            if (n == 1) {
                MwAPI.setNextProvider();
            } else {
                MwAPI.setPrevProvider();
            }
            if (MwAPI.getCurrentDataProvider() != null) {
                MwAPI.getCurrentDataProvider().onOverlayActivated(this.mapView);
            }
        } else {
            int zF = direction > 0 ? -1 : 1;
            this.mapView.zoomToPoint(this.mapView.getZoomLevel() + zF, this.mouseBlockX, this.mouseBlockZ);
        }
    }

    public void func_73876_c() {
        if (this.exit > 0) {
            ++this.exit;
        }
        if (this.exit > 2) {
            this.exitGui();
        }
        super.func_73876_c();
    }

    public void drawStatus(int bX, int bY, int bZ) {
        IMwDataProvider provider;
        String s = bY != 0 ? I18n.func_135052_a((String)"mw.gui.mwgui.status.cursor", (Object[])new Object[]{bX, bY, bZ}) : I18n.func_135052_a((String)"mw.gui.mwgui.status.cursorNoY", (Object[])new Object[]{bX, bZ});
        if (this.field_146297_k.field_71441_e != null && !this.field_146297_k.field_71441_e.func_72938_d(bX, bZ).func_76621_g()) {
            s = s + String.format(", " + I18n.func_135052_a((String)"mw.gui.mwgui.status.biome", (Object[])new Object[]{this.field_146297_k.field_71441_e.func_72807_a((int)bX, (int)bZ).field_76791_y}), new Object[0]);
        }
        if ((provider = MwAPI.getCurrentDataProvider()) != null) {
            s = s + provider.getStatusString(this.mapView.getDimension(), bX, bY, bZ);
        }
        MwGui.func_73734_a((int)10, (int)(this.field_146295_m - 21), (int)(this.field_146294_l - 20), (int)(this.field_146295_m - 6), (int)Integer.MIN_VALUE);
        this.func_73732_a(this.field_146289_q, s, this.field_146294_l / 2, this.field_146295_m - 18, 0xFFFFFF);
    }

    public void drawHelp(int posX, int posY) {
        int windowWidth = this.field_146294_l - 100;
        int windowHeight = this.field_146295_m - 30;
        int windowPosX = (this.field_146294_l - windowWidth) / 2;
        int windowPosY = 5 * 3;
        MwGui.func_73734_a((int)windowPosX, (int)windowPosY, (int)windowWidth, (int)windowHeight, (int)Integer.MIN_VALUE);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"mw.gui.mwgui.keys", (Object[])new Object[0]) + ":\n\n  Space\n  Delete\n  C\n  Home\n  End\n  N\n  T\n  P\n  R\n  U\n\n" + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.1", (Object[])new Object[0]) + "\n" + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.2", (Object[])new Object[0]) + "\n" + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.3", (Object[])new Object[0]) + "\n" + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.4", (Object[])new Object[0]) + "\n" + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.5", (Object[])new Object[0]) + "\n" + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.6", (Object[])new Object[0]) + "\n", windowPosX + 15, windowPosY + 24, windowWidth - 30, 0xFFFFFF);
        this.field_146289_q.func_78279_b("| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.nextmarkergroup", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.deletemarker", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.cyclecolour", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.centermap", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.centermapplayer", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.selectnextmarker", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.teleport", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.savepng", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.regenerate", (Object[])new Object[0]) + "\n| " + I18n.func_135052_a((String)"mw.gui.mwgui.helptext.undergroundmap", (Object[])new Object[0]) + "\n", windowPosX + 75, windowPosY + 42, windowWidth - 90, 0xFFFFFF);
    }

    public void drawMouseOverHint(int x, int y, String title, int mX, int mY, int mZ) {
        String desc = String.format("(%d, %d, %d)", mX, mY, mZ);
        int stringW = Math.max(this.field_146289_q.func_78256_a(title), this.field_146289_q.func_78256_a(desc));
        x = Math.min(x, this.field_146294_l - (stringW + 16));
        y = Math.min(Math.max(10, y), this.field_146295_m - 14);
        MwGui.func_73734_a((int)(x + 8), (int)(y - 10), (int)(x + stringW + 16), (int)(y + 14), (int)Integer.MIN_VALUE);
        this.func_73731_b(this.field_146289_q, title, x + 10, y - 8, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, desc, x + 10, y + 4, 0xCCCCCC);
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        int i;
        if (this.forbidenMapDragDropCounter > 50) {
            if (this.forbidenMapDragDrop) {
                this.forbidenMapDragDrop = false;
            } else {
                this.forbidenMapDragDropCounter = 0;
            }
        } else {
            ++this.forbidenMapDragDropCounter;
        }
        this.func_146276_q_();
        double xOffset = 0.0;
        double yOffset = 0.0;
        if (this.mouseLeftHeld > 2 && !this.forbidenMapDragDrop) {
            xOffset = (double)(this.mouseLeftDragStartX - mouseX) * this.mapView.getWidth() / (double)this.mapMode.w;
            yOffset = (double)(this.mouseLeftDragStartY - mouseY) * this.mapView.getHeight() / (double)this.mapMode.h;
            if (this.movingMarker != null) {
                double scale = this.mapView.getDimensionScaling(this.movingMarker.dimension);
                this.movingMarker.x = this.movingMarkerXStart - (int)(xOffset / scale);
                this.movingMarker.z = this.movingMarkerZStart - (int)(yOffset / scale);
            } else {
                this.mapView.setViewCentre(this.viewXStart + xOffset, this.viewZStart + yOffset);
            }
        }
        if (this.mouseLeftHeld > 0 && Mouse.isButtonDown((int)0)) {
            ++this.mouseLeftHeld;
        } else {
            this.movingMarker = null;
            this.mouseLeftHeld = 0;
        }
        this.map.draw();
        if (this.field_146297_k.field_71462_r instanceof MwGui) {
            Point p = this.mapMode.screenXYtoBlockXZ(this.mapView, mouseX, mouseY);
            this.mouseBlockX = p.x;
            this.mouseBlockZ = p.y;
            this.mouseBlockY = this.getHeightAtBlockPos(this.mouseBlockX, this.mouseBlockZ);
            Marker marker = this.getMarkerNearScreenPos(mouseX, mouseY);
            if (marker != null) {
                this.drawMouseOverHint(mouseX, mouseY, marker.name, marker.x, marker.y, marker.z);
            }
            if (this.isPlayerNearScreenPos(mouseX, mouseY)) {
                this.drawMouseOverHint(mouseX, mouseY, this.field_146297_k.field_71439_g.getDisplayName(), this.mw.playerXInt, this.mw.playerYInt, this.mw.playerZInt);
            }
            this.drawStatus(this.mouseBlockX, this.mouseBlockY, this.mouseBlockZ);
        }
        for (int i2 = 0; i2 < this.mainMenuItems.size(); ++i2) {
            if (this.mainMenuItems.get(i2).getMenuID().equals("group")) {
                this.mainMenuItems.get(i2).setCurrentMenuItemName(this.mw.markerManager.getVisibleGroupName());
                continue;
            }
            if (this.mainMenuItems.get(i2).getMenuID().equals("dimension")) {
                this.mainMenuItems.get(i2).setCurrentMenuItemName(String.valueOf(this.mapView.getDimension()));
                continue;
            }
            if (!this.mainMenuItems.get(i2).getMenuID().equals("overlay")) continue;
            this.mainMenuItems.get(i2).setCurrentMenuItemName(MwAPI.getCurrentProviderName());
        }
        int mainMenuElementXpos = 0;
        for (i = 0; i < this.mainMenuItems.size(); ++i) {
            int mainMenuElementWidth = this.mw.mc.field_71466_p.func_78256_a(this.mainMenuItems.get(i).getMenuItemName());
            this.mainMenuItems.get(i).draw(5 + mainMenuElementXpos + i * this.mainMenuElementHspacing, 5, this.mainMenuItems.get(i).getMenuItemName());
            this.mainMenuEndPosX = mainMenuElementXpos += mainMenuElementWidth;
        }
        if (this.field_146297_k.field_71462_r instanceof MwGui) {
            if (this.isPosInsideMainMenu(mouseX, mouseY)) {
                for (i = 0; i < this.mainMenuItems.size(); ++i) {
                    if (!this.mainMenuItems.get(i).posWithin(mouseX, mouseY)) continue;
                    this.mainMenuActiveElementIndex = i;
                    break;
                }
                if (!this.mainMenuItemMouseClick) {
                    this.mainMenuItems.get(this.mainMenuActiveElementIndex).drawHighlightMainMenuElement(this.mainMenuItems.get(this.mainMenuActiveElementIndex));
                }
            }
            if (this.mainMenuItemMouseClick) {
                MwGuiDropDownList activeMainMenuElement = this.mainMenuItems.get(this.mainMenuActiveElementIndex);
                activeMainMenuElement.drawHighlightMainMenuElement(activeMainMenuElement);
                activeMainMenuElement.drawDropDownList(activeMainMenuElement);
                activeMainMenuElement.drawHighlightDropDownListElement(activeMainMenuElement, mouseX, mouseY);
            }
            if (this.isPosInsideMainMenu(mouseX, mouseY) && this.mainMenuActiveElementIndex == 5) {
                this.drawHelp(this.mainMenuEndPosX, 5 + this.mw.mc.field_71466_p.field_78288_b);
            }
        }
        super.func_73863_a(mouseX, mouseY, f);
    }
}

