/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.List;
import mapwriter.Render;
import mapwriter.gui.MwColorPallete;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class MwGuiColorComboBox
extends GuiScreen {
    GuiScreen parentScreen;
    MwColorPallete colorPallete;
    private int posX;
    private int posY;
    private List<Integer> colorList;
    private int arrowIconX;
    private int arrowIconY;
    private int arrowIconWidth = 12;
    private int arrowIconHeight = 12;
    private int colorCellWidth = 12;
    private int colorCellHeight = 12;
    private int width = this.colorCellWidth + 2;
    private int height = this.colorCellHeight + 2;
    private int activeColor = -1;
    private int elementListSpasing = 1;
    private boolean dropDownelementList = false;
    int dropDownListPosX;
    int dropDownListPosY;
    int dropDownListWidth;
    int dropDownListHeight;
    int colorCellRows = 2;
    int colorCellCols;
    private ResourceLocation arrowIconTexture = new ResourceLocation("mapwriter", "textures/map/arrow_combobox.png");

    public MwGuiColorComboBox(GuiScreen parentScreen, int posX, int posY, List<Integer> colorList) {
        this.parentScreen = parentScreen;
        this.posX = posX;
        this.posY = posY;
        this.colorList = colorList;
        this.init();
    }

    public void init() {
        int colorCount = 10;
        int colorRows = 3;
        this.colorCellCols = this.colorList.size() / this.colorCellRows;
        if (this.colorCellCols * this.colorCellRows < this.colorList.size()) {
            ++this.colorCellRows;
        }
        this.activeColor = this.colorList.get(0);
        this.arrowIconX = this.posX + this.width;
        this.arrowIconY = this.posY;
        this.dropDownListPosX = this.posX - 1;
        this.dropDownListPosY = this.posY + this.height;
        this.dropDownListWidth = this.colorCellCols * (this.colorCellWidth + this.elementListSpasing);
        this.dropDownListHeight = this.colorCellRows * (this.colorCellHeight + this.elementListSpasing);
    }

    private boolean isArrowClick(int mouseX, int mouseY) {
        int startXDetect = this.arrowIconX;
        int endXDetect = startXDetect + this.arrowIconWidth;
        int startYDetect = this.arrowIconY;
        int endYDetect = startYDetect + this.arrowIconHeight;
        return mouseX > startXDetect && mouseX < endXDetect && mouseY > startYDetect && mouseY < endYDetect;
    }

    public boolean isPosInsideDropdownList(int mouseX, int mouseY) {
        int startXDetect = this.dropDownListPosX;
        int endXDetect = startXDetect + this.dropDownListWidth;
        int startYDetect = this.dropDownListPosY;
        int endYDetect = startYDetect + this.dropDownListHeight;
        return mouseX > startXDetect && mouseX < endXDetect && mouseY > startYDetect && mouseY < endYDetect;
    }

    public int getDropDownActiveElementIndex(int mouseX, int mouseY, String data) {
        int col = (mouseX - this.dropDownListPosX) / (this.colorCellWidth + 1);
        int row = (mouseY - this.dropDownListPosY) / (this.colorCellHeight + 1);
        int index = this.colorList.size() / this.colorCellRows * row + col;
        if (data.equals("index")) {
            return index;
        }
        if (data.equals("column")) {
            return col;
        }
        if (data.equals("row")) {
            return row;
        }
        return 0;
    }

    public int getActiveColor() {
        return this.activeColor;
    }

    public void setActiveColor(int color) {
        this.activeColor = color;
    }

    public boolean isDropDownelementListActive() {
        return this.dropDownelementList;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public List<Integer> getElementList() {
        return this.colorList;
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.isArrowClick(mouseX, mouseY)) {
            this.dropDownelementList = !this.dropDownelementList;
        } else if (this.dropDownelementList && this.isPosInsideDropdownList(mouseX, mouseY)) {
            this.activeColor = this.colorList.get(this.getDropDownActiveElementIndex(mouseX, mouseY, "index"));
            this.dropDownelementList = false;
        } else {
            this.dropDownelementList = false;
        }
    }

    protected void func_73869_a(char c, int key) {
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
    }

    public void draw(int mouseX, int mouseY) {
        MwGuiColorComboBox.func_73734_a((int)(this.posX - 2), (int)(this.posY - 2), (int)(this.posX + this.colorCellWidth + this.arrowIconWidth + 4), (int)(this.posY + this.height), (int)Integer.MIN_VALUE);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrowIconTexture);
        Render.setColour(-1);
        Render.drawTexturedRect(this.arrowIconX, this.arrowIconY, this.arrowIconWidth, this.arrowIconHeight, 0.0, 0.0, 1.0, 1.0);
        Render.setColour(-1);
        Render.drawRectBorder(this.posX, this.posY, this.colorCellWidth, this.colorCellHeight, 1.0);
        MwGuiColorComboBox.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + this.colorCellWidth), (int)(this.posY + this.colorCellHeight), (int)this.activeColor);
        if (this.dropDownelementList) {
            this.drawDropDownList(mouseX, mouseY);
            this.drawHighlightDropDownListElement(mouseX, mouseY);
        }
    }

    public void drawDropDownList(int mouseX, int mouseY) {
        int posX = 0;
        int posY = 0;
        int countCols = 0;
        int countRows = 0;
        if (this.dropDownListPosY + this.dropDownListHeight > this.parentScreen.field_146295_m) {
            this.colorCellRows = this.colorCellRows - 1 != 0 ? this.colorCellRows - 1 : 1;
            this.colorCellCols = Math.max(this.colorList.size() / this.colorCellRows, this.colorList.size());
        }
        this.dropDownListWidth = this.colorCellCols * (this.colorCellWidth + this.elementListSpasing);
        this.dropDownListHeight = this.colorCellRows * (this.colorCellHeight + this.elementListSpasing);
        MwGuiColorComboBox.func_73734_a((int)this.dropDownListPosX, (int)this.dropDownListPosY, (int)(this.dropDownListPosX + this.dropDownListWidth), (int)(this.dropDownListPosY + this.dropDownListHeight), (int)-16777216);
        Render.setColour(-1);
        Render.drawRectBorder(this.dropDownListPosX - 1, this.dropDownListPosY - 1, this.dropDownListWidth + 1, this.dropDownListHeight + 1, 1.0);
        for (int i = 0; i < this.colorList.size(); ++i) {
            if (countRows >= this.colorCellRows) continue;
            if (countCols < this.colorCellCols) {
                posX = this.dropDownListPosX + countCols * (this.colorCellWidth + this.elementListSpasing);
                posY = this.dropDownListPosY + countRows * (this.colorCellHeight + this.elementListSpasing);
                ++countCols;
            } else {
                countCols = 0;
                posX = this.dropDownListPosX + countCols * (this.colorCellWidth + this.elementListSpasing);
                posY = this.dropDownListPosY + ++countRows * (this.colorCellHeight + this.elementListSpasing);
                MwGuiColorComboBox.func_73734_a((int)posX, (int)posY, (int)(posX + this.colorCellWidth), (int)(posY + this.colorCellHeight), (int)this.colorList.get(i));
                ++countCols;
            }
            MwGuiColorComboBox.func_73734_a((int)posX, (int)posY, (int)(posX + this.colorCellWidth), (int)(posY + this.colorCellHeight), (int)this.colorList.get(i));
        }
    }

    public void drawHighlightDropDownListElement(int posX, int posY) {
        int colPos = 1;
        int rowPos = 1;
        if (this.dropDownelementList && this.isPosInsideDropdownList(posX, posY)) {
            colPos = this.getDropDownActiveElementIndex(posX, posY, "column");
            rowPos = this.getDropDownActiveElementIndex(posX, posY, "row");
            int highlightBoxposX = this.dropDownListPosX + colPos * (this.colorCellWidth + this.elementListSpasing);
            int highlightBoxPosY = this.dropDownListPosY + rowPos * (this.colorCellHeight + this.elementListSpasing);
            int highlightBoxWidth = this.colorCellWidth;
            int highlightBoxHeight = this.colorCellHeight;
            Render.setColour(-1);
            Render.drawRectBorder(highlightBoxposX, highlightBoxPosY, highlightBoxWidth, highlightBoxHeight, 1.0);
        }
    }
}

