/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.List;
import mapwriter.Render;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;

public class MwGuiComboBox
extends GuiScreen {
    private int posX;
    private int posY;
    private int width;
    private int height;
    private String label;
    private int labelPosX;
    private int labelPosY;
    private boolean editableTextField;
    private int textFieldPosX;
    private int textFieldPosY;
    private int textFieldWidth;
    private int textFieldHeight;
    private FontRenderer fontRenderer;
    private List<String> elementList;
    private int selectionElementIndex;
    private int arrowIconX;
    private int arrowIconY;
    private int arrowIconWidth = 12;
    private int arrowIconHeight = 12;
    private int elementListSpasing = 1;
    private boolean dropDownelementList = false;
    int dropDownListPosX;
    int dropDownListPosY;
    int dropDownListWidth;
    int dropDownListHeight;
    private GuiTextField textField = null;
    private ResourceLocation arrowIconTexture = new ResourceLocation("mapwriter", "textures/map/arrow_combobox.png");

    public MwGuiComboBox(FontRenderer fontRenderer, int posX, int posY, String label, int width, List<String> elementList, boolean editableTextField) {
        this.posX = posX;
        this.posY = posY;
        this.fontRenderer = fontRenderer;
        this.label = label;
        this.width = width;
        this.elementList = elementList;
        this.editableTextField = editableTextField;
        this.selectionElementIndex = 0;
        this.init();
    }

    public void init() {
        this.labelPosX = this.posX + 2;
        this.labelPosY = this.posY + 2;
        this.textFieldPosX = this.labelPosX + this.fontRenderer.func_78256_a(this.label) + 5;
        this.textFieldPosY = this.labelPosY;
        this.textFieldHeight = this.fontRenderer.field_78288_b;
        this.textFieldWidth = this.width - this.fontRenderer.func_78256_a(this.label) - 5 - this.arrowIconWidth - 2 - 4;
        this.height = this.textFieldHeight + 4;
        this.arrowIconX = this.textFieldPosX + this.textFieldWidth + 2;
        this.arrowIconY = this.posY;
        this.textField = new GuiTextField(this.fontRenderer, this.textFieldPosX, this.textFieldPosY, this.textFieldWidth, this.textFieldHeight);
        this.textField.func_146184_c(this.editableTextField);
        if (this.elementList.size() > 0) {
            this.textField.func_146180_a(this.elementList.get(0));
        } else {
            this.textField.func_146180_a("");
        }
        this.dropDownListPosX = this.textFieldPosX;
        this.dropDownListPosY = this.posY + this.height;
        this.dropDownListWidth = this.textFieldWidth + this.arrowIconWidth + 4;
        this.dropDownListHeight = this.elementList.size() * (this.fontRenderer.field_78288_b + this.elementListSpasing);
    }

    public boolean isPosInsideComboBox(int mouseX, int mouseY, String detectionElement) {
        int startXDetect = 0;
        int endXDetect = 0;
        int startYDetect = 0;
        int endYDetect = 0;
        if (detectionElement.equals("arrow")) {
            startXDetect = this.arrowIconX;
            endXDetect = startXDetect + this.arrowIconWidth;
            startYDetect = this.arrowIconY;
            endYDetect = startYDetect + this.arrowIconHeight;
        } else if (detectionElement.equals("dropDownList")) {
            startXDetect = this.dropDownListPosX;
            endXDetect = startXDetect + this.dropDownListWidth;
            startYDetect = this.dropDownListPosY;
            endYDetect = startYDetect + this.dropDownListHeight;
        } else if (detectionElement.equals("textfield")) {
            startXDetect = this.textFieldPosX;
            endXDetect = startXDetect + this.textFieldWidth;
            startYDetect = this.textFieldPosY;
            endYDetect = startYDetect + this.textFieldHeight;
        } else {
            return false;
        }
        return mouseX > startXDetect && mouseX < endXDetect && mouseY > startYDetect && mouseY < endYDetect;
    }

    public int getDropDownActiveElementIndex(int mouseX, int mouseY) {
        return (mouseY - this.dropDownListPosY) / (this.fontRenderer.field_78288_b + 1);
    }

    public boolean validateTextFieldData() {
        return this.textField.func_146179_b().length() > 0;
    }

    public int getTextfieldPosX() {
        return this.textFieldPosX;
    }

    public int getTextfieldPosY() {
        return this.textFieldPosY;
    }

    public int getTextFieldWidth() {
        return this.textFieldWidth;
    }

    public int getTextFieldHeight() {
        return this.textFieldHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public List<String> getElementList() {
        return this.elementList;
    }

    public String getSelectionElementName() {
        return this.textField.func_146179_b();
    }

    public int getSelectionElementIndex() {
        return this.selectionElementIndex;
    }

    public boolean isDropDownelementListActive() {
        return this.dropDownelementList;
    }

    public void setNewElementName(String name) {
        this.elementList.set(this.selectionElementIndex, name);
    }

    public void setLabel(String labelName) {
        this.label = labelName;
    }

    public void setActiveElementName(String name) {
        this.textField.func_146180_a(name);
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.isPosInsideComboBox(mouseX, mouseY, "arrow")) {
            this.dropDownelementList = !this.dropDownelementList;
        } else if (this.dropDownelementList && this.isPosInsideComboBox(mouseX, mouseY, "dropDownList")) {
            int index = this.getDropDownActiveElementIndex(mouseX, mouseY);
            this.textField.func_146180_a(this.elementList.get(index));
            this.selectionElementIndex = index;
            this.dropDownelementList = false;
            this.textField.func_146195_b(false);
        } else {
            this.dropDownelementList = false;
        }
        if (this.isPosInsideComboBox(mouseX, mouseY, "textfield")) {
            this.textField.func_146192_a(mouseX, mouseY, button);
        }
        if (this.textField.func_146206_l() && !this.isPosInsideComboBox(mouseX, mouseY, "textfield") && !this.isPosInsideComboBox(mouseX, mouseY, "arrow")) {
            this.textField.func_146195_b(false);
        }
    }

    protected void func_73869_a(char c, int key) {
        if (this.textField.func_146206_l()) {
            this.textField.func_146201_a(c, key);
        }
        if (key == 28) {
            if (this.validateTextFieldData()) {
                this.setNewElementName(this.getSelectionElementName());
                this.textField.func_146195_b(false);
            } else {
                this.setNewElementName(this.elementList.get(this.selectionElementIndex));
                this.setActiveElementName(this.elementList.get(this.selectionElementIndex));
                this.textField.func_146195_b(false);
            }
        }
    }

    public void draw(int mouseX, int mouseY) {
        this.func_73731_b(this.fontRenderer, this.label, this.labelPosX, this.labelPosY, 0xFFFFFF);
        MwGuiComboBox.func_73734_a((int)(this.textFieldPosX - 2), (int)(this.textFieldPosY - 2), (int)(this.textFieldPosX + this.textFieldWidth + this.arrowIconWidth + 4), (int)(this.posY + this.height), (int)Integer.MIN_VALUE);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrowIconTexture);
        Render.setColour(-1);
        Render.drawTexturedRect(this.arrowIconX, this.arrowIconY, this.arrowIconWidth, this.arrowIconHeight, 0.0, 0.0, 1.0, 1.0);
        this.textField.func_146194_f();
        if (this.dropDownelementList) {
            this.drawDropDownList();
            this.drawHighlightDropDownListElement(mouseX, mouseY);
        }
    }

    public void drawDropDownList() {
        this.dropDownListHeight = this.elementList.size() * (this.fontRenderer.field_78288_b + this.elementListSpasing);
        MwGuiComboBox.func_73734_a((int)this.dropDownListPosX, (int)this.dropDownListPosY, (int)(this.dropDownListPosX + this.dropDownListWidth), (int)(this.dropDownListPosY + this.dropDownListHeight), (int)-16777216);
        for (int i = 0; i < this.elementList.size(); ++i) {
            this.func_73731_b(this.fontRenderer, this.elementList.get(i), this.dropDownListPosX, this.dropDownListPosY + i * (this.fontRenderer.field_78288_b + this.elementListSpasing), 0xFFFFFF);
        }
    }

    public void drawHighlightDropDownListElement(int posX, int posY) {
        int activeElement = this.getDropDownActiveElementIndex(posX, posY);
        if (this.dropDownelementList && this.isPosInsideComboBox(posX, posY, "dropDownList") && activeElement < this.elementList.size()) {
            int highlightBoxPosY = this.dropDownListPosY + activeElement * (this.fontRenderer.field_78288_b + this.elementListSpasing);
            int highlightBoxposX = this.dropDownListPosX;
            int highlightBoxWidth = this.dropDownListWidth;
            int highlightBoxHeight = this.fontRenderer.field_78288_b;
            MwGuiComboBox.func_73734_a((int)highlightBoxposX, (int)(highlightBoxPosY - this.elementListSpasing), (int)(highlightBoxposX + highlightBoxWidth), (int)(highlightBoxPosY + highlightBoxHeight), (int)-2130706433);
        }
    }
}

