/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class MwGuiDropDownList
extends GuiScreen {
    private FontRenderer fontRenderer;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private List<String> elementList;
    private int elementIndex;
    private String menuItemName;
    private String menuID;
    private String displayedMenuItemName;
    private boolean showLabel;
    private boolean isElementMenuClickable;
    private int dropDownListPosX;
    private int dropDownListPosY;
    private int dropDownListWidth;
    private int dropDownListHeight;
    private int menuItemElementVspacing = 1;
    private int menuFirstItemElementVshift = 3;
    private int menuItemElementTextShift = 5;
    private int menuItemElementHeight;

    public MwGuiDropDownList(FontRenderer fontRenderer, String menuID, String menuItemName, List<String> elementList, boolean isElementMenuClickable) {
        this.fontRenderer = fontRenderer;
        this.width = 0;
        this.isElementMenuClickable = isElementMenuClickable;
        this.menuID = menuID;
        this.menuItemName = menuItemName;
        this.elementList = elementList;
        this.showLabel = false;
    }

    public MwGuiDropDownList(FontRenderer fontRenderer, String menuID, String menuItemName, List<String> elementList, boolean isElementMenuClickable, boolean showLabel) {
        this.fontRenderer = fontRenderer;
        this.width = 0;
        this.isElementMenuClickable = isElementMenuClickable;
        this.showLabel = showLabel;
        this.menuID = menuID;
        this.menuItemName = menuItemName;
        this.elementList = elementList;
    }

    public String getMenuID() {
        return this.menuID;
    }

    public void addMenuItem(String menuItemName) {
        this.elementList.add(menuItemName);
    }

    public boolean posWithin(int posX, int posY) {
        return posX >= this.posX && posY >= this.posY && posX <= this.posX + this.width && posY <= this.posY + this.height;
    }

    public boolean isDropDownElements() {
        return this.elementList.size() > 0;
    }

    public boolean isElementMenuClickable() {
        return this.isElementMenuClickable;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public int getDropDownListElementsCount() {
        return this.elementList.size();
    }

    public int getDropDownActiveElementIndex(MwGuiDropDownList parentElement, int mouseX, int mouseY) {
        return (mouseY - parentElement.dropDownListPosY) / (parentElement.fontRenderer.field_78288_b + 1);
    }

    public String getDropDownActiveElement(int index) {
        return this.elementList.get(index);
    }

    public boolean isPosInsideDropdownList(MwGuiDropDownList parentElement, int mouseX, int mouseY) {
        int endXDetect;
        int startXDetect;
        if (parentElement.showLabel) {
            startXDetect = parentElement.posX + this.fontRenderer.func_78256_a(parentElement.menuItemName + ": ");
            endXDetect = startXDetect + this.dropDownListWidth;
        } else {
            startXDetect = parentElement.posX;
            endXDetect = startXDetect + parentElement.dropDownListWidth;
        }
        int startYDetect = parentElement.dropDownListPosY + parentElement.menuFirstItemElementVshift;
        int endYDetect = startYDetect + parentElement.dropDownListHeight;
        return mouseX > startXDetect && mouseX < endXDetect && mouseY > startYDetect && mouseY < endYDetect;
    }

    public void init() {
        this.displayedMenuItemName = this.isShowLabel() ? (this.getDropDownListElementsCount() > 0 ? this.menuItemName + ": " + this.elementList.get(0) : this.menuItemName + ":") : this.menuItemName;
        this.menuItemElementHeight = this.fontRenderer.field_78288_b;
        this.height = this.fontRenderer.field_78288_b + 4;
        if (this.isDropDownElements()) {
            int maxWidthInPixel = this.fontRenderer.func_78256_a(this.elementList.get(0));
            for (int i = 0; i < this.elementList.size(); ++i) {
                maxWidthInPixel = Math.max(maxWidthInPixel, this.fontRenderer.func_78256_a(this.elementList.get(i)));
            }
            this.dropDownListWidth = maxWidthInPixel + this.menuItemElementTextShift + 4;
        }
        this.dropDownListHeight = this.elementList.size() * (this.fontRenderer.field_78288_b + this.menuItemElementVspacing);
    }

    public String getMenuItemName() {
        return this.displayedMenuItemName;
    }

    public void setDropDownListPosY(int dropDownListPosY) {
        this.dropDownListPosY = dropDownListPosY;
    }

    public void setCurrentMenuItemName(String itemName) {
        if (this.isShowLabel()) {
            this.displayedMenuItemName = this.getDropDownListElementsCount() > 0 ? this.menuItemName + ": " + itemName : this.menuItemName + ":";
        }
    }

    public void draw(int posX, int posY, String menuItemName) {
        this.posX = posX;
        this.posY = posY;
        this.width = this.fontRenderer.func_78256_a(menuItemName) + 4;
        MwGuiDropDownList.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + this.width), (int)(this.posY + this.height), (int)Integer.MIN_VALUE);
        this.func_73731_b(this.fontRenderer, this.displayedMenuItemName, this.posX + 2, this.posY + 2, 0xFFFFFF);
    }

    public void drawHighlightMainMenuElement(MwGuiDropDownList parentElement) {
        MwGuiDropDownList.func_73734_a((int)parentElement.posX, (int)parentElement.posY, (int)(parentElement.posX + parentElement.width), (int)(parentElement.posY + parentElement.height), (int)-2130706433);
    }

    public void drawDropDownList(MwGuiDropDownList parentElement) {
        this.dropDownListHeight = this.elementList.size() * (this.fontRenderer.field_78288_b + this.menuItemElementVspacing);
        if (parentElement.elementList.size() > 0) {
            int listPosY;
            int listWidth;
            int listPosX;
            if (parentElement.showLabel) {
                listPosX = parentElement.posX + this.fontRenderer.func_78256_a(parentElement.menuItemName + ": ");
                listWidth = this.dropDownListWidth;
            } else {
                listPosX = parentElement.posX;
                listWidth = this.dropDownListWidth > this.width ? this.dropDownListWidth : this.width;
            }
            this.dropDownListPosY = listPosY = parentElement.posY + parentElement.height;
            MwGuiDropDownList.func_73734_a((int)listPosX, (int)listPosY, (int)(listPosX + listWidth), (int)(listPosY + this.dropDownListHeight + this.menuFirstItemElementVshift), (int)0x50000000);
            for (int i = 0; i < this.elementList.size(); ++i) {
                this.func_73731_b(this.fontRenderer, this.elementList.get(i), listPosX + this.menuItemElementTextShift, listPosY + this.menuFirstItemElementVshift + i * (this.menuItemElementHeight + this.menuItemElementVspacing), 0xFFFFFF);
            }
        }
    }

    public void drawHighlightDropDownListElement(MwGuiDropDownList parentElement, int posX, int posY) {
        int highlightBoxWidth;
        int highlightBoxposX;
        int activeElement = this.getDropDownActiveElementIndex(parentElement, posX, posY);
        int highlightBoxPosY = activeElement * 10 + parentElement.dropDownListPosY + parentElement.menuFirstItemElementVshift - parentElement.menuItemElementVspacing;
        if (parentElement.showLabel) {
            highlightBoxposX = parentElement.posX + this.fontRenderer.func_78256_a(parentElement.menuItemName + ": ");
            highlightBoxWidth = this.dropDownListWidth;
        } else {
            highlightBoxposX = parentElement.posX;
            int n = highlightBoxWidth = this.dropDownListWidth > this.width ? this.dropDownListWidth : this.width;
        }
        if (this.isPosInsideDropdownList(parentElement, posX, posY) && activeElement < parentElement.elementList.size()) {
            MwGuiDropDownList.func_73734_a((int)highlightBoxposX, (int)highlightBoxPosY, (int)(highlightBoxposX + highlightBoxWidth), (int)(highlightBoxPosY + parentElement.menuItemElementHeight + parentElement.menuItemElementVspacing), (int)-2130706433);
        }
    }
}

