/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.List;
import mapwriter.Mw;
import mapwriter.Render;
import mapwriter.gui.MwGuiComboBox;
import mapwriter.map.Marker;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;

public class MwGuiGroupManage
extends GuiScreen {
    private int posX;
    private int posY;
    private int windowWidth;
    private int windowHeight;
    String newGroupNameLabel = I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.rename", (Object[])new Object[0]);
    String errorMessage = "";
    boolean showErrorMessage = false;
    Mw mw;
    GuiScreen parentScreen;
    MwGuiComboBox groupComboBox = null;
    GuiTextField newGroupName = null;
    GuiButton renameButton;

    public MwGuiGroupManage(Mw mw, GuiScreen parentScreen, int posX, int posY) {
        this.mw = mw;
        this.parentScreen = parentScreen;
        this.posX = posX;
        this.posY = posY;
    }

    public void func_73866_w_() {
        this.windowWidth = this.field_146294_l * 60 / 100;
        this.windowHeight = this.field_146295_m * 50 / 100;
        this.posX = this.field_146294_l - this.windowWidth;
        this.posY = (this.field_146295_m - this.windowHeight) / 3;
        this.groupComboBox = new MwGuiComboBox(this.mw.mc.field_71466_p, this.posX + 5, this.posY + 30, I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.group", (Object[])new Object[0]), this.windowWidth / 2, this.mw.markerManager.groupList, false);
        int labelWigth = this.mw.mc.field_71466_p.func_78256_a(this.newGroupNameLabel);
        int newGroupNameWidth = this.windowWidth / 2 - labelWigth - 7;
        int renameButtonWidth = this.mw.mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.buttonRename", (Object[])new Object[0])) + 5;
        this.newGroupName = new GuiTextField(this.mw.mc.field_71466_p, this.posX + labelWigth + 10, this.posY + 47, newGroupNameWidth, this.mw.mc.field_71466_p.field_78288_b + 3);
        this.renameButton = new GuiButton(200, this.posX + 7, this.posY + 65, renameButtonWidth, 20, I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.buttonRename", (Object[])new Object[0]));
        this.field_146292_n.add(this.renameButton);
    }

    public boolean validateTextFieldData() {
        return this.newGroupName.func_146179_b().length() > 0;
    }

    public boolean isSystemGroup() {
        return this.groupComboBox.getSelectionElementName().equals("all") || this.groupComboBox.getSelectionElementName().equals("none");
    }

    public boolean isDuplicateNameInList(List<String> list, String name) {
        boolean result = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).equals(name)) {
                result = true;
                break;
            }
            result = false;
        }
        return result;
    }

    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146127_k == 200) {
            if (!this.validateTextFieldData()) {
                this.showErrorMessage = true;
                this.errorMessage = I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.errorEmptyName", (Object[])new Object[0]);
            } else if (this.isDuplicateNameInList(this.groupComboBox.getElementList(), this.newGroupName.func_146179_b())) {
                this.showErrorMessage = true;
                this.errorMessage = I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.errorDuplicateName", (Object[])new Object[0]);
            } else if (this.isSystemGroup()) {
                this.showErrorMessage = true;
                this.errorMessage = I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.errorSystemGroupName", (Object[])new Object[0]);
            } else {
                for (Marker marker : this.mw.markerManager.markerList) {
                    if (!marker.groupName.equals(this.groupComboBox.getSelectionElementName())) continue;
                    marker.setGroupName(this.newGroupName.func_146179_b());
                    this.mw.markerManager.update();
                    this.mw.markerManager.saveMarkersToFile();
                }
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.groupComboBox.func_73864_a(mouseX, mouseY, button);
        this.newGroupName.func_146192_a(mouseX, mouseY, button);
    }

    protected void func_73869_a(char c, int k) {
        if (k == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else {
            super.func_73869_a(c, k);
            this.groupComboBox.func_73869_a(c, k);
            this.newGroupName.func_146201_a(c, k);
        }
    }

    public void draw() {
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (this.parentScreen != null) {
            this.parentScreen.func_73863_a(mouseX, mouseY, f);
        } else {
            this.func_146276_q_();
        }
        MwGuiGroupManage.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + this.windowWidth / 2 + 12), (int)(this.posY + this.windowHeight), (int)Integer.MIN_VALUE);
        this.func_73732_a(this.mw.mc.field_71466_p, I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.title", (Object[])new Object[0]), this.posX + this.windowWidth / 4, this.posY + 5, 0xFFFFFF);
        this.func_73731_b(this.mw.mc.field_71466_p, I18n.func_135052_a((String)"mw.gui.mwguimanagegroup.renameGroup", (Object[])new Object[0]), this.posX + 7, this.posY + 17, 0xFFFFFF);
        Render.setColour(-1);
        Render.drawRectBorder(this.posX + 5, this.posY + 15, this.windowWidth / 2 + 2, 12.0, 1.0);
        Render.drawRectBorder(this.posX + 5, this.posY + 15, this.windowWidth / 2 + 2, this.windowHeight - 20, 1.0);
        this.func_73731_b(this.mw.mc.field_71466_p, this.newGroupNameLabel, this.posX + 7, this.groupComboBox.getPosY() + this.groupComboBox.getHeight() + 7, 0xFFFFFF);
        if (this.showErrorMessage) {
            this.mw.mc.field_71466_p.func_78279_b(this.errorMessage, this.posX + this.renameButton.field_146120_f + 10, this.renameButton.field_146129_i + (this.renameButton.field_146121_g - this.mw.mc.field_71466_p.field_78288_b) / 2 + 1, this.windowWidth / 2 - this.renameButton.field_146120_f - 10, 0xFF0000);
        }
        super.func_73863_a(mouseX, mouseY, f);
        this.newGroupName.func_146194_f();
        this.groupComboBox.draw(mouseX, mouseY);
    }
}

