/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mapwriter.MwUtil;
import mapwriter.Render;
import mapwriter.map.Marker;
import mapwriter.map.MarkerManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class MwGuiImportMarkerFromJM
extends GuiScreen {
    private final GuiScreen parentScreen;
    private MarkerManager markerManager;
    private int x;
    private int y;
    private int elementYSpacing = 10;
    private int textYSpacing = 2;
    private File jmWaypointsCurrentFolder;
    private ResourceLocation leftArrowTexture = new ResourceLocation("mapwriter", "textures/map/arrow_text_left.png");
    private ResourceLocation rightArrowTexture = new ResourceLocation("mapwriter", "textures/map/arrow_text_right.png");

    public MwGuiImportMarkerFromJM(GuiScreen parentScreen, MarkerManager markerManager) {
        this.parentScreen = parentScreen;
        this.markerManager = markerManager;
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.field_146297_k.func_147108_a(this.parentScreen);
            }
        }
    }

    public void func_73866_w_() {
        ArrayList worldNameList = new ArrayList();
        this.jmWaypointsCurrentFolder = MwUtil.getJMWaypointsFolder();
        int buttonWidth = 10 + this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.importButton", (Object[])new Object[0]));
        int buttonHeight = 20;
        int buttonChooseWidth = 10 + this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.chooseFolderButton", (Object[])new Object[0]));
        int w = 20 + this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.title", (Object[])new Object[0]));
        int h = 5 * this.elementYSpacing + 5 * this.textYSpacing + 8 * this.field_146289_q.field_78288_b + 35;
        int xPos = (this.field_146294_l - w) / 2;
        int yPos = (this.field_146295_m - h) / 2;
        this.field_146292_n.add(new GuiButton(200, xPos, yPos + h - buttonHeight, buttonWidth, buttonHeight, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.importButton", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(201, xPos + buttonWidth + 5, yPos + h - buttonHeight, buttonWidth, buttonHeight, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.cancelButton", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(202, xPos + w - buttonChooseWidth, yPos + h - buttonHeight, buttonChooseWidth, buttonHeight, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.chooseFolderButton", (Object[])new Object[0])));
    }

    public int getWidthMenu() {
        int[] maxWidth = new int[]{this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.title", (Object[])new Object[0])), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.currentWorldTitle", (Object[])new Object[0])), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.jmWaypointsCount", (Object[])new Object[0])), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text1", (Object[])new Object[0])), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text2", (Object[])new Object[0])), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text3", (Object[])new Object[0])), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text4", (Object[])new Object[0])), this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text5", (Object[])new Object[0]))};
        int max = maxWidth[0];
        for (int i = 0; i < maxWidth.length; ++i) {
            max = Math.max(max, maxWidth[i]);
        }
        return max;
    }

    public File getFolderNameFromJmWorldName(List<MwUtil.JmWorldList> folderList, String worldName) {
        File folderName = null;
        for (int i = 0; i < folderList.size(); ++i) {
            if (folderList.get(i).getWorldName().equals(worldName)) {
                folderName = folderList.get(i).getJmWorldFolder();
                break;
            }
            folderName = null;
        }
        return folderName;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.parentScreen.func_73863_a(mouseX, mouseY, f);
        this.func_146278_c(0);
        int w = 20 + this.getWidthMenu();
        int h = 5 * this.elementYSpacing + 5 * this.textYSpacing + 8 * this.field_146289_q.field_78288_b + 40;
        int xPos = (this.field_146294_l - w) / 2;
        int yPos = (this.field_146295_m - h) / 2;
        int waypointCount = this.jmWaypointsCurrentFolder.isDirectory() && this.jmWaypointsCurrentFolder.getName().equals("waypoints") && this.jmWaypointsCurrentFolder.list().length > 0 ? this.jmWaypointsCurrentFolder.list().length : 0;
        Render.drawRectBorder(xPos, yPos, w, h, 2.0);
        this.func_73732_a(this.field_146289_q, EnumChatFormatting.UNDERLINE + I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.title", (Object[])new Object[0]), this.field_146294_l / 2, yPos + this.elementYSpacing, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.currentWorldTitle", (Object[])new Object[]{EnumChatFormatting.GREEN + MwUtil.getCurrentMcWorldName(), MwUtil.getGameMode()}), xPos + 5, yPos + 2 * this.elementYSpacing + this.field_146289_q.field_78288_b, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.jmWaypointsCount", (Object[])new Object[]{EnumChatFormatting.GREEN + String.valueOf(waypointCount)}), xPos + 5, yPos + 3 * this.elementYSpacing + 3 * this.field_146289_q.field_78288_b, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text1", (Object[])new Object[0]), xPos + 5, (yPos += 5) + 4 * this.elementYSpacing + 3 * this.field_146289_q.field_78288_b, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text2", (Object[])new Object[0]), xPos + 5, yPos + 4 * this.elementYSpacing + this.textYSpacing + 4 * this.field_146289_q.field_78288_b, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text3", (Object[])new Object[0]), xPos + 5, yPos + 4 * this.elementYSpacing + 2 * this.textYSpacing + 5 * this.field_146289_q.field_78288_b, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text4", (Object[])new Object[0]), xPos + 5, yPos + 4 * this.elementYSpacing + 3 * this.textYSpacing + 6 * this.field_146289_q.field_78288_b, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"mw.gui.mwguimportmarkerfromjm.text5", (Object[])new Object[0]), xPos + 5, yPos + 4 * this.elementYSpacing + 4 * this.textYSpacing + 7 * this.field_146289_q.field_78288_b, -1);
        super.func_73863_a(mouseX, mouseY, f);
    }

    public void drawHelp(int mouseX, int mouseY) {
        MwGuiImportMarkerFromJM.func_73734_a((int)10, (int)20, (int)(this.field_146294_l - 20), (int)(this.field_146295_m - 30), (int)Integer.MIN_VALUE);
    }

    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146127_k == 200) {
            if (this.jmWaypointsCurrentFolder.isDirectory() && this.jmWaypointsCurrentFolder.list().length > 0) {
                ArrayList<Marker> markedDeletedList = new ArrayList<Marker>();
                for (int i = 0; i < this.markerManager.markerList.size(); ++i) {
                    if (!this.markerManager.markerList.get((int)i).groupName.equals("importJM")) continue;
                    markedDeletedList.add(this.markerManager.markerList.get(i));
                }
                this.markerManager.markerList.removeAll(markedDeletedList);
                this.markerManager.update();
                MwUtil.importMarkersFromJourneymap(this.markerManager, this.jmWaypointsCurrentFolder);
                this.field_146297_k.func_147108_a(this.parentScreen);
            }
        } else if (p_146284_1_.field_146127_k == 201) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else if (p_146284_1_.field_146127_k == 202) {
            String minecraftRootFolders = null;
            try {
                minecraftRootFolders = Minecraft.func_71410_x().field_71412_D.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String jmDataFolder = minecraftRootFolders + "\\journeymap\\data\\";
            jmDataFolder = MwUtil.getGameMode().equals("sp") ? jmDataFolder + "sp\\" : jmDataFolder + "mp\\";
            this.jmWaypointsCurrentFolder = MwUtil.chooseDirectory(jmDataFolder);
        }
    }
}

