/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mapwriter.Render;
import mapwriter.gui.MwColorPallete;
import mapwriter.map.Marker;
import mapwriter.map.MarkerManager;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MwGuiMarkerDialogNew
extends GuiScreen {
    private final GuiScreen parentScreen;
    String title = "";
    String titleNew = "mw.gui.mwguimarkerdialognew.title.new";
    String titleEdit = "mw.gui.mwguimarkerdialognew.title.edit";
    private String editMarkerName = "mw.gui.mwguimarkerdialognew.editMarkerName";
    private String editMarkerGroup = "mw.gui.mwguimarkerdialognew.editMarkerGroup";
    private String editMarkerX = "mw.gui.mwguimarkerdialognew.editMarkerX";
    private String editMarkerY = "mw.gui.mwguimarkerdialognew.editMarkerY";
    private String editMarkerZ = "mw.gui.mwguimarkerdialognew.editMarkerZ";
    ScrollableTextBox scrollableTextBoxName = null;
    ScrollableTextBox scrollableTextBoxGroup = null;
    ScrollableNumericTextBox scrollableNumericTextBoxX = null;
    ScrollableNumericTextBox scrollableNumericTextBoxY = null;
    ScrollableNumericTextBox scrollableNumericTextBoxZ = null;
    MwColorPallete markerColorPallete = null;
    boolean backToGameOnSubmit = false;
    static final int dialogWidthPercent = 40;
    static final int elementVSpacing = 20;
    private final MarkerManager markerManager;
    private Marker editingMarker;
    private String markerName = "";
    private String markerGroup = "";
    private int markerX = 0;
    private int markerY = 80;
    private int markerZ = 0;
    private int dimension = 0;
    private int currentColor;
    private int[] colours = null;
    private ResourceLocation leftArrowTexture = new ResourceLocation("mapwriter", "textures/map/arrow_text_left.png");
    private ResourceLocation rightArrowTexture = new ResourceLocation("mapwriter", "textures/map/arrow_text_right.png");

    public MwGuiMarkerDialogNew(GuiScreen parentScreen, MarkerManager markerManager, String markerName, String markerGroup, int x, int y, int z, int dimension) {
        this.markerManager = markerManager;
        this.markerName = markerName;
        this.markerGroup = markerGroup;
        this.markerX = x;
        this.markerY = y;
        this.markerZ = z;
        this.editingMarker = null;
        this.dimension = dimension;
        this.parentScreen = parentScreen;
        this.title = this.titleNew;
        this.colours = new int[Marker.getColours().length];
        for (int i = 0; i < Marker.getColours().length; ++i) {
            this.colours[i] = 0xFF000000 | Marker.getColours()[i];
        }
        this.currentColor = this.markerManager.selectedColor;
    }

    public MwGuiMarkerDialogNew(GuiScreen parentScreen, MarkerManager markerManager, Marker editingMarker) {
        this.markerManager = markerManager;
        this.editingMarker = editingMarker;
        this.markerName = editingMarker.name;
        this.markerGroup = editingMarker.groupName;
        this.markerX = editingMarker.x;
        this.markerY = editingMarker.y;
        this.markerZ = editingMarker.z;
        this.dimension = editingMarker.dimension;
        this.parentScreen = parentScreen;
        this.title = this.titleEdit;
        this.colours = new int[Marker.getColours().length];
        for (int i = 0; i < Marker.getColours().length; ++i) {
            this.colours[i] = 0xFF000000 | Marker.getColours()[i];
        }
        this.currentColor = editingMarker.colour;
    }

    public boolean submit() {
        boolean inputCorrect = true;
        if (this.scrollableTextBoxName.validateTextFieldData()) {
            this.markerName = this.scrollableTextBoxName.textField.func_146179_b();
        } else {
            inputCorrect = false;
        }
        if (this.scrollableTextBoxGroup.validateTextFieldData()) {
            this.markerGroup = this.scrollableTextBoxGroup.textField.func_146179_b();
        } else {
            inputCorrect = false;
        }
        if (this.scrollableNumericTextBoxX.validateTextFieldData()) {
            this.markerX = this.scrollableNumericTextBoxX.getTextFieldIntValue();
        } else {
            inputCorrect = false;
        }
        if (this.scrollableNumericTextBoxY.validateTextFieldData()) {
            this.markerY = this.scrollableNumericTextBoxY.getTextFieldIntValue();
        } else {
            inputCorrect = false;
        }
        if (this.scrollableNumericTextBoxZ.validateTextFieldData()) {
            this.markerZ = this.scrollableNumericTextBoxZ.getTextFieldIntValue();
        } else {
            inputCorrect = false;
        }
        if (inputCorrect) {
            int colour = this.markerColorPallete.getSelectedColor();
            if (this.editingMarker != null) {
                this.editingMarker.setMarkerName(this.markerName);
                this.editingMarker.setGroupName(this.markerGroup);
                this.editingMarker.setCoordX(this.markerX);
                this.editingMarker.setCoordY(this.markerY);
                this.editingMarker.setCoordZ(this.markerZ);
                this.editingMarker.setDimension(this.dimension);
                this.editingMarker.setColour(this.markerColorPallete.getSelectedColor());
                this.editingMarker = null;
            } else {
                this.markerManager.addMarker(this.markerName, this.markerGroup, this.markerX, this.markerY, this.markerZ, this.dimension, this.markerColorPallete.getSelectedColor());
            }
            this.markerManager.selectedColor = this.markerColorPallete.getSelectedColor();
            this.markerManager.setVisibleGroupName(this.markerGroup);
            this.markerManager.update();
            this.markerManager.saveMarkersToFile();
        }
        return inputCorrect;
    }

    public void func_73866_w_() {
        int labelsWidth = this.field_146289_q.func_78256_a("Group");
        int width = this.field_146294_l * 40 / 100 - labelsWidth;
        int x = (this.field_146294_l - width) / 2 + labelsWidth;
        int y = (this.field_146295_m - 100) / 2;
        this.scrollableTextBoxName = new ScrollableTextBox(x, y, width, I18n.func_135052_a((String)this.editMarkerName, (Object[])new Object[0]));
        this.scrollableTextBoxName.init();
        this.scrollableTextBoxName.textField.func_146195_b(true);
        this.scrollableTextBoxName.textField.func_146180_a(this.markerName);
        this.scrollableTextBoxGroup = new ScrollableTextBox(x, y + 20, width, I18n.func_135052_a((String)this.editMarkerGroup, (Object[])new Object[0]), this.markerManager.groupList);
        this.scrollableTextBoxGroup.init();
        this.scrollableTextBoxGroup.textField.func_146180_a(this.markerGroup);
        this.scrollableTextBoxGroup.setDrawArrows(true);
        this.scrollableNumericTextBoxX = new ScrollableNumericTextBox(x, y + 20 * 2, width, I18n.func_135052_a((String)this.editMarkerX, (Object[])new Object[0]));
        this.scrollableNumericTextBoxX.init();
        this.scrollableNumericTextBoxX.textField.func_146180_a("" + this.markerX);
        this.scrollableNumericTextBoxX.setDrawArrows(true);
        this.scrollableNumericTextBoxY = new ScrollableNumericTextBox(x, y + 20 * 3, width, I18n.func_135052_a((String)this.editMarkerY, (Object[])new Object[0]));
        this.scrollableNumericTextBoxY.init();
        this.scrollableNumericTextBoxY.textField.func_146180_a("" + this.markerY);
        this.scrollableNumericTextBoxY.setDrawArrows(true);
        this.scrollableNumericTextBoxZ = new ScrollableNumericTextBox(x, y + 20 * 4, width, I18n.func_135052_a((String)this.editMarkerZ, (Object[])new Object[0]));
        this.scrollableNumericTextBoxZ.init();
        this.scrollableNumericTextBoxZ.textField.func_146180_a("" + this.markerZ);
        this.scrollableNumericTextBoxZ.setDrawArrows(true);
        this.markerColorPallete = new MwColorPallete(x + this.scrollableTextBoxName.arrowsWidth, y + 20 * 5, this.scrollableTextBoxName.textFieldHeight, this.colours, this.currentColor, this.field_146294_l * 40 / 100, (this.field_146294_l - this.field_146294_l * 40 / 100) / 2);
        this.field_146292_n.add(new GuiButton(200, x + this.scrollableTextBoxName.arrowsWidth, y + 20 * 6 + this.markerColorPallete.getColorCellsRowCount() * (this.markerColorPallete.getPalleteHeight() + this.markerColorPallete.getColorCellVSpacing()), 60, 20, I18n.func_135052_a((String)"mw.gui.mwguimarkerdialognew.buttonSave", (Object[])new Object[0])));
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (this.parentScreen != null) {
            this.parentScreen.func_73863_a(mouseX, mouseY, f);
        } else {
            this.func_146276_q_();
        }
        int w = this.field_146294_l * 40 / 100;
        int y = (this.field_146295_m - 20 * 5) / 2 + 2;
        MwGuiMarkerDialogNew.func_73734_a((int)((this.field_146294_l - w) / 2), (int)((this.field_146295_m - 20 * 7) / 2 - 4), (int)((this.field_146294_l - w) / 2 + w), (int)((this.field_146295_m - 20 * 5) / 2 + 20 * 6 + 10 + 20 * this.field_146292_n.size() + this.markerColorPallete.getColorCellsRowCount() * this.markerColorPallete.getPalleteHeight() + (this.markerColorPallete.getColorCellsRowCount() - 1) * this.markerColorPallete.getColorCellVSpacing()), (int)Integer.MIN_VALUE);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)this.title, (Object[])new Object[0]), this.field_146294_l / 2, (this.field_146295_m - 20 * 6) / 2 - 20 / 4, 0xFFFFFF);
        this.scrollableTextBoxName.draw();
        this.scrollableTextBoxGroup.draw();
        this.scrollableNumericTextBoxX.draw();
        this.scrollableNumericTextBoxY.draw();
        this.scrollableNumericTextBoxZ.draw();
        int labelColorWidth = this.field_146289_q.func_78256_a(this.markerColorPallete.getpaletteLabel());
        int labelColorHeight = this.field_146289_q.field_78288_b;
        int labelColorX = this.markerColorPallete.getX() - labelColorWidth - this.scrollableTextBoxName.arrowsWidth - 4;
        int labelColorY = this.markerColorPallete.getY() + labelColorHeight / 2 - 2;
        this.func_73731_b(this.field_146289_q, "Colour", labelColorX, labelColorY, 0xFFFFFF);
        this.markerColorPallete.draw();
        super.func_73863_a(mouseX, mouseY, f);
    }

    public void func_146274_d() {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int direction = Mouse.getEventDWheel();
        if (direction != 0) {
            this.mouseDWheelScrolled(x, y, direction);
        }
        super.func_146274_d();
    }

    public void mouseDWheelScrolled(int x, int y, int direction) {
        this.scrollableTextBoxName.mouseDWheelScrolled(x, y, direction);
        this.scrollableTextBoxGroup.mouseDWheelScrolled(x, y, direction);
        this.scrollableNumericTextBoxX.mouseDWheelScrolled(x, y, direction);
        this.scrollableNumericTextBoxY.mouseDWheelScrolled(x, y, direction);
        this.scrollableNumericTextBoxZ.mouseDWheelScrolled(x, y, direction);
        for (int i = 0; i < this.markerColorPallete.colorCells.size(); ++i) {
            this.markerColorPallete.colorCells.get(i).mouseDWheelScrolled(x, y, direction);
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.scrollableTextBoxName.mouseClicked(x, y, button);
        this.scrollableTextBoxGroup.mouseClicked(x, y, button);
        this.scrollableNumericTextBoxX.mouseClicked(x, y, button);
        this.scrollableNumericTextBoxY.mouseClicked(x, y, button);
        this.scrollableNumericTextBoxZ.mouseClicked(x, y, button);
        for (int i = 0; i < this.markerColorPallete.colorCells.size(); ++i) {
            this.markerColorPallete.colorCells.get(i).mouseClicked(x, y, button);
        }
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.field_146297_k.func_147108_a(this.parentScreen);
                break;
            }
            case 28: {
                if (!this.submit()) break;
                if (!this.backToGameOnSubmit) {
                    this.field_146297_k.func_147108_a(this.parentScreen);
                    break;
                }
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 15: {
                GuiTextField thistextField = null;
                GuiTextField prevtextField = null;
                GuiTextField nexttextField = null;
                if (this.scrollableTextBoxName.textField.func_146206_l()) {
                    thistextField = this.scrollableTextBoxName.textField;
                    prevtextField = this.scrollableNumericTextBoxZ.textField;
                    nexttextField = this.scrollableTextBoxGroup.textField;
                } else if (this.scrollableTextBoxGroup.textField.func_146206_l()) {
                    thistextField = this.scrollableTextBoxGroup.textField;
                    prevtextField = this.scrollableTextBoxName.textField;
                    nexttextField = this.scrollableNumericTextBoxX.textField;
                } else if (this.scrollableNumericTextBoxX.textField.func_146206_l()) {
                    thistextField = this.scrollableNumericTextBoxX.textField;
                    prevtextField = this.scrollableTextBoxGroup.textField;
                    nexttextField = this.scrollableNumericTextBoxY.textField;
                } else if (this.scrollableNumericTextBoxY.textField.func_146206_l()) {
                    thistextField = this.scrollableNumericTextBoxY.textField;
                    prevtextField = this.scrollableNumericTextBoxX.textField;
                    nexttextField = this.scrollableNumericTextBoxZ.textField;
                } else if (this.scrollableNumericTextBoxZ.textField.func_146206_l()) {
                    thistextField = this.scrollableNumericTextBoxZ.textField;
                    prevtextField = this.scrollableNumericTextBoxY.textField;
                    nexttextField = this.scrollableTextBoxName.textField;
                }
                thistextField.func_146195_b(false);
                thistextField.func_146202_e();
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    prevtextField.func_146195_b(true);
                    prevtextField.func_146199_i(0);
                    break;
                }
                nexttextField.func_146195_b(true);
                nexttextField.func_146199_i(0);
                break;
            }
            default: {
                if (this.scrollableTextBoxName.textField.func_146206_l()) {
                    this.scrollableTextBoxName.textField.func_146201_a(c, key);
                    break;
                }
                if (this.scrollableTextBoxGroup.textField.func_146206_l()) {
                    this.scrollableTextBoxGroup.textField.func_146201_a(c, key);
                    break;
                }
                if (this.scrollableNumericTextBoxX.textField.func_146206_l()) {
                    this.scrollableNumericTextBoxX.validateTextboxKeyTyped(c, key);
                    break;
                }
                if (this.scrollableNumericTextBoxY.textField.func_146206_l()) {
                    this.scrollableNumericTextBoxY.validateTextboxKeyTyped(c, key);
                    break;
                }
                if (!this.scrollableNumericTextBoxZ.textField.func_146206_l()) break;
                this.scrollableNumericTextBoxZ.validateTextboxKeyTyped(c, key);
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 200 && this.submit()) {
            if (!this.backToGameOnSubmit) {
                this.field_146297_k.func_147108_a(this.parentScreen);
            } else {
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    class ScrollableNumericTextBox
    extends ScrollableTextBox {
        public ScrollableNumericTextBox(int x, int y, int width, String label) {
            super(x, y, width, label);
        }

        @Override
        public void textFieldScroll(int direction) {
            if (this.validateTextFieldData()) {
                int value = this.getTextFieldIntValue();
                if (direction > 0) {
                    this.textField.func_146180_a("" + (value + 1));
                } else if (direction < 0) {
                    this.textField.func_146180_a("" + (value - 1));
                }
            }
        }

        public int getTextFieldIntValue() {
            return Integer.parseInt(this.textField.func_146179_b());
        }

        public void validateTextboxKeyTyped(char c, int key) {
            if (c >= '0' && c <= '9' || key == 14 || key == 203 || key == 205 || c == '-' && this.textField.func_146198_h() == 0) {
                this.textField.func_146201_a(c, key);
            }
        }
    }

    class ScrollableTextBox {
        public int x;
        public int y;
        public int width;
        public int labelX;
        public int labelY;
        public int labelWidth;
        public int labelHeight;
        public String label;
        public boolean drawArrows = false;
        public int leftArrowX;
        public int rightArrowX;
        public int arrowsY;
        public int arrowsWidth = 7;
        public int arrowsHeight = 12;
        public int textFieldX;
        public int textFieldY;
        public int textFieldWidth;
        public int textFieldHeight = 12;
        public List<String> scrollableElements;
        public GuiTextField textField = null;

        ScrollableTextBox(int x, int y, int width, String label) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.label = label;
        }

        ScrollableTextBox(int x, int y, int width, String label, List<String> scrollableElements) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.label = label;
            this.scrollableElements = scrollableElements;
        }

        public void init() {
            this.textFieldX = this.x + this.arrowsWidth;
            this.textFieldY = this.y;
            this.textFieldWidth = this.width - this.arrowsWidth * 2 - 25;
            this.labelWidth = MwGuiMarkerDialogNew.this.field_146289_q.func_78256_a(this.label);
            this.labelHeight = ((MwGuiMarkerDialogNew)MwGuiMarkerDialogNew.this).field_146289_q.field_78288_b;
            this.labelX = this.x - this.labelWidth - 4;
            this.labelY = this.y + this.labelHeight / 2 - 2;
            this.leftArrowX = this.x - 1;
            this.rightArrowX = this.textFieldX + this.textFieldWidth + 1;
            this.arrowsY = this.y;
            this.textField = new GuiTextField(MwGuiMarkerDialogNew.this.field_146289_q, this.textFieldX, this.textFieldY, this.textFieldWidth, this.textFieldHeight);
            this.textField.func_146203_f(32);
        }

        public void draw() {
            MwGuiMarkerDialogNew screen = MwGuiMarkerDialogNew.this;
            screen.func_73731_b(screen.field_146289_q, this.label, this.labelX, this.labelY, 0xFFFFFF);
            if (this.drawArrows) {
                screen.field_146297_k.field_71446_o.func_110577_a(screen.leftArrowTexture);
                Render.drawTexturedRect(this.leftArrowX, this.arrowsY, this.arrowsWidth, this.arrowsHeight, 0.0, 0.0, 1.0, 1.0);
                MwGuiMarkerDialogNew.this.field_146297_k.field_71446_o.func_110577_a(screen.rightArrowTexture);
                Render.drawTexturedRect(this.rightArrowX, this.arrowsY, this.arrowsWidth, this.arrowsHeight, 0.0, 0.0, 1.0, 1.0);
            }
            this.textField.func_146194_f();
            if (!this.validateTextFieldData()) {
                Gui.func_73734_a((int)(this.textFieldX - 1), (int)(this.textFieldY - 1), (int)(this.textFieldX + this.textFieldWidth + 1), (int)this.textFieldY, (int)-7340032);
                Gui.func_73734_a((int)(this.textFieldX - 1), (int)(this.textFieldY - 1), (int)this.textFieldX, (int)(this.textFieldY + this.textFieldHeight + 1), (int)-7340032);
                Gui.func_73734_a((int)(this.textFieldX + this.textFieldWidth + 1), (int)(this.textFieldY + this.textFieldHeight + 1), (int)this.textFieldX, (int)(this.textFieldY + this.textFieldHeight), (int)-7340032);
                Gui.func_73734_a((int)(this.textFieldX + this.textFieldWidth + 1), (int)(this.textFieldY + this.textFieldHeight + 1), (int)(this.textFieldX + this.textFieldWidth), (int)this.textFieldY, (int)-7340032);
            }
        }

        public void mouseClicked(int x, int y, int button) {
            int direction = this.posWithinArrows(x, y);
            if (direction != 0) {
                this.textFieldScroll(direction);
            }
            this.textField.func_146192_a(x, y, button);
        }

        public void setDrawArrows(boolean value) {
            this.drawArrows = value;
        }

        public void mouseDWheelScrolled(int x, int y, int direction) {
            if (this.posWithinTextField(x, y)) {
                this.textFieldScroll(-direction);
            }
        }

        public boolean validateTextFieldData() {
            return this.textField.func_146179_b().length() > 0;
        }

        public int posWithinArrows(int x, int y) {
            if (x >= this.leftArrowX && y >= this.arrowsY && x <= this.arrowsWidth + this.leftArrowX && y <= this.arrowsHeight + this.arrowsY) {
                return -1;
            }
            if (x >= this.rightArrowX && y >= this.arrowsY && x <= this.arrowsWidth + this.rightArrowX && y <= this.arrowsHeight + this.arrowsY) {
                return 1;
            }
            return 0;
        }

        public boolean posWithinTextField(int x, int y) {
            return x >= this.textFieldX && y >= this.textFieldY && x <= this.textFieldWidth + this.textFieldX && y <= this.textFieldHeight + this.textFieldY;
        }

        public void textFieldScroll(int direction) {
            if (this.scrollableElements != null) {
                int index = this.scrollableElements.indexOf(this.textField.func_146179_b().trim());
                if (direction > 0) {
                    index = index == -1 || index == this.scrollableElements.size() - 1 ? 0 : ++index;
                } else if (direction < 0) {
                    index = index == -1 || index == 0 ? this.scrollableElements.size() - 1 : --index;
                }
                this.textField.func_146180_a(this.scrollableElements.get(index));
            }
        }
    }
}

