/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import cpw.mods.fml.client.config.GuiCheckBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mapwriter.Mw;
import mapwriter.map.Marker;
import mapwriter.map.SearchMarker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;

public class MwGuiMarkerManageSlot
extends GuiSlot {
    private Minecraft mc;
    private Mw mw;
    private int mouseX = 0;
    private int mouseY = 0;
    private final GuiScreen parentScreen;
    private boolean mouseButton1 = false;
    public List<Marker> markerList;
    public List<GuiCheckBox> checkBoxes = new ArrayList<GuiCheckBox>();
    public List<SearchMarker> searchMarkerList = new ArrayList<SearchMarker>();
    public List<Integer> checkboxesId = new ArrayList<Integer>();
    public HashMap<Integer, Boolean> checkboxesEnabled = new HashMap();

    public MwGuiMarkerManageSlot(GuiScreen parentScreen, Minecraft mc, Mw mw) {
        super(mc, parentScreen.field_146294_l + 60, parentScreen.field_146295_m, 50, parentScreen.field_146295_m - 140, 16);
        this.parentScreen = parentScreen;
        this.mw = mw;
        this.mc = mc;
        this.markerList = mw.markerManager.visibleMarkerList;
        this.updateMarkerList("");
    }

    public void updateMarkerList(String text) {
        int slotIndex = 0;
        this.checkBoxes.clear();
        this.checkboxesId.clear();
        this.searchMarkerList.clear();
        this.checkboxesEnabled.clear();
        int buttonSizeX = 15;
        for (int i = 0; i < this.markerList.size(); ++i) {
            String markerName = this.markerList.get((int)i).name;
            int markerColor = this.markerList.get((int)i).colour;
            String coordinates = this.markerList.get((int)i).x + ": " + this.markerList.get((int)i).z;
            Marker marker = this.markerList.get(i);
            if (!text.equals("") && !marker.name.toLowerCase().contains(text.toLowerCase()) || marker.dimension != this.mw.playerDimension) continue;
            this.searchMarkerList.add(new SearchMarker(markerName, coordinates, markerColor));
            this.checkBoxes.add(new GuiCheckBox(400 + i, 0, 0, "", false));
            this.checkboxesId.add(i);
            this.checkboxesEnabled.put(slotIndex, false);
            ++slotIndex;
        }
    }

    protected int func_148127_b() {
        return this.checkBoxes.size();
    }

    protected void func_148144_a(int i, boolean doubleClicked, int x, int y) {
    }

    protected void checkBoxClicked(int index) {
        this.checkBoxes.get(index).setIsChecked(!this.checkBoxes.get(index).isChecked());
        this.checkboxesEnabled.put(index, this.checkboxesEnabled.get(index) == false);
    }

    public int getMarkerNameFieldWidth() {
        return 200;
    }

    public int getCoordinatesFieldWidth() {
        return 120;
    }

    public int getDistanceFieldWidth() {
        return 50;
    }

    public int getCompassPointFieldWidth() {
        return 20;
    }

    public int getFullMarkerFieldWidth() {
        return this.getMarkerNameFieldWidth() + this.getCoordinatesFieldWidth() + this.getDistanceFieldWidth() + this.getCompassPointFieldWidth();
    }

    public int getStartPosX() {
        return Math.max(this.func_148137_d() - this.getFullMarkerFieldWidth() - 15, 15);
    }

    public int getDiffWidthSlotScrollBar() {
        return this.func_148137_d() - this.getStartPosX() - this.getFullMarkerFieldWidth() - 5;
    }

    public boolean isInsideMarkerManageSlots(int mouseX, int mouseY) {
        int startXDetect = this.getStartPosX();
        int endXDetect = this.getStartPosX() + 12;
        int startYDetect = this.field_148153_b;
        int endYDetect = this.field_148154_c;
        return mouseX > startXDetect && mouseX < endXDetect && mouseY > startYDetect && mouseY < endYDetect;
    }

    public String getTrimRightString(String text, int overlaps) {
        String trimmedText;
        int count = 0;
        int fullTextPixelSize = this.mc.field_71466_p.func_78256_a(text);
        do {
            trimmedText = text.substring(0, text.length() - count);
            ++count;
        } while (this.mc.field_71466_p.func_78256_a(text) - this.mc.field_71466_p.func_78256_a(trimmedText) <= overlaps);
        return trimmedText;
    }

    public void func_148128_a(int mouseX, int mouseY, float f) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (Mouse.isButtonDown((int)0) && !this.mouseButton1) {
            int selectedIndex = this.func_148124_c(this.field_148155_a / 2, mouseY);
            if (this.isInsideMarkerManageSlots(mouseX, mouseY) && selectedIndex >= 0) {
                this.checkBoxClicked(selectedIndex);
            }
        }
        super.func_148128_a(mouseX, mouseY, f);
    }

    protected boolean func_148131_a(int p_148131_1_) {
        return false;
    }

    protected void func_148123_a() {
    }

    protected void func_148126_a(int i, int x, int y, int i4, Tessellator tessellator, int i5, int i6) {
        this.mouseButton1 = Mouse.isButtonDown((int)0);
        int textYShift = 0;
        GuiButton button = (GuiButton)this.checkBoxes.get(i);
        button.field_146128_h = this.getStartPosX();
        button.field_146129_i = y;
        String markerName = this.searchMarkerList.get(i).getMarkerName();
        String coordinates = this.searchMarkerList.get(i).getCoordinates();
        int markerNamePixelSize = this.mc.field_71466_p.func_78256_a(markerName);
        int coordinatesPixelSize = this.mc.field_71466_p.func_78256_a(coordinates);
        int startPosX = this.getStartPosX() + this.getMarkerNameFieldWidth() + this.getDiffWidthSlotScrollBar();
        int textShift = this.getCoordinatesFieldWidth() - coordinatesPixelSize;
        button.func_73731_b(this.mc.field_71466_p, coordinates, startPosX + textShift, y + textYShift, this.searchMarkerList.get(i).getStringColor());
        int overlaps = this.getStartPosX() + markerNamePixelSize - startPosX - textShift;
        overlaps = overlaps > 0 ? overlaps : 0;
        markerName = overlaps <= 0 ? markerName : this.getTrimRightString(markerName, overlaps);
        button.func_73731_b(this.mc.field_71466_p, markerName, this.getStartPosX() + 15, y + textYShift, this.searchMarkerList.get(i).getStringColor());
        button.func_146112_a(this.mc, this.mouseX, this.mouseY);
    }
}

