/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.ArrayList;
import java.util.List;
import mapwriter.Mw;
import mapwriter.MwUtil;
import mapwriter.map.Marker;
import mapwriter.map.SearchMarker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;

public class MwGuiMarkerSlot
extends GuiSlot {
    private Minecraft mc;
    private Mw mw;
    private int mouseX = 0;
    private int mouseY = 0;
    private final GuiScreen parentScreen;
    public List<Marker> markerList;
    public List<GuiButton> buttons = new ArrayList<GuiButton>();
    public List<SearchMarker> searchMarkerList = new ArrayList<SearchMarker>();
    public List<Integer> buttonId = new ArrayList<Integer>();

    public MwGuiMarkerSlot(GuiScreen parentScreen, Minecraft mc, Mw mw) {
        super(mc, parentScreen.field_146294_l + 60, parentScreen.field_146295_m, 50, parentScreen.field_146295_m - 40, 24);
        this.parentScreen = parentScreen;
        this.mw = mw;
        this.mc = mc;
        this.markerList = mw.markerManager.visibleMarkerList;
        this.updateMarkerList("");
    }

    public void updateMarkerList(String text) {
        this.buttons.clear();
        this.buttonId.clear();
        this.searchMarkerList.clear();
        this.func_148130_a(true);
        int buttonSizeX = 100;
        for (int i = 0; i < this.markerList.size(); ++i) {
            List targetInfo = MwUtil.getTargetInfo(this.mw.playerXInt, this.mw.playerZInt, this.markerList.get((int)i).x, this.markerList.get((int)i).z);
            String markerName = this.markerList.get((int)i).name;
            int markerColor = this.markerList.get((int)i).colour;
            String coordinates = this.markerList.get((int)i).x + ": " + this.markerList.get((int)i).z;
            String compassPoint = targetInfo.get(0).toString();
            int distance2Target = Integer.parseInt(targetInfo.get(1).toString());
            int color = distance2Target <= 200 ? -16711936 : (distance2Target > 200 && distance2Target <= 500 ? -256 : -65536);
            Marker marker = this.markerList.get(i);
            if (!text.equals("") && !marker.name.toLowerCase().contains(text.toLowerCase()) || marker.dimension != this.mw.playerDimension) continue;
            this.searchMarkerList.add(new SearchMarker(markerName, coordinates, distance2Target, color, compassPoint, markerColor));
            this.buttons.add(new GuiButton(400 + i, 0, 0, buttonSizeX, 20, ""));
            this.buttonId.add(i);
        }
    }

    protected int func_148127_b() {
        return this.buttons.size();
    }

    protected void func_148144_a(int i, boolean doubleClicked, int x, int y) {
        this.mw.markerManager.selectedMarker = this.markerList.get(this.buttonId.get(i));
        this.mw.mwGui.mapView.setViewCentreScaled(this.mw.markerManager.selectedMarker.x, this.mw.markerManager.selectedMarker.z, 0);
        this.mw.mwGui.backFromMarkerSearch = true;
        this.mw.setTextureSize();
        this.mc.func_147108_a((GuiScreen)this.mw.mwGui);
    }

    public int getMarkerNameFieldWidth() {
        return 200;
    }

    public int getCoordinatesFieldWidth() {
        return 120;
    }

    public int getDistanceFieldWidth() {
        return 50;
    }

    public int getCompassPointFieldWidth() {
        return 20;
    }

    public int getFullMarkerFieldWidth() {
        return this.getMarkerNameFieldWidth() + this.getCoordinatesFieldWidth() + this.getDistanceFieldWidth() + this.getCompassPointFieldWidth();
    }

    public int getStartPosX() {
        return Math.max(this.func_148137_d() - this.getFullMarkerFieldWidth() - 15, 15);
    }

    public int getDiffWidthSlotScrollBar() {
        return this.func_148137_d() - this.getStartPosX() - this.getFullMarkerFieldWidth() - 5;
    }

    public boolean isInsideMarkerSlots(int mouseX, int mouseY) {
        int startXDetect = this.getStartPosX();
        int endXDetect = this.getDiffWidthSlotScrollBar() > 0 ? this.getStartPosX() + this.getFullMarkerFieldWidth() : this.getStartPosX() + this.getFullMarkerFieldWidth() + this.getDiffWidthSlotScrollBar();
        int startYDetect = this.field_148153_b;
        int endYDetect = this.field_148154_c;
        return mouseX > startXDetect && mouseX < endXDetect && mouseY > startYDetect && mouseY < endYDetect;
    }

    public String getTrimRightString(String text, int overlaps) {
        String trimmedText;
        int count = 0;
        int fullTextPixelSize = this.mc.field_71466_p.func_78256_a(text);
        do {
            trimmedText = text.substring(0, text.length() - count);
            ++count;
        } while (this.mc.field_71466_p.func_78256_a(text) - this.mc.field_71466_p.func_78256_a(trimmedText) <= overlaps);
        return trimmedText;
    }

    public void func_148128_a(int mouseX, int mouseY, float f) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (Mouse.isButtonDown((int)0) && this.func_148125_i()) {
            int selectedIndex = this.func_148124_c(this.field_148155_a / 2, mouseY);
            if (this.isInsideMarkerSlots(mouseX, mouseY) && selectedIndex >= 0 && Mouse.getEventButton() != -1) {
                this.func_148144_a(selectedIndex, false, mouseX, mouseY);
            }
        }
        super.func_148128_a(mouseX, mouseY, f);
    }

    protected boolean func_148131_a(int p_148131_1_) {
        return false;
    }

    protected void func_148123_a() {
    }

    protected void func_148126_a(int i, int x, int y, int i4, Tessellator tessellator, int i5, int i6) {
        int textYShift = this.mc.field_71466_p.field_78288_b / 2;
        GuiButton button = this.buttons.get(i);
        button.field_146128_h = this.getStartPosX();
        button.field_146129_i = y;
        String markerName = this.searchMarkerList.get(i).getMarkerName();
        String coordinates = this.searchMarkerList.get(i).getCoordinates();
        String distance = String.valueOf(this.searchMarkerList.get(i).getDistance()) + "m";
        String compassPoint = this.searchMarkerList.get(i).getCompassPoint();
        int markerNamePixelSize = this.mc.field_71466_p.func_78256_a(markerName);
        int coordinatesPixelSize = this.mc.field_71466_p.func_78256_a(coordinates);
        int distancePixelsSize = this.mc.field_71466_p.func_78256_a(distance);
        int compassPointPixelsSize = this.mc.field_71466_p.func_78256_a(compassPoint);
        int startPosX = this.getStartPosX() + this.getMarkerNameFieldWidth() + this.getDiffWidthSlotScrollBar();
        int textShift = this.getCoordinatesFieldWidth() - coordinatesPixelSize;
        button.func_73731_b(this.mc.field_71466_p, coordinates, startPosX + textShift, y + textYShift, -1);
        int overlaps = this.getStartPosX() + markerNamePixelSize - startPosX - textShift;
        overlaps = overlaps > 0 ? overlaps : 0;
        markerName = overlaps <= 0 ? markerName : this.getTrimRightString(markerName, overlaps);
        button.func_73731_b(this.mc.field_71466_p, markerName, this.getStartPosX(), y + textYShift, this.mw.colorMarkerNameSearchMode == 1 ? this.searchMarkerList.get(i).getStringColor() : -1);
        textShift = this.getDistanceFieldWidth() - distancePixelsSize;
        button.func_73731_b(this.mc.field_71466_p, distance, (startPosX += this.getCoordinatesFieldWidth()) + textShift, y + textYShift, this.mw.colorMarkerDistanceSearchMode == 1 ? this.searchMarkerList.get(i).getDistanceColor() : -1);
        textShift = this.getCompassPointFieldWidth() - compassPointPixelsSize;
        button.func_73731_b(this.mc.field_71466_p, compassPoint, (startPosX += this.getDistanceFieldWidth()) + textShift, y + textYShift, -1);
    }
}

