/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.map;

import java.awt.geom.Point2D;
import mapwriter.Render;
import mapwriter.map.MapView;
import mapwriter.map.MarkerManager;
import mapwriter.map.mapmode.MapMode;

public class Marker {
    public String name;
    public String groupName;
    public int x;
    public int y;
    public int z;
    public int dimension;
    public int colour;
    public Point2D.Double screenPos = new Point2D.Double(0.0, 0.0);
    private static int[] colours = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0xFF8000, 0x8000FF, 9849600, 25600};
    private static int colourIndex = 0;

    public Marker(String name, String groupName, int x, int y, int z, int dimension, int colour) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.colour = colour;
        this.groupName = groupName;
    }

    public void setMarkerName(String name) {
        this.name = name;
    }

    public void setGroupName(String newGroupName) {
        this.groupName = newGroupName;
    }

    public void setCoordX(int x) {
        this.x = x;
    }

    public void setCoordY(int y) {
        this.y = y;
    }

    public void setCoordZ(int z) {
        this.z = z;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setColour(int colour) {
        this.colour = colour;
    }

    public String getString() {
        return String.format("%s %s (%d, %d, %d) %d %06x", this.name, this.groupName, this.x, this.y, this.z, this.dimension, this.colour & 0xFFFFFF);
    }

    public static int getCurrentColour() {
        return 0xFF000000 | colours[colourIndex];
    }

    public static int[] getColours() {
        return colours;
    }

    public void colourNext(MarkerManager markerManager, Marker marker) {
        colourIndex = (this.getIndexFromColor(marker.colour) + 1) % colours.length;
        markerManager.selectedColor = this.colour = Marker.getCurrentColour();
    }

    public void colourPrev(MarkerManager markerManager, Marker marker) {
        colourIndex = (this.getIndexFromColor(marker.colour) + colours.length - 1) % colours.length;
        markerManager.selectedColor = this.colour = Marker.getCurrentColour();
    }

    public int getIndexFromColor(int color) {
        for (int i = 0; i < colours.length; ++i) {
            if ((0xFF000000 | colours[i]) != color) continue;
            return i;
        }
        return 0;
    }

    public void draw(MapMode mapMode, MapView mapView, int borderColour) {
        double scale = mapView.getDimensionScaling(this.dimension);
        Point2D.Double p = mapMode.getClampedScreenXY(mapView, (double)this.x * scale, (double)this.z * scale);
        this.screenPos.setLocation(p.x + (double)mapMode.xTranslation, p.y + (double)mapMode.yTranslation);
        double mSize = mapMode.markerSize;
        double halfMSize = (double)mapMode.markerSize / 2.0;
        Render.setColour(borderColour);
        Render.drawRect(p.x - halfMSize, p.y - halfMSize, mSize, mSize);
        Render.setColour(this.colour);
        Render.drawRect(p.x - halfMSize + 0.5, p.y - halfMSize + 0.5, mSize - 1.0, mSize - 1.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Marker) {
            Marker m = (Marker)o;
            return this.name == m.name && this.groupName == m.groupName && this.x == m.x && this.y == m.y && this.z == m.z && this.dimension == m.dimension;
        }
        return false;
    }
}

